/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.StopableThread;

public class WaitRemover
extends StopableThread {
    private static Logger logger = LogManager.getLogger((String)"processor");
    private DialUpNas nas;
    private int maxWaitTimeout = 900;

    public WaitRemover(DefaultServerSetup setup, DialUpNas nas) {
        this.nas = nas;
        this.maxWaitTimeout = setup.getInt("max.wait.timeout", this.maxWaitTimeout);
        if (nas.getWorkMode() == 1) {
            logger.info("Starting wait remover timeout=" + this.maxWaitTimeout + " " + nas.getNasIdentifier());
            this.start();
        }
    }

    public void run() {
        logger.info("Starting WaitRemover for " + this.nas);
        while (this.working) {
            try {
                long now = System.currentTimeMillis();
                for (DialUpNasConnection con : this.nas.connections()) {
                    long startTime;
                    long timeAfterCreate;
                    DialUpSessionRealtime session = (DialUpSessionRealtime)con.getSession();
                    if (con.getStatus() != NasConnection.Status.waiting || (timeAfterCreate = (now - (startTime = session.getStartTime().getTimeInMillis())) / 1000L) <= (long)this.maxWaitTimeout) continue;
                    session.addLogInfo("Removing WAIT session, time after create: " + timeAfterCreate);
                    this.nas.dropConnection(session.getNasPort());
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            try {
                WaitRemover.sleep((long)60000L);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("Stopping WaitRemover for " + this.nas);
    }
}

