/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.ChannelMapping;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cerbercrypt.ByteSerializer;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cerbercrypt.CerbercryptServerConnection;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cerbercrypt.ChangeSubscriptionRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cerbercrypt.ChangeSubscriptionResponse;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cerbercrypt.GetSubscriptionRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cerbercrypt.GetSubscriptionResponse;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cerbercrypt.Request;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class CerbercryptServiceActivator
extends DigitalTVServiceActivator {
    private static final Logger log = LogManager.getLogger();
    private boolean cancelSendToAllServers = true;
    private Map<Integer, CerbercryptServerConnection> connections = new HashMap<Integer, CerbercryptServerConnection>();
    private static final byte[] emptyMask = new byte[16];

    public CerbercryptServiceActivator(ParameterMap moduleSetup, Connection con, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, con, conSlave, mid, time);
    }

    private CerbercryptServerConnection getConnection(Integer id) throws BGException {
        CerbercryptServerConnection result = this.connections.get(id);
        if (result == null) {
            ParameterMap moduleSetup = this.getModuleSetup(null);
            String host = moduleSetup.get("server." + id + ".host", null);
            int port = moduleSetup.getInt("server." + id + ".port", 0);
            String login = moduleSetup.get("server." + id + ".login", null);
            String pswd = moduleSetup.get("server." + id + ".pswd", null);
            int timeout = moduleSetup.getInt("server." + id + ".timeout", -1);
            if (Utils.isEmptyString((String)host) || port <= 0) {
                throw new BGException("Host and port for server " + id + " undefined!");
            }
            if (Utils.isBlankString((String)login) || Utils.isBlankString((String)pswd)) {
                throw new BGException("Login or pswd for server " + id + " undefined!");
            }
            result = new CerbercryptServerConnection();
            result.setHost(host);
            result.setPort(port);
            result.setLogin(login);
            result.setPswd(pswd);
            result.setTimeout(timeout);
            try {
                result.auth();
            }
            catch (Exception e) {
                log.error("Error connect host: " + host + "; port: " + port + "; login: " + login + "; pswd: " + pswd, (Throwable)e);
                throw new BGException((Throwable)e);
            }
            this.connections.put(id, result);
        }
        return result;
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        Object loginfo = "Requests:\n";
        block2: for (Map.Entry<Integer, List<String>> e : this.getCardServerMaskMap(cardPacketList).entrySet()) {
            byte[] mask = new byte[16];
            List<String> channels = e.getValue();
            int size = channels.size();
            for (int i = 0; i < size; ++i) {
                int channelCode = Utils.parseInt((String)channels.get(i));
                Request.addChannelToMask(mask, channelCode);
            }
            ChangeSubscriptionRequest request = new ChangeSubscriptionRequest();
            request.setFromCard(card.getNumber());
            request.setToCard(card.getNumber());
            request.setChannelMask(mask);
            String logline = "Set card: " + card.getNumber() + "; channels: " + ByteSerializer.maskToEnum(mask, 1) + " (mask: " + Utils.bytesToString((byte[])mask) + ")";
            log.info(logline);
            loginfo = (String)loginfo + logline + "\n";
            CerbercryptServerConnection connection = this.getConnection(e.getKey());
            try {
                int i = 0;
                while (true) {
                    ChangeSubscriptionResponse response;
                    if ((response = (ChangeSubscriptionResponse)connection.sendRequest(request)).getStatus() != 0) {
                        return new DigitalTVServiceActivator.ServiceActivationResult(false, "Incorrect response status: " + response.getStatus(), (String)loginfo, null);
                    }
                    if (CerbercryptServiceActivator.checkGetSubscription(connection, card.getNumber(), mask)) continue block2;
                    log.warn("subscription not equals!");
                    loginfo = (String)loginfo + "subscription not equals!\n";
                    if (i == 4) {
                        return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041d\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443", (String)loginfo, null);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", (String)loginfo, ex);
            }
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", (String)loginfo, null);
    }

    private static boolean checkGetSubscription(CerbercryptServerConnection connection, long cardNumber, byte[] mask) throws Exception {
        GetSubscriptionRequest request_gs = new GetSubscriptionRequest();
        request_gs.setFromCard(cardNumber);
        request_gs.setToCard(cardNumber);
        GetSubscriptionResponse response_gs = (GetSubscriptionResponse)connection.sendRequest(request_gs);
        GetSubscriptionResponse.CardStatus csl0 = response_gs.getCardStatusList().get(0);
        return Arrays.equals(csl0.mask, mask);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        if (this.cancelSendToAllServers) {
            return this.cancelImpl(card.getNumber());
        }
        Object loginfo = "Requests:\n";
        for (Map.Entry<Integer, List<String>> e : this.getCardServerMaskMap(cardPacketList).entrySet()) {
            ChangeSubscriptionRequest request = new ChangeSubscriptionRequest();
            request.setFromCard(card.getNumber());
            request.setToCard(card.getNumber());
            request.setChannelMask(emptyMask);
            String line = "Closing card: " + card.getNumber() + " (server: #" + e.getKey() + ", mask: " + Utils.bytesToString((byte[])emptyMask) + ")";
            log.info(line);
            loginfo = (String)loginfo + line + "\n";
            CerbercryptServerConnection connection = this.getConnection(e.getKey());
            try {
                ChangeSubscriptionResponse response = (ChangeSubscriptionResponse)connection.sendRequest(request);
                if (response.getStatus() == 0) continue;
                return new DigitalTVServiceActivator.ServiceActivationResult(false, "Incorrect response status: " + response.getStatus(), (String)loginfo, null);
            }
            catch (Exception ex) {
                return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", (String)loginfo, ex);
            }
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", (String)loginfo, null);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardNumber) throws BGException {
        Object loginfo = "Requests:\n";
        ChangeSubscriptionRequest request = new ChangeSubscriptionRequest();
        request.setFromCard(cardNumber);
        request.setToCard(cardNumber);
        request.setChannelMask(emptyMask);
        try {
            for (int serverCode : this.serversManager.getServerCodes()) {
                String line = "Closing card: " + cardNumber + " (server: #" + serverCode + ", mask: " + Utils.bytesToString((byte[])emptyMask) + ")";
                log.info(line);
                loginfo = (String)loginfo + line + "\n";
                CerbercryptServerConnection connection = this.getConnection(serverCode);
                connection.sendRequest(request);
            }
        }
        catch (Exception ex) {
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", (String)loginfo, ex);
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", (String)loginfo, null);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult getSubscribeInfoImpl(long cardNumber) throws BGException {
        StringBuilder infotext = new StringBuilder(64);
        GetSubscriptionRequest request = new GetSubscriptionRequest();
        request.setFromCard(cardNumber);
        request.setToCard(cardNumber);
        String logline1 = "get subscribe card: " + cardNumber;
        log.info(logline1);
        infotext.append(logline1).append("\n");
        try {
            for (int serverCode : this.serversManager.getServerCodes()) {
                CerbercryptServerConnection connection = this.getConnection(serverCode);
                GetSubscriptionResponse response = (GetSubscriptionResponse)connection.sendRequest(request);
                infotext.append("server #").append(serverCode).append(": ");
                if (response.getStatus() != 0) {
                    infotext.append("Incorrect response status: ").append(response.getStatus());
                } else {
                    for (GetSubscriptionResponse.CardStatus cardStatus : response.getCardStatusList()) {
                        infotext.append("card: ").append(cardStatus.cardNumber).append("; channels: ").append(ByteSerializer.maskToEnum(cardStatus.mask, 1)).append(" (mask: ").append(Utils.bytesToString((byte[])cardStatus.mask)).append("); ");
                    }
                }
                infotext.append("\n");
            }
        }
        catch (Exception ex) {
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", infotext.toString(), ex);
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(true, infotext.toString(), null, null);
    }

    @Override
    public void destroy() {
        for (CerbercryptServerConnection con : this.connections.values()) {
            try {
                con.logout();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        this.connections.clear();
    }

    @Override
    public void checkChannelMapping(ChannelMapping cm) throws BGException {
        int channelCode = Utils.parseInt((String)cm.getChannelCode());
        if (channelCode <= 0 || channelCode > 128) {
            throw new BGMessageException("\u0414\u043b\u044f \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430, \u043a\u043e\u0434 \u043a\u0430\u043d\u0430\u043b\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0435\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0435 \u043e\u0442 1 \u0434\u043e 128");
        }
    }
}

