/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.server.service;

import jakarta.jws.WebService;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantActionItem;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantButton;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantKeyValue;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantMaster;
import ru.bitel.bgbilling.plugins.assistant.common.dto.AssistantActionDTO;
import ru.bitel.bgbilling.plugins.assistant.common.dto.AssistantMasterDTO;
import ru.bitel.bgbilling.plugins.assistant.common.service.AssistantService;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantActionBase;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantActionDao;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantMasterDao;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantRequest;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantResponse;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantResponseStatus;
import ru.bitel.bgbilling.plugins.assistant.server.event.AssistantMastersListEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.assistant.common.service.AssistantService")
public class AssistantServiceImpl
extends AbstractService
implements AssistantService {
    public List<AssistantActionDTO> assistantActionList(int masterId) throws BGException, BGMessageException {
        try (AssistantActionDao assistantDao = new AssistantActionDao(this.getConnection());){
            List<AssistantActionDTO> list = assistantDao.assistantActions(masterId).stream().map(AssistantActionItem::toAssistantActionDTO).toList();
            return list;
        }
    }

    public List<AssistantActionItem> assistantActions(int masterId) throws BGException, BGMessageException {
        try (AssistantActionDao assistantDao = new AssistantActionDao(this.getConnection());){
            List<AssistantActionItem> list = assistantDao.assistantActions(masterId, this.userId);
            return list;
        }
    }

    public List<AssistantMaster> assistantMastersForUser(Set<String> modes, int contractId) throws BGException, BGMessageException {
        try (AssistantMasterDao assistantMasterDao = new AssistantMasterDao(this.getConnection());){
            List<AssistantMaster> assistantMastersIn = assistantMasterDao.assistantMasters(modes, this.getRoleIds());
            AssistantMastersListEvent event = new AssistantMastersListEvent(contractId, assistantMastersIn, this.userId);
            List<AssistantMaster> assistantMastersOut = ((AssistantMastersListEvent)EventProcessor.getInstance().request((QueueEvent)event)).getAssistantMasters();
            List<AssistantMaster> list = assistantMastersOut != null ? assistantMastersOut : assistantMastersIn;
            return list;
        }
    }

    public AssistantAction assistantActionGet(int id) throws BGException, BGMessageException {
        try (AssistantActionDao assistantDao = new AssistantActionDao(this.getConnection());){
            AssistantAction assistantAction = assistantDao.get(id);
            return assistantAction;
        }
    }

    public int assistantActionUpdate(AssistantAction assistantAction) throws BGException, BGMessageException {
        try (AssistantActionDao assistantDao = new AssistantActionDao(this.getConnection());){
            assistantDao.update(assistantAction);
            int n = assistantAction.getId();
            return n;
        }
    }

    public AssistantAction getAssistantActionByActionId(int masterId, String actionId) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (AssistantActionDao assistantDao = new AssistantActionDao(con);){
            AssistantAction assistantAction;
            try (AssistantMasterDao assistantMasterDao = new AssistantMasterDao(con);){
                AssistantMaster assistantMaster = (AssistantMaster)assistantMasterDao.get(masterId);
                assistantAction = assistantDao.getByActionId(actionId, assistantMaster != null ? assistantMaster.getActionIds() : new ArrayList());
            }
            return assistantAction;
        }
    }

    public String getInterfaceName() {
        return ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction.class.getName();
    }

    public String getSuperclassName() {
        return AssistantActionBase.class.getName();
    }

    public String doShow(int masterId, String actionId, String data) throws BGException, BGMessageException {
        Map<String, Object> fieldValues;
        AssistantResponse assistantResponse = new AssistantResponse();
        AssistantAction assistantAction = this.getAssistantActionByActionId(masterId, actionId);
        if (assistantAction != null) {
            String actionClassName = assistantAction.getActionClass();
            if (Utils.notBlankString((String)actionClassName)) {
                try {
                    AssistantRequest assistantRequest = new AssistantRequest(assistantAction, data);
                    assistantRequest.setMasterId(masterId);
                    ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction action = DynamicClassManager.getInstance().loadClass(actionClassName).asSubclass(ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (action instanceof AssistantActionBase) {
                        ((AssistantActionBase)action).setOutputStream(System.out);
                        ((AssistantActionBase)action).setErrorStream(System.err);
                    }
                    assistantResponse = action.showAction(assistantRequest);
                }
                catch (Exception e) {
                    this.getLogger().error((Object)e);
                    throw new BGException((Throwable)e);
                }
                if (assistantResponse == null) {
                    throw new BGMessageException("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0432\u0435\u0440\u043d\u0443\u043b assistantResponse = null");
                }
            }
            if (assistantResponse.getNextActionId() == null) {
                assistantResponse.setNextActionId(this.getDefaultNextActionId(assistantAction.getConfig()));
            }
        } else {
            assistantResponse.setStatus(AssistantResponseStatus.ERROR);
            assistantResponse.setError("Action with actionId='" + actionId + "' not found.");
        }
        JSONObject resultJsonObject = new JSONObject();
        resultJsonObject.put("status", (Object)assistantResponse.getStatus().getCode());
        if (AssistantResponseStatus.OK.equals((Object)assistantResponse.getStatus()) && (fieldValues = assistantResponse.getFieldValues()) != null && !assistantResponse.getFieldValues().isEmpty()) {
            JSONObject fieldsJsonObject = new JSONObject();
            for (String key : fieldValues.keySet()) {
                Object fieldValue = fieldValues.get(key);
                if (fieldValue instanceof AssistantKeyValue[]) {
                    AssistantKeyValue[] assistantKeyValues = (AssistantKeyValue[])fieldValue;
                    JSONArray array = new JSONArray();
                    for (int index = 0; index < assistantKeyValues.length; ++index) {
                        JSONObject item = new JSONObject();
                        item.put("key", (Object)assistantKeyValues[index].getKey());
                        item.put("value", (Object)assistantKeyValues[index].getValue());
                        array.put((Object)item);
                    }
                    fieldsJsonObject.put(key, (Object)array);
                    continue;
                }
                if (fieldValue instanceof String) {
                    fieldsJsonObject.put(key, (Object)((String)fieldValue));
                    continue;
                }
                if (fieldValue instanceof JSONObject) {
                    fieldsJsonObject.put(key, (Object)((JSONObject)fieldValue));
                    continue;
                }
                if (!(fieldValue instanceof JSONArray)) continue;
                fieldsJsonObject.put(key, (Object)((JSONArray)fieldValue));
            }
            resultJsonObject.put("fieldValues", (Object)fieldsJsonObject);
        }
        return resultJsonObject.toString();
    }

    public String doButton(int masterId, String actionId, String data, String button) throws BGException, BGMessageException {
        AssistantResponse assistantResponse = new AssistantResponse();
        AssistantAction assistantAction = this.getAssistantActionByActionId(masterId, actionId);
        if (assistantAction != null) {
            String actionClassName = assistantAction.getActionClass();
            if (actionClassName != null) {
                try {
                    AssistantRequest assistantRequest = new AssistantRequest(assistantAction, data, AssistantButton.getAssistantButtonByCode((String)button));
                    assistantRequest.setMasterId(masterId);
                    ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction action = DynamicClassManager.getInstance().loadClass(actionClassName).asSubclass(ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (action instanceof AssistantActionBase) {
                        ((AssistantActionBase)action).setOutputStream(System.out);
                        ((AssistantActionBase)action).setErrorStream(System.err);
                    }
                    assistantResponse = action.doAction(assistantRequest);
                }
                catch (BGMessageException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    this.getLogger().error((Object)ex);
                    throw new BGException((Throwable)ex);
                }
                if (assistantResponse == null) {
                    throw new BGMessageException("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0432\u0435\u0440\u043d\u0443\u043b assistantResponse = null");
                }
            }
            if (assistantResponse.getNextActionId() == null) {
                assistantResponse.setNextActionId(this.getDefaultNextActionId(assistantAction.getConfig()));
            }
        } else {
            assistantResponse.setStatus(AssistantResponseStatus.ERROR);
            assistantResponse.setError("Action with actionId='" + actionId + "' not found.");
        }
        JSONObject resultJsonObject = new JSONObject();
        Map<String, Object> fieldValues = assistantResponse.getFieldValues();
        if (fieldValues.size() > 0) {
            JSONObject fields = new JSONObject();
            fieldValues.forEach((arg_0, arg_1) -> ((JSONObject)fields).put(arg_0, arg_1));
            resultJsonObject.put("fields", (Object)fields);
        }
        resultJsonObject.put("status", (Object)assistantResponse.getStatus().getCode());
        resultJsonObject.put("masterId", masterId);
        if (AssistantResponseStatus.OK.equals((Object)assistantResponse.getStatus())) {
            if (assistantResponse.getNextActionId() != null) {
                resultJsonObject.put("nextActionId", (Object)assistantResponse.getNextActionId());
            }
        } else {
            resultJsonObject.put("error", (Object)assistantResponse.getError());
            resultJsonObject.put("errorTitle", (Object)assistantResponse.getErrorTitle());
        }
        return resultJsonObject.toString();
    }

    private String getDefaultNextActionId(String configData) {
        JSONObject config;
        JSONObject optionsJsonObject;
        String nextActionId = null;
        if (configData != null && (optionsJsonObject = (config = new JSONObject(configData)).optJSONObject("options")) != null && optionsJsonObject.has("nextActionId")) {
            nextActionId = optionsJsonObject.optString("nextActionId");
        }
        return nextActionId;
    }

    public void assistantActionDelete(int assistantActionId) throws BGException, BGMessageException {
        try (AssistantActionDao assistantDao = new AssistantActionDao(this.getConnection());){
            assistantDao.delete(assistantActionId);
        }
    }

    public void updateSortListAssistantAction(List<AssistantActionItem> assistantActions) throws BGException, BGMessageException {
        try (AssistantActionDao assistantDao = new AssistantActionDao(this.getConnection());){
            assistantDao.updateSortListAssistantAction(assistantActions);
        }
    }

    public List<AssistantMasterDTO> assistantMasters() throws BGException, BGMessageException {
        try (AssistantMasterDao assistantMasterDao = new AssistantMasterDao(this.getConnection());){
            List<AssistantMasterDTO> list = assistantMasterDao.list().stream().map(AssistantMaster::toAssistantMasterDTO).toList();
            return list;
        }
    }

    public AssistantMaster assistantMasterGet(int assistantMasterId, boolean loadIconData) throws BGException, BGMessageException {
        try (AssistantMasterDao assistantMasterDao = new AssistantMasterDao(this.getConnection());){
            AssistantMaster assistantMaster = assistantMasterDao.get(assistantMasterId, loadIconData);
            return assistantMaster;
        }
    }

    public AssistantMaster assistantMasterUpdate(AssistantMaster assistantMaster) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (AssistantMasterDao assistantMasterDao = new AssistantMasterDao(con);){
            AssistantMaster assistantMaster2;
            try (AssistantActionDao assistantActionDao = new AssistantActionDao(con);){
                assistantMaster.setActionIds(assistantActionDao.checkActionIds(assistantMaster.getId(), assistantMaster.getActionIds()));
                assistantMasterDao.update(assistantMaster);
                if (Optional.ofNullable(assistantMaster.getIconData()).isPresent()) {
                    assistantMasterDao.updateIconData(assistantMaster.getId(), Base64.getDecoder().decode(assistantMaster.getIconData()));
                }
                assistantMaster2 = assistantMaster;
            }
            return assistantMaster2;
        }
    }

    public int assistantMasterDelete(int assistantMasterId) throws BGException, BGMessageException {
        try (AssistantMasterDao assistantMasterDao = new AssistantMasterDao(this.getConnection());){
            int n = assistantMasterDao.delete(assistantMasterId);
            return n;
        }
    }

    private List<Integer> getRoleIds() {
        ArrayList<Integer> roleIds = new ArrayList<Integer>();
        Optional roleOpt = PermissionOfRoles.getRoleByUserId((int)this.userId);
        if (roleOpt.isPresent()) {
            Role role = (Role)roleOpt.get();
            roleIds.add(role.getId());
            if (Utils.notEmptyCollection((Collection)role.getChildren())) {
                roleIds.addAll(role.getChildren().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList()));
            }
        }
        return roleIds;
    }

    public void assistantMasterActionLinkUpdate(int masterId, int actionId) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (AssistantMasterDao assistantMasterDao = new AssistantMasterDao(con);){
            assistantMasterDao.updateMasterActionLink(masterId, actionId);
        }
    }

    public void assistantMasterActionLinkDelete(int masterId, int actionId) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (AssistantMasterDao assistantMasterDao = new AssistantMasterDao(con);){
            assistantMasterDao.deleteMasterActionLink(masterId, actionId);
        }
    }
}

