/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vidimax.server.bean;

import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxCharge;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class VidimaxChargeDao
extends AbstractIdDao<VidimaxCharge> {
    private static final Object createTableMutex = new Object();
    Date date;

    public VidimaxChargeDao(Connection con, int mid, Date date) {
        super(con, mid, "vidimax_charge", date);
        this.date = date;
    }

    public List<VidimaxCharge> getChargeList(int contractId, Period period, Page page, Holder<BigDecimal> holderTotalSum) throws BGException {
        List<Object> list;
        block19: {
            List<Object> result = new ArrayList<VidimaxCharge>();
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
                return result;
            }
            int index = 1;
            StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE contractId=" + contractId);
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND date>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND date<=?");
                }
            }
            query.append(" ORDER BY date");
            if (page != null) {
                query.append(page.sqlLimit());
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            try {
                if (period != null && period.getDateFrom() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                }
                if (period != null && period.getDateTo() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                }
                ResultSet rs = ps.executeQuery();
                if (holderTotalSum != null) {
                    Double sumL = 0.0;
                    while (rs.next()) {
                        sumL = sumL + rs.getDouble("sum");
                        result.add(this.getFromRS(rs));
                    }
                    holderTotalSum.value = new BigDecimal(sumL);
                } else {
                    result = this.getListFromRS(rs);
                }
                if (page != null) {
                    page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
                }
                list = result;
                if (ps == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BGException((Throwable)e);
                }
            }
            ps.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkTable() throws SQLException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            Object object = createTableMutex;
            synchronized (object) {
                if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
                    String query = "CREATE TABLE " + this.tableName + " ( id INT(11) NOT NULL AUTO_INCREMENT,contractId INT NOT NULL,date DATETIME NOT NULL,operationId VARCHAR(45) NOT NULL,customerId VARCHAR(45) NOT NULL,deviceId VARCHAR(45) NULL,tariffId INT NOT NULL,serviceTypeId INT NOT NULL,sum DECIMAL(10,2) NOT NULL,comment VARCHAR(120) NULL,pin VARCHAR(45) NULL,PRIMARY KEY (`id`),INDEX `cid` (`contractId`),INDEX `operationId` (`operationId`) )";
                    Statement st = this.con.createStatement();
                    st.execute(query);
                    st.close();
                    ServerUtils.checkAndCreatePeriodicTableName((Connection)this.con, (String)this.tableName, (String)query);
                }
            }
        }
    }

    protected VidimaxCharge getFromRS(ResultSet rs) throws SQLException, BGException {
        VidimaxCharge vidimaxCharge = new VidimaxCharge();
        vidimaxCharge.setId(rs.getInt("id"));
        vidimaxCharge.setContractId(rs.getInt("contractId"));
        vidimaxCharge.setDate((Date)rs.getTimestamp("date"));
        vidimaxCharge.setOperationId(rs.getString("operationId"));
        vidimaxCharge.setCustomerId(rs.getString("customerId"));
        vidimaxCharge.setDeviceId(rs.getString("deviceId"));
        vidimaxCharge.setTariffId(rs.getInt("tariffId"));
        vidimaxCharge.setServiceTypeId(rs.getInt("serviceTypeId"));
        vidimaxCharge.setSum(rs.getBigDecimal("sum"));
        vidimaxCharge.setComment(rs.getString("comment"));
        vidimaxCharge.setPin(rs.getString("pin"));
        return vidimaxCharge;
    }

    protected void updateImpl(VidimaxCharge charge) throws BGException, SQLException {
        if (charge != null) {
            String query = null;
            PreparedStatement ps = null;
            if (charge.getId() < 1) {
                this.checkTable();
                query = "INSERT INTO " + this.tableName + " SET contractId=?, date=?, operationId=?, customerId=?, deviceId=?, tariffId=?, serviceTypeId=?, sum=?, comment=?, pin=?";
                ps = this.con.prepareStatement(query, 1);
                int index = 1;
                ps.setInt(index++, charge.getContractId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)charge.getDate()));
                ps.setString(index++, charge.getOperationId());
                ps.setString(index++, charge.getCustomerId());
                ps.setString(index++, charge.getDeviceId());
                ps.setInt(index++, charge.getTariffId());
                ps.setInt(index++, charge.getServiceTypeId());
                ps.setBigDecimal(index++, charge.getSum());
                ps.setString(index++, charge.getComment());
                ps.setString(index++, charge.getPin());
                ps.executeUpdate();
                charge.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                ps.close();
            }
        }
    }

    public boolean uniqueOperationId(String operationId) {
        boolean result = true;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE operationId=?");){
            ps.setString(1, operationId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

