/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.trayinfo.server.service;

import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeTypeDao;
import ru.bitel.bgbilling.modules.trayinfo.common.TrayInfoLogin;
import ru.bitel.bgbilling.modules.trayinfo.common.TrayInfoType;
import ru.bitel.bgbilling.modules.trayinfo.common.service.TrayInfoService;
import ru.bitel.bgbilling.modules.trayinfo.server.bean.TrayInfoLoginManager;
import ru.bitel.bgbilling.modules.trayinfo.server.bean.TrayInfoTypeManager;
import ru.bitel.common.model.IdTitle;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.trayinfo.common.service.TrayInfoService")
public class TrayInfoServiceImpl
extends AbstractService
implements TrayInfoService {
    protected boolean isValidPassword(String pswd) {
        Pattern pattern = Pattern.compile("^[a-zA-Z_0-9]+$");
        return pattern.matcher(pswd).matches();
    }

    public void deleteLoginType(int id) throws BGException {
        new TrayInfoTypeManager(this.getConnection(), this.moduleId).deleteTrayInfoType(id);
    }

    public List<IdTitle> getChargesList() throws BGException {
        return new ArrayList<IdTitle>(new ChargeTypeDao(this.getConnection()).list(Integer.valueOf(1), Integer.valueOf(0), Boolean.valueOf(false)));
    }

    public TrayInfoType getLoginType(int id) throws BGException {
        return new TrayInfoTypeManager(this.getConnection(), this.moduleId).getTrayInfoTypeById(id);
    }

    public List<TrayInfoLogin> getLogins(int cid) throws BGException {
        TrayInfoLoginManager man = new TrayInfoLoginManager(this.getConnection(), this.moduleId);
        List<TrayInfoLogin> logins = man.getContractLoginsList(cid);
        return logins;
    }

    public void deleteLogin(int cid, int id) throws BGException {
        TrayInfoLoginManager man = new TrayInfoLoginManager(this.getConnection(), this.moduleId);
        man.deleteTrayInfoLogin(id);
    }

    public TrayInfoLogin getLogin(int cid, int id) throws BGException {
        TrayInfoLoginManager man = new TrayInfoLoginManager(this.getConnection(), this.moduleId);
        TrayInfoLogin login = man.getTrayInfoLogin(id);
        return login;
    }

    public List<TrayInfoType> getLoginTypes() throws BGException {
        return new TrayInfoTypeManager(this.getConnection(), this.moduleId).getTrayInfoTypesList(null);
    }

    public void updateLogin(TrayInfoLogin login) throws BGException {
        if (login.getPassword().length() < 6) {
            throw new BGMessageException("PIN2 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0435 \u043a\u043e\u0440\u043e\u0447\u0435 6 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432!", "trayInfo.activate.pin2.tooShort");
        }
        if (!this.isValidPassword(login.getPassword())) {
            throw new BGMessageException("PIN2 \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0438\u043c\u0432\u043e\u043b\u044b A-Za-z_0-9!", "trayInfo.activate.pin2.symbolError");
        }
        TrayInfoLoginManager man = new TrayInfoLoginManager(this.getConnection(), this.moduleId);
        if (login.getLogin() <= 0) {
            man.generateTrayInfoLogin(login.getType(), login.getContractId(), login.getPassword());
        } else {
            man.updateTrayInfoLogin(login.getLogin(), login.getPassword(), login.getDate1(), login.getDate2());
        }
    }

    public void updateLoginType(TrayInfoType type) throws BGException {
        if (type.getChargeType() <= 0 || type.getDays() < 0 || type.getTitle() == null || type.getTitle().length() <= 0 || type.getCost() == null || type.getCost().compareTo(BigDecimal.ZERO) < 0) {
            throw new BGIllegalArgumentException();
        }
        new TrayInfoTypeManager(this.getConnection(), this.moduleId).updateTrayInfoType(type);
    }
}

