/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostUser;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostUserDao
extends AbstractDao<ForpostUser> {
    private final String TABLE_FORPOST_ACCOUNT;
    private final String TABLE_FORPOST_ACCOUNT_CONTRACT;

    public ForpostUserDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_forpost_user");
        this.TABLE_FORPOST_ACCOUNT = "smarthouse_forpost_account_" + moduleId;
        this.TABLE_FORPOST_ACCOUNT_CONTRACT = "smarthouse_forpost_account_contract_" + moduleId;
    }

    public List<ForpostUser> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    protected ForpostUser getFromRS(ResultSet rs) throws SQLException, BGException {
        ForpostUser result = new ForpostUser();
        result.setId(rs.getInt("id"));
        result.setAccountId(rs.getInt("account_id"));
        result.setLogin(rs.getString("login"));
        result.setPassword(rs.getString("password"));
        result.setIsActive(rs.getInt("is_active"));
        result.setData(rs.getString("data"));
        return result;
    }

    protected void updateImpl(ForpostUser forpostUser) throws BGException {
        if (forpostUser != null) {
            try {
                int parameterIndex = 1;
                boolean insert = forpostUser.getId() < 1;
                String sql = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET id=?, account_id=?, login=?, password=?, is_active=?, data=?" + (insert ? "" : " WHERE id=?");
                PreparedStatement ps = this.con.prepareStatement(sql);
                ps.setInt(parameterIndex++, forpostUser.getId());
                ps.setInt(parameterIndex++, forpostUser.getAccountId());
                ps.setString(parameterIndex++, forpostUser.getLogin());
                ps.setString(parameterIndex++, forpostUser.getPassword());
                ps.setInt(parameterIndex++, forpostUser.getIsActive());
                ps.setString(parameterIndex++, forpostUser.getData());
                if (!insert) {
                    ps.setInt(parameterIndex++, forpostUser.getId());
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(ps.toString());
                }
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void deleteForpostUser(int id) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");){
            ps.setInt(1, id);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void searchForpostUsers(SearchResult<ForpostTMCAO<ForpostUser>> searchResult) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT SQL_CALC_FOUND_ROWS u.*, a.name AS accountName, c.id AS contractId, c.title AS contractTitle FROM " + this.tableName + " AS u LEFT JOIN " + this.TABLE_FORPOST_ACCOUNT + " AS a ON a.id=u.account_id LEFT JOIN " + this.TABLE_FORPOST_ACCOUNT_CONTRACT + " AS ac ON ac.account_id=u.account_id LEFT JOIN contract AS c ON c.id=ac.contract_id " + (page != null ? page.sqlLimit() : ""), 1);){
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ForpostTMCAO tableModelRow = new ForpostTMCAO();
                tableModelRow.setContractId(rs.getInt("contractId"));
                tableModelRow.setContractTitle(rs.getString("contractTitle"));
                tableModelRow.setAccountName(rs.getString("accountName"));
                tableModelRow.setObject((Object)this.getFromRS(rs));
                list.add(tableModelRow);
            }
            rs.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public void searchForpostAccountUsers(SearchResult<ForpostUser> searchResult, int accountId) throws BGException {
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + (accountId > 0 ? " WHERE account_id=? " : ""));){
            if (accountId > 0) {
                ps.setInt(1, accountId);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public void doSync(int accountId, ForpostUser[] users) throws BGException {
        if (users == null) {
            return;
        }
        long now = System.currentTimeMillis();
        String sqlField = "account_id=?, login=?, password=?, is_active=?, data=?, sync_datetime=?";
        try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, " + sqlField + " ON DUPLICATE KEY UPDATE " + sqlField);
             PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE sync_datetime<>? AND account_id=?");){
            for (ForpostUser forpostUser : users) {
                int parameterIndex = 1;
                psInsert.setInt(parameterIndex++, forpostUser.getId());
                psInsert.setInt(parameterIndex++, accountId);
                psInsert.setString(parameterIndex++, forpostUser.getLogin());
                psInsert.setString(parameterIndex++, forpostUser.getPassword());
                psInsert.setInt(parameterIndex++, forpostUser.getIsActive());
                psInsert.setString(parameterIndex++, forpostUser.getData());
                psInsert.setLong(parameterIndex++, now);
                psInsert.setInt(parameterIndex++, accountId);
                psInsert.setString(parameterIndex++, forpostUser.getLogin());
                psInsert.setString(parameterIndex++, forpostUser.getPassword());
                psInsert.setInt(parameterIndex++, forpostUser.getIsActive());
                psInsert.setString(parameterIndex++, forpostUser.getData());
                psInsert.setLong(parameterIndex++, now);
                psInsert.executeUpdate();
            }
            if (accountId > 0) {
                psDelete.setLong(1, now);
                psDelete.setInt(2, accountId);
                psDelete.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostUser getForpostUser(int forpostUserId) throws BGException {
        try {
            return (ForpostUser)this.getById(forpostUserId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

