/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelContractTariff;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelIdPeriod;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelTariff;
import ru.bitel.bgbilling.modules.runtel.common.bean.TariffAdditionalItem;
import ru.bitel.bgbilling.modules.runtel.common.bean.TariffIncludeItem;
import ru.bitel.bgbilling.modules.runtel.common.bean.TariffServiceItem;
import ru.bitel.bgbilling.modules.runtel.common.service.RunTelService;
import ru.bitel.bgbilling.modules.runtel.server.bean.RunTelContractTariffDao;
import ru.bitel.bgbilling.modules.runtel.server.bean.RunTelTariffDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.runtel.common.service.RunTelService")
public class RunTelServiceImpl
extends AbstractService
implements RunTelService {
    @PostConstruct
    private void init() {
    }

    public SearchResult<RunTelTariff> searchRunTelTariff() throws BGException {
        SearchResult searchResult = new SearchResult();
        try (RunTelTariffDao runTelTariffDao = new RunTelTariffDao(this.getConnection(), this.moduleId);){
            runTelTariffDao.searchRunTelTariffList((SearchResult<RunTelTariff>)searchResult);
        }
        return searchResult;
    }

    public SearchResult<RunTelContractTariff> searchContractRunTelTariff(int contractId, PeriodWithTime period) throws BGException {
        SearchResult searchResult = new SearchResult();
        try (RunTelContractTariffDao contractTariffDao = new RunTelContractTariffDao(this.getConnection(), this.moduleId);){
            searchResult.setList(contractTariffDao.getRunTelContractTariffs(contractId, period));
        }
        return searchResult;
    }

    public RunTelTariff getRunTelTariff(int id) throws BGException {
        try (RunTelTariffDao runTelTariffDao = new RunTelTariffDao(this.getConnection(), this.moduleId);){
            RunTelTariff runTelTariff = (RunTelTariff)runTelTariffDao.get(id);
            return runTelTariff;
        }
    }

    public void updateTariff(RunTelTariff runTelTariff) throws BGException {
        try (RunTelTariffDao runTelTariffDao = new RunTelTariffDao(this.getConnection(), this.moduleId);){
            runTelTariffDao.update(runTelTariff);
        }
    }

    public LocalDateTime getOnDateContractTariff(int contractId) throws BGException {
        try (RunTelContractTariffDao contractTariffDao = new RunTelContractTariffDao(this.getConnection(), this.moduleId);){
            LocalDateTime localDateTime = contractTariffDao.getOnDate(contractId);
            return localDateTime;
        }
    }

    public RunTelContractTariff getContractTariff(int contractTariffId) throws BGException {
        try (RunTelContractTariffDao contractTariffDao = new RunTelContractTariffDao(this.getConnection(), this.moduleId);){
            RunTelContractTariff runTelContractTariff = (RunTelContractTariff)contractTariffDao.get(contractTariffId);
            return runTelContractTariff;
        }
    }

    public int updateContractTariff(RunTelContractTariff runTelContractTariff) throws BGException {
        if (runTelContractTariff == null) {
            throw new BGMessageException("runTelContractTariff = null");
        }
        PeriodWithTime addPeriod = new PeriodWithTime(LocalDateTime.now().truncatedTo(ChronoUnit.MINUTES), null);
        runTelContractTariff.setPeriod(addPeriod);
        Connection connection = this.getConnection();
        int contractId = runTelContractTariff.getContractId();
        try (RunTelTariffDao runTelTariffDao = new RunTelTariffDao(connection, this.moduleId);){
            int n;
            try (RunTelContractTariffDao runTelContractTariffDao = new RunTelContractTariffDao(connection, this.moduleId);){
                List<RunTelContractTariff> contractTariffs = runTelContractTariffDao.getRunTelContractTariffs(contractId, addPeriod);
                if (!contractTariffs.isEmpty()) {
                    for (RunTelContractTariff tariff : contractTariffs) {
                        PeriodWithTime dbTariffPeriod = tariff.getPeriod();
                        if (dbTariffPeriod.getLocalDateTimeFrom() == null || dbTariffPeriod.getLocalDateTimeFrom().compareTo(addPeriod.getLocalDateTimeFrom()) == -1) {
                            if (addPeriod.getLocalDateTimeTo() != null && (dbTariffPeriod.getLocalDateTimeTo() == null || dbTariffPeriod.getLocalDateTimeTo().compareTo(addPeriod.getLocalDateTimeTo()) >= 1)) {
                                RunTelContractTariff runTelContractTariff2 = new RunTelContractTariff();
                                runTelContractTariff2.setContractId(tariff.getContractId());
                                runTelContractTariff2.setTariffId(tariff.getTariffId());
                                runTelContractTariff2.setPeriod(new PeriodWithTime(addPeriod.getLocalDateTimeTo(), dbTariffPeriod.getLocalDateTimeTo()));
                                runTelContractTariff2.setConfig(tariff.getConfig());
                                runTelContractTariffDao.update(runTelContractTariff2);
                            }
                            dbTariffPeriod.setLocalDateTimeTo(addPeriod.getLocalDateTimeFrom());
                            runTelContractTariffDao.update(tariff);
                            continue;
                        }
                        if (dbTariffPeriod.getLocalDateTimeFrom().compareTo(addPeriod.getLocalDateTimeFrom()) <= -1) continue;
                        if (addPeriod.getLocalDateTimeTo() == null || dbTariffPeriod.getLocalDateTimeTo() != null && dbTariffPeriod.getLocalDateTimeTo().compareTo(addPeriod.getLocalDateTimeTo()) < 1) {
                            runTelContractTariffDao.delete(tariff.getId());
                            continue;
                        }
                        dbTariffPeriod.setLocalDateTimeFrom(addPeriod.getLocalDateTimeTo());
                        runTelContractTariffDao.update(tariff);
                    }
                }
                runTelContractTariffDao.update(runTelContractTariff);
                n = runTelContractTariff.getId();
            }
            return n;
        }
    }

    public void updateContractTariffDateTo(int contractTariffId, LocalDateTime dateTo) throws BGException {
        LocalDateTime now = LocalDateTime.now();
        if (dateTo != null && dateTo.compareTo(now) < 0) {
            throw new BGMessageException("\u0414\u0430\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0440\u0430\u0432\u043d\u0430 \u0438\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0439...");
        }
        Connection connection = this.getConnection();
        try (RunTelTariffDao runTelTariffDao = new RunTelTariffDao(connection, this.moduleId);
             RunTelContractTariffDao runTelContractTariffDao = new RunTelContractTariffDao(connection, this.moduleId);){
            RunTelContractTariff runTelContractTariff = (RunTelContractTariff)runTelContractTariffDao.get(contractTariffId);
            if (runTelContractTariff != null) {
                boolean update = false;
                PeriodWithTime period = runTelContractTariff.getPeriod();
                LocalDateTime periodDateTo = period.getLocalDateTimeTo();
                if (periodDateTo == null) {
                    period.setLocalDateTimeTo(dateTo);
                    update = true;
                } else {
                    List<RunTelContractTariff> list = runTelContractTariffDao.getRunTelContractTariffs(dateTo);
                    if (list.isEmpty() || list.size() == 1 && list.get(0).getId() == contractTariffId) {
                        period.setLocalDateTimeTo(dateTo);
                        update = true;
                    } else {
                        RunTelContractTariff conflictContractTariff = list.get(0);
                        throw new BGMessageException("\u0414\u0430\u0442\u0430 \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0435\u0442\u0441\u044f \u0441 \u0434\u0440\u0443\u0433\u0438\u043c \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u043c \u043f\u043b\u0430\u043d\u043e\u043c (" + TimeUtils.formatPeriodWithTime((PeriodWithTime)conflictContractTariff.getPeriod()) + ")");
                    }
                }
                if (update) {
                    runTelContractTariffDao.updateDateTo(contractTariffId, dateTo);
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteContractTariff(int id) throws BGException {
        try (RunTelContractTariffDao runTelContractTariffDao = new RunTelContractTariffDao(this.getConnection(), this.moduleId);){
            runTelContractTariffDao.delete(id);
        }
    }

    public List<TariffServiceItem> getTariffServiceItems() throws BGException {
        ArrayList<TariffServiceItem> serviceItems = new ArrayList<TariffServiceItem>();
        serviceItems.add(new TariffServiceItem("monthlyFee", "\u0415\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u0430\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u043f\u043b\u0430\u0442\u0430"));
        serviceItems.add(new TariffServiceItem("runtelProfiles", "\u041f\u0440\u043e\u0444\u0438\u043b\u0435\u0439 \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u043e\u0432"));
        serviceItems.add(new TariffServiceItem("runtelNumberCity", "\u0413\u043e\u0440\u043e\u0434\u0441\u043a\u0438\u0445 \u043d\u043e\u043c\u0435\u0440\u043e\u0432"));
        serviceItems.add(new TariffServiceItem("runtelNumber8800", "\u041d\u043e\u043c\u0435\u0440\u043e\u0432 8 800"));
        return serviceItems;
    }

    public List<TariffIncludeItem> getTariffIncludeItems() throws BGException {
        ArrayList<TariffIncludeItem> includeItems = new ArrayList<TariffIncludeItem>();
        includeItems.add(new TariffIncludeItem("runtelProfiles", "\u041f\u0440\u043e\u0444\u0438\u043b\u0435\u0439 \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u043e\u0432", 0));
        includeItems.add(new TariffIncludeItem("runtelNumberCity", "\u0413\u043e\u0440\u043e\u0434\u0441\u043a\u0438\u0445 \u043d\u043e\u043c\u0435\u0440\u043e\u0432", 0));
        includeItems.add(new TariffIncludeItem("runtelNumber8800", "\u041d\u043e\u043c\u0435\u0440\u043e\u0432 8 800", 0));
        return includeItems;
    }

    public List<TariffAdditionalItem> getTariffAdditionalServiceItems() throws BGException {
        ArrayList<TariffAdditionalItem> additionalServiceItems = new ArrayList<TariffAdditionalItem>();
        additionalServiceItems.add(new TariffAdditionalItem("singlePaymentNumber", "\u0415\u0434\u0438\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0437\u0430 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u0438\u043b\u0438 \u043d\u043e\u043c\u0435\u0440 8 800"));
        additionalServiceItems.add(new TariffAdditionalItem("runtelProfiles", "\u0415\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u0430\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u043f\u043b\u0430\u0442\u0430 \u0437\u0430 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430"));
        additionalServiceItems.add(new TariffAdditionalItem("runtelNumberCity", "\u0415\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u0430\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u043f\u043b\u0430\u0442\u0430 \u0437\u0430 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440"));
        additionalServiceItems.add(new TariffAdditionalItem("runtelNumber8800", "\u0415\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u0430\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u043f\u043b\u0430\u0442\u0430 \u0437\u0430 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 8 800"));
        return additionalServiceItems;
    }

    public List<RunTelIdPeriod> getContractTariffIds(int contractId) throws BGException {
        try (RunTelContractTariffDao contractTariffDao = new RunTelContractTariffDao(this.getConnection(), this.moduleId);){
            ArrayList<RunTelIdPeriod> list = new ArrayList<RunTelIdPeriod>();
            contractTariffDao.getRunTelContractTariffs(contractId, null).stream().forEach(e -> list.add(new RunTelIdPeriod(e.getId(), e.getPeriod())));
            ArrayList<RunTelIdPeriod> arrayList = list;
            return arrayList;
        }
    }
}

