/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rcmts.server.task;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.rcmts.server.bean.RCCdrItem;
import ru.bitel.bgbilling.modules.rcmts.server.bean.RCCdrItemDao;
import ru.bitel.bgbilling.modules.rcmts.server.bean.RCConfigConstants;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class CDRUploadTask
extends TaskBase {
    private static final Logger logger = LogManager.getLogger(CDRUploadTask.class);
    private String accountPrefix;

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try (Connection connection = this.setup.getDBConnectionFromPool();){
            this.accountPrefix = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).get(RCConfigConstants.MTS_ACCOUNT_PREFIX.getKey(), "");
            if (Utils.isBlankString((String)this.accountPrefix)) {
                throw new BGException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f!");
            }
            List<RCCdrItem> cdrItems = this.prepareNewCdrItems(connection);
            if (Utils.isEmptyCollection(cdrItems)) {
                return;
            }
            try (RCCdrItemDao cdrItemDao = new RCCdrItemDao(connection, this.moduleId);){
                cdrItemDao.removeOldCdrItems(cdrItems);
                cdrItemDao.insert(cdrItems);
            }
            this.updatePaymentsOnContracts(this.getContractListWithPaymentSumm(cdrItems));
        }
        catch (SQLException | BGException e) {
            throw new RuntimeException(e);
        }
    }

    private void updatePaymentsOnContracts(Map<Integer, BigDecimal> contractWithPaymentSumma) throws BGException {
        int defaultPaymentTyoe = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).getInt(RCConfigConstants.DEFAULT_PAYMENT_TYPE.getKey(), 0);
        if (defaultPaymentTyoe == 0) {
            throw new BGException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d ID \u0444\u0438\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f!");
        }
        ServerContext serverContext = (ServerContext)ServerContext.get();
        PaymentService paymentService = (PaymentService)serverContext.getService(PaymentService.class, 0);
        for (Integer contractId : contractWithPaymentSumma.keySet()) {
            List payments = paymentService.paymentList(contractId.intValue(), this.makePeriodThisMonth(), 1).getList();
            payments.removeIf(p -> p.getTypeId() != defaultPaymentTyoe);
            Payment payment = null;
            payment = Utils.notEmptyCollection((Collection)payments) ? (Payment)payments.get(0) : Payment.builder().setContractId(contractId.intValue()).setTypeId(defaultPaymentTyoe).setUserId(0).setDate(new Date()).build();
            payment.setSum(contractWithPaymentSumma.get(contractId));
            payment.setComment("\u041a\u043e\u043c\u043f\u0435\u043d\u0441\u0430\u0446\u0438\u044f \u043a\u043e\u043d\u0432\u0435\u0440\u0433\u0435\u043d\u0442");
            try {
                serverContext.getConnection().setAutoCommit(false);
                paymentService.paymentUpdate(payment, null);
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    private Period makePeriodThisMonth() {
        Calendar date = Calendar.getInstance();
        date.set(5, 1);
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        Date dateFrom = date.getTime();
        date.set(5, date.getActualMaximum(5));
        date.set(11, date.getActualMaximum(11));
        date.set(12, 59);
        date.set(13, 59);
        Date dateTo = date.getTime();
        return new Period(dateFrom, dateTo);
    }

    private Map<Integer, BigDecimal> getContractListWithPaymentSumm(List<RCCdrItem> cdrItems) {
        HashMap<Integer, BigDecimal> contractWithPaymentSumma = new HashMap<Integer, BigDecimal>();
        for (RCCdrItem cdrItem : cdrItems) {
            int contractId = cdrItem.getAccountId();
            BigDecimal summa = (BigDecimal)contractWithPaymentSumma.get(contractId);
            if (summa == null) {
                summa = BigDecimal.ZERO;
            }
            summa = summa.add(cdrItem.getAmount());
            contractWithPaymentSumma.put(contractId, summa);
        }
        return contractWithPaymentSumma;
    }

    private List<RCCdrItem> prepareNewCdrItems(Connection connection) throws BGException {
        List<RCMtsContract> contracts = this.selectActiveConvergentContracts(connection);
        if (Utils.isEmptyCollection(contracts)) {
            logger.info("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0441 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c\u0438 \u043e\u043f\u0446\u0438\u044f\u043c\u0438 \u043c\u0442\u0441 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 cdr \u0437\u0430\u043f\u0438\u0441\u0435\u0439");
            return Collections.emptyList();
        }
        ArrayList<RCCdrItem> result = new ArrayList<RCCdrItem>();
        String cids = Utils.toString(contracts.stream().mapToInt(RCMtsContract::getContractId).boxed().toList());
        result.addAll(this.getContractAccountCdrItems(connection, cids));
        result.addAll(this.getContractChargedCdrItems(connection, cids));
        logger.info("\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443 cdr = " + result.size());
        return result;
    }

    private List<RCMtsContract> selectActiveConvergentContracts(Connection connection) throws BGException {
        int mtsModuleId = this.getModuleId();
        ArrayList<RCMtsContract> contracts = new ArrayList<RCMtsContract>();
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(mtsModuleId));
        String tariffOptions = moduleSetup.get(RCConfigConstants.MTS_TARIFF_OPTIONS.getKey());
        if (Utils.isBlankString((String)tariffOptions)) {
            throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a id \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0445 \u043e\u043f\u0446\u0438\u0439 \u0438\u0437 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f");
        }
        String query = "SELECT c.id, cto.time_from AS dateFrom, cto.time_to AS dateTo FROM contract AS c LEFT JOIN contract_module AS cm ON c.id=cm.cid LEFT JOIN contract_tariff_option AS cto ON c.id=cto.cid WHERE cm.mid=? AND cto.option_id IN(" + tariffOptions + ") AND cto.time_from<? AND (cto.time_to IS NULL OR cto.time_to>?) GROUP BY c.id";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            Calendar now = Calendar.getInstance();
            now.set(5, 1);
            ps.setInt(1, mtsModuleId);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            logger.info("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u041c\u0422\u0421 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + ps.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int cid = rs.getInt("c.id");
                RCMtsContract mtsContract = new RCMtsContract();
                mtsContract.contractId = cid;
                contracts.add(mtsContract);
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return contracts;
    }

    private List<RCCdrItem> getContractAccountCdrItems(Connection connection, String cids) throws BGException {
        ArrayList<RCCdrItem> result = new ArrayList<RCCdrItem>();
        ParameterMap services = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).sub("service.");
        List servicesIds = services.entrySet().stream().map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        Calendar now = Calendar.getInstance();
        String query = "SELECT ca.*, serv.title, c.title AS contractTitle FROM contract_account AS ca LEFT JOIN service AS serv ON ca.sid=serv.id LEFT JOIN contract AS c ON ca.cid=c.id WHERE ca.yy=? AND ca.mm=? AND ca.sid IN (" + Utils.toString(servicesIds) + ") AND ca.cid IN (" + cids + ") ";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            ps.setInt(1, now.get(1));
            ps.setInt(2, now.get(2) + 1);
            logger.info("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430 \u043c\u0435\u0441\u044f\u0446 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c \u043c\u0442\u0441: " + ps.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int serviceId = rs.getInt("ca.sid");
                int contractId = rs.getInt("ca.cid");
                String contractTitle = this.accountPrefix + rs.getString("contractTitle");
                BigDecimal summa = rs.getBigDecimal("ca.summa");
                String serviceTitle = rs.getString("serv.title");
                String gaapCode = services.get(String.valueOf(serviceId), "");
                result.add(new RCCdrItem(now, summa, contractId, contractTitle, serviceId, serviceTitle, true, gaapCode));
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        logger.info("\u0417\u0430\u043f\u0438\u0441\u0435\u0439 \u043f\u043e \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430\u043c = " + result.size());
        return result;
    }

    private List<RCCdrItem> getContractChargedCdrItems(Connection connection, String cids) throws BGException {
        ParameterMap chargeTypes = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).sub("charge.type.");
        List chargeTypeIds = chargeTypes.entrySet().stream().map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        ArrayList<RCCdrItem> result = new ArrayList<RCCdrItem>();
        String query = "SELECT ch.*, chp.title AS typeTitle, chp.id as chargeType, c.title AS contractTitle FROM contract_charge AS ch LEFT JOIN contract_charge_types AS chp ON ch.pt=chp.id LEFT JOIN contract AS c ON ch.cid=c.id WHERE ch.dt>? AND ch.dt<? AND ch.pt IN (" + Utils.toString(chargeTypeIds) + ") AND ch.cid IN (" + cids + ")";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            Calendar now = Calendar.getInstance();
            now.set(5, 1);
            Date startPeriod = now.getTime();
            now.set(5, now.getActualMaximum(5));
            Date endPeriod = now.getTime();
            now = Calendar.getInstance();
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)startPeriod));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)endPeriod));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int chargeTypeId = rs.getInt("chargeType");
                int contractId = rs.getInt("ch.cid");
                String contractTitle = this.accountPrefix + rs.getString("contractTitle");
                BigDecimal summa = rs.getBigDecimal("ch.summa");
                String chargeTitle = rs.getString("typeTitle");
                String gaapCode = chargeTypes.get(String.valueOf(chargeTypeId), "");
                result.add(new RCCdrItem(now, summa, contractId, contractTitle, chargeTypeId, chargeTitle, false, gaapCode));
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        logger.info("\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043f\u043e \u0440\u0430\u0441\u0445\u043e\u0434\u0430\u043c = " + result.size());
        return result;
    }

    public String getDescription() {
        return "\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u0440\u0430\u0441\u0445\u043e\u0434\u0430\u043c \u0434\u043b\u044f \u041c\u0422\u0421";
    }

    private static final class RCMtsContract {
        int contractId;

        private RCMtsContract() {
        }

        public int getContractId() {
            return this.contractId;
        }
    }
}

