/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.task;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonPayment;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;

public class MegafonDailyReport
extends BGLogger {
    private final LocalDate reportDay;
    private final int megafonModuleId;

    public MegafonDailyReport(int megafonModuleId, LocalDate day) {
        this.megafonModuleId = megafonModuleId;
        this.reportDay = day;
    }

    protected Path generate() throws Exception {
        Path reportFile = Path.of("/tmp/megafon_payments_report_" + this.reportDay.format(DateTimeFormatter.ofPattern("dd_MM_yyyy")) + ".xml", new String[0]);
        this.writeReportXML(reportFile, this.definePayments());
        return reportFile;
    }

    private List<MegafonPayment> definePayments() throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        return ((MegafonService)serverContext.getService(MegafonService.class, this.megafonModuleId)).getMegafonPayments(null, this.reportDay, this.reportDay).getList();
    }

    private void writeReportXML(Path reportFile, List<MegafonPayment> payments) throws IOException {
        BigDecimal totalSum = BigDecimal.ZERO;
        int entryCount = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("<reestr>\n");
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        for (MegafonPayment payment : payments) {
            sb.append("  <r>\n");
            sb.append("    <m>").append(payment.getMsisdn()).append("</m>\n");
            sb.append("    <s>").append(payment.getAmount()).append("</s>\n");
            sb.append("    <n>").append(payment.getCheckNumber()).append("</n>\n");
            sb.append("    <d>").append(dtf.format(payment.getPaymentDate())).append("</d>\n");
            sb.append("  </r>\n");
            totalSum = totalSum.add(payment.getAmount());
            ++entryCount;
        }
        sb.append("  <pay_sum>").append(totalSum).append("</pay_sum>\n");
        sb.append("  <pay_count>").append(entryCount).append("</pay_count>\n");
        sb.append("</reestr>\n");
        Files.writeString(reportFile, (CharSequence)sb.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

