/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.contract;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.license.client.contract.DefaultOrder;
import ru.bitel.bgbilling.modules.license.client.contract.DefaultOrderEditor;
import ru.bitel.common.client.BGSwingUtilites;

public class DefaultOrdersPanel
extends BGPanel {
    private List<DefaultOrder> orderList;
    private BGTable table = new BGTable();
    private BGComboBox<ComboBoxItem> product = new BGComboBox();
    private DefaultOrderEditor editor = new DefaultOrderEditor(this);

    public DefaultOrdersPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.orderList = new ArrayList<DefaultOrder>();
        this.table.setHeader(this.rb_name, this.moduleDoc, "pattern_orders");
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        BGButton buttonAdd = new BGButton();
        BGButton buttonDel = new BGButton();
        BGButton buttonEdit = new BGButton();
        buttonAdd.setIcon((Icon)ClientUtils.getIcon((String)"item_add"));
        buttonAdd.setMargin(new Insets(0, 0, 0, 0));
        buttonAdd.setText("");
        buttonDel.setIcon((Icon)ClientUtils.getIcon((String)"item_delete"));
        buttonDel.setMargin(new Insets(0, 0, 0, 0));
        buttonDel.setText("");
        buttonEdit.setIcon((Icon)ClientUtils.getIcon((String)"item_edit"));
        buttonEdit.setMargin(new Insets(0, 0, 0, 0));
        buttonEdit.setText("");
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.add((Component)buttonAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        tablePanel.add((Component)buttonEdit, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        tablePanel.add((Component)buttonDel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        tablePanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(BGSwingUtilites.wrapBorder(this.product, (String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b"), "North");
        this.add(BGSwingUtilites.wrapBorder((JPanel)tablePanel, (String)"\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432"), "Center");
        this.add(BGSwingUtilites.wrapBorder((JPanel)((Object)this.editor), (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"), "South");
        this.editor.setVisible(false);
        this.product.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultOrdersPanel.this.editor.updateComponents(Integer.valueOf(DefaultOrdersPanel.this.product.getSelectedId()));
                DefaultOrdersPanel.this.updateTableData();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DefaultOrdersPanel.this.editOrder();
                }
            }
        });
        buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultOrdersPanel.this.editor.updateComponents(Integer.valueOf(DefaultOrdersPanel.this.product.getSelectedId()));
                DefaultOrdersPanel.this.editor.showEditor();
            }
        });
        buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultOrdersPanel.this.editor.updateComponents(Integer.valueOf(DefaultOrdersPanel.this.product.getSelectedId()));
                DefaultOrdersPanel.this.editOrder();
            }
        });
        buttonDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = DefaultOrdersPanel.this.table.getSelectedRow();
                if (row >= 0) {
                    int id = Integer.valueOf(DefaultOrdersPanel.this.table.getRowId(row, "ID"));
                    DefaultOrdersPanel.this.deleteProductComponent(id);
                    DefaultOrdersPanel.this.updateTableData();
                }
            }
        });
    }

    private void editOrder() {
        int row = this.table.getSelectedRow();
        if (row >= 0) {
            int id = Integer.valueOf(this.table.getRowId(row, "ID"));
            this.editor.updateComponents(Integer.valueOf(this.product.getSelectedId()));
            this.editor.showEditor(this.getProductComponent(id));
        }
    }

    public void setModuleId(int moduleId) {
        super.setModuleId(moduleId);
        this.editor.setModuleId(moduleId);
    }

    public BGComboBox<ComboBoxItem> getProducts() {
        return this.product;
    }

    public void stopEdit(boolean save) {
        if (save) {
            String productId = this.product.getSelectedId();
            int count = this.editor.getCount();
            int term = this.editor.getTerm();
            String componentId = this.editor.getComponentsCombo().getSelectedId();
            if (count == -1 || term == -1 || componentId == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u0445.");
                return;
            }
            String title = ((ComboBoxItem)this.editor.getComponentsCombo().getSelectedItem()).toString();
            int id = this.editor.getEditorId();
            if (id > 0) {
                DefaultOrder comp = this.getProductComponent(id);
                comp.setProductId(productId);
                comp.setComponentId(componentId);
                comp.setTitle(title);
                comp.setCount(count);
                comp.setTerm(term);
            } else {
                this.saveComponent(new DefaultOrder(productId, componentId, title, count, term));
            }
            this.updateTableData();
        }
        this.editor.setVisible(false);
    }

    private void saveComponent(DefaultOrder component) {
        this.orderList.add(component);
        this.updateTableData();
    }

    private void updateTableData() {
        this.table.removeRows();
        for (DefaultOrder comp : this.orderList) {
            if (!comp.getProductId().equals(this.product.getSelectedId())) continue;
            Vector<String> rowData = new Vector<String>();
            rowData.add(String.valueOf(comp.getId()));
            rowData.add(comp.getTypeStr());
            rowData.add(comp.getTitle());
            rowData.add(comp.getCountStr());
            this.table.addRow(rowData);
        }
    }

    private DefaultOrder getProductComponent(int id) {
        DefaultOrder component = null;
        for (DefaultOrder comp : this.orderList) {
            if (comp.getId() != id) continue;
            component = comp;
            break;
        }
        return component;
    }

    private void deleteProductComponent(int id) {
        int dialogResult = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043a\u0430\u0437?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0);
        if (dialogResult == 0) {
            for (DefaultOrder comp : this.orderList) {
                if (comp.getId() != id) continue;
                this.orderList.remove(comp);
                break;
            }
        }
    }

    public List<DefaultOrder> getProductOrders(String productId) {
        ArrayList<DefaultOrder> productOrders = new ArrayList<DefaultOrder>();
        for (DefaultOrder comp : this.orderList) {
            if (!comp.getProductId().equals(productId)) continue;
            productOrders.add(comp);
        }
        return productOrders;
    }

    public void setProductOrders(List<DefaultOrder> productOrders) {
        this.orderList = productOrders;
        this.updateTableData();
    }
}

