/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.bean;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.task.server.bean.SchedulerManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public abstract class RunTask
implements Runnable,
Serializable {
    private int queueId = 0;
    protected transient Setup setup;
    private transient Logger log;

    public void setQueueId(int id) {
        this.queueId = id;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public abstract String getDescription();

    public void init(Setup setup) {
        this.setup = setup;
        this.log = LogManager.getLogger(this.getClass());
    }

    protected Logger getLogger() {
        return this.log;
    }

    @Override
    public final void run() {
        Date startTime = new Date();
        this.executeTask();
        Date finishTime = new Date();
        this.removeMyselfFromTable();
        this.log.info("RunTask finished time = " + (finishTime.getTime() - startTime.getTime()) + " ms.");
    }

    protected void removeMyselfFromTable() {
        if (this.queueId <= 0) {
            return;
        }
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            new SchedulerManager(con).deleteCurrentRunTask(this.queueId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    protected abstract void executeTask();

    public String getUniqueKeyQueue() {
        return null;
    }

    public String getUniqueKeyParallel() {
        return null;
    }
}

