/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.runtime;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.DefaultContext;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.server.ContractStatusList2;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.CheckReentrantLock;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifiedEvent;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductPeriodDao;

public class ContractRuntime
extends CheckReentrantLock {
    private static final Logger logger = LogManager.getLogger();
    public final int contractId;
    volatile String contractTitle;
    private volatile int superContractId = 0;
    volatile int independentSuperContractId = 0;
    private volatile ContractRuntime superContract;
    private volatile int[] dependSubContractIds;
    volatile int contractMode;
    volatile int contractStatus;
    volatile long contractGroups;
    volatile int domainId;
    private volatile long periodDataStart = Long.MAX_VALUE;
    volatile ContractStatusList2 contractStatuses;
    volatile ContractTariffOptionList tariffOptions;
    volatile ProductPeriodRuntimeList contractProductPeriodItemList;
    volatile ProductPeriodRuntimeList productPeriodItemList;
    volatile Set<Integer> moduleIds;
    boolean isSuper = false;
    private static ConcurrentMap<Set<Integer>, Set<Integer>> MODULEIDS_CACHE = new ConcurrentHashMap<Set<Integer>, Set<Integer>>(64);
    public static final ContractRuntime STUB = new ContractRuntime(0);

    public boolean isSuper() {
        return this.isSuper;
    }

    public void setSuper(boolean isSuper) {
        this.isSuper = isSuper;
    }

    protected ContractRuntime(int contractId) {
        this.contractId = contractId;
    }

    final void internalLock() {
        super.lock();
    }

    final void internalUnlock() {
        super.unlock();
    }

    @Override
    public void lock() {
        super.lock();
        ContractRuntime superContract = this.superContract;
        if (superContract != null && superContract.superContract == null) {
            try {
                superContract.lock();
            }
            catch (RuntimeException ex) {
                super.unlock();
                throw ex;
            }
        }
    }

    @Override
    public final boolean tryLock() {
        if (!super.tryLock()) {
            return false;
        }
        ContractRuntime superContract = this.superContract;
        if (superContract != null && !superContract.tryLock()) {
            super.unlock();
            return false;
        }
        return true;
    }

    @Override
    public final boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        if (!super.tryLock(timeout, unit)) {
            return false;
        }
        ContractRuntime superContract = this.superContract;
        if (superContract != null) {
            try {
                if (!superContract.tryLock(timeout, unit)) {
                    super.unlock();
                    return false;
                }
            }
            catch (InterruptedException e) {
                super.unlock();
                throw e;
            }
        }
        return true;
    }

    @Override
    public final void tryLockEx(long timeout, TimeUnit unit) throws InterruptedException {
        super.tryLockEx(timeout, unit);
        ContractRuntime superContract = this.superContract;
        if (superContract != null) {
            try {
                superContract.tryLockEx(timeout, unit);
            }
            catch (InterruptedException e) {
                super.unlock();
                throw e;
            }
            catch (RuntimeException e) {
                super.unlock();
                throw e;
            }
        }
    }

    @Override
    public void unlock() {
        ContractRuntime superContract = this.superContract;
        if (superContract != null) {
            superContract.unlock();
        }
        super.unlock();
    }

    public void setSuperContract(ContractRuntime superContractRuntime) {
        super.lock();
        try {
            this.superContractId = superContractRuntime.contractId;
            this.superContract = superContractRuntime;
        }
        finally {
            super.unlock();
        }
    }

    void setDependSubContractIds(String dependSubContractIdsString) {
        if (Utils.notEmptyString(dependSubContractIdsString)) {
            List<Integer> dependSubContractIds = Utils.toIntegerList(dependSubContractIdsString);
            if (dependSubContractIds.size() > 0) {
                int size = dependSubContractIds.size();
                this.dependSubContractIds = new int[size];
                for (int i = 0; i < size; ++i) {
                    this.dependSubContractIds[i] = dependSubContractIds.get(i);
                }
            } else {
                this.dependSubContractIds = null;
            }
        } else {
            this.dependSubContractIds = null;
        }
    }

    public int getSuperContractId() {
        return this.superContractId;
    }

    public long getContractGroups() {
        return this.contractGroups;
    }

    public int getDomainId() {
        return this.domainId;
    }

    public int[] getDependSubContractIds() {
        return this.dependSubContractIds;
    }

    public ContractTariffOptionList getTariffOptions(Date date) throws BGException {
        return this.getTariffOptions(date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractTariffOptionList getTariffOptions(long millis) throws BGException {
        if (millis >= this.periodDataStart) {
            return this.tariffOptions;
        }
        super.lock();
        try {
            this.load(millis);
            ContractTariffOptionList contractTariffOptionList = this.tariffOptions;
            return contractTariffOptionList;
        }
        finally {
            super.unlock();
        }
    }

    public ContractStatusList2 getContractStatuses(Date date) throws BGException {
        return this.getContractStatuses(date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContractStatusList2 getContractStatuses(long millis) throws BGException {
        if (millis >= this.periodDataStart) {
            return this.contractStatuses;
        }
        super.lock();
        try {
            this.load(millis);
            ContractStatusList2 contractStatusList2 = this.contractStatuses;
            return contractStatusList2;
        }
        finally {
            super.unlock();
        }
    }

    public ProductPeriodRuntimeList getContractProductPeriods(Date date) throws BGException {
        return this.getProductPeriods(date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductPeriodRuntimeList getContractProductPeriods(long millis) throws BGException {
        if (millis >= this.periodDataStart) {
            return this.contractProductPeriodItemList;
        }
        super.lock();
        try {
            this.load(millis);
            ProductPeriodRuntimeList productPeriodRuntimeList = this.contractProductPeriodItemList;
            return productPeriodRuntimeList;
        }
        finally {
            super.unlock();
        }
    }

    public ProductPeriodRuntimeList getProductPeriods(Date date) throws BGException {
        return this.getProductPeriods(date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductPeriodRuntimeList getProductPeriods(long millis) throws BGException {
        if (millis >= this.periodDataStart) {
            return this.productPeriodItemList;
        }
        super.lock();
        try {
            this.load(millis);
            ProductPeriodRuntimeList productPeriodRuntimeList = this.productPeriodItemList;
            return productPeriodRuntimeList;
        }
        finally {
            super.unlock();
        }
    }

    void updateProductPeriods(ProductPeriodModifiedEvent e) {
        assert (this.isHeldByCurrentThread());
        if (this.productPeriodItemList != null) {
            if (e.getNewProductPeriodTimeTo() != null) {
                this.productPeriodItemList = this.productPeriodItemList.update(e.getProductSpecId(), e.getProductId(), e.getProductPeriodId(), e.getNewProductPeriodTimeFrom(), e.getNewProductPeriodTimeTo(), e.getProlongationTime());
                if (e.getAccountId() == 0) {
                    this.contractProductPeriodItemList = this.contractProductPeriodItemList.update(e.getProductSpecId(), e.getProductId(), e.getProductPeriodId(), e.getNewProductPeriodTimeFrom(), e.getNewProductPeriodTimeTo(), e.getProlongationTime());
                }
            } else {
                this.productPeriodItemList = this.productPeriodItemList.remove(e.getProductSpecId(), e.getProductId(), e.getProductPeriodId(), e.getOldProductPeriodTimeFrom(), e.getOldProductPeriodTimeTo(), e.getProlongationTime());
                if (e.getAccountId() == 0) {
                    this.contractProductPeriodItemList = this.contractProductPeriodItemList.remove(e.getProductSpecId(), e.getProductId(), e.getProductPeriodId(), e.getOldProductPeriodTimeFrom(), e.getOldProductPeriodTimeTo(), e.getProlongationTime());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProductPeriods(int accountId, int productSpecId, int productId, int productPeriodId, Date timeFrom, Date timeTo, Date prolongationTime) {
        assert (this.isHeldByCurrentThread());
        super.lock();
        try {
            this.productPeriodItemList = this.productPeriodItemList.update(productSpecId, productId, productPeriodId, timeFrom, timeTo, prolongationTime);
            if (accountId == 0) {
                this.contractProductPeriodItemList = this.contractProductPeriodItemList.update(productSpecId, productId, productPeriodId, timeFrom, timeTo, prolongationTime);
            }
        }
        finally {
            super.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getModuleIds() throws BGException {
        Set<Integer> moduleIds = this.moduleIds;
        if (moduleIds != null) {
            return moduleIds;
        }
        super.lock();
        try {
            DefaultContext context = (DefaultContext)ThreadContext.get();
            Connection con = context != null ? context.getConnection() : Setup.getSetup().getDBConnectionFromPool();
            try {
                moduleIds = new ContractModuleManager(con).getContractModuleSet(this.contractId);
                Set<Integer> cacheModuleIds = (Set<Integer>)MODULEIDS_CACHE.get(moduleIds);
                if (cacheModuleIds == null) {
                    if (MODULEIDS_CACHE.size() < 128 && (cacheModuleIds = MODULEIDS_CACHE.putIfAbsent(moduleIds, moduleIds)) != null) {
                        moduleIds = cacheModuleIds;
                    }
                    this.moduleIds = moduleIds;
                } else {
                    this.moduleIds = cacheModuleIds;
                }
            }
            finally {
                if (context == null) {
                    ServerUtils.closeConnection((Connection)con);
                }
            }
            Set<Integer> set = moduleIds;
            return set;
        }
        finally {
            super.unlock();
        }
    }

    void setModuleIds(Set<Integer> moduleIds) {
        super.lock();
        try {
            Set<Integer> cacheModuleIds = (Set<Integer>)MODULEIDS_CACHE.get(moduleIds);
            if (cacheModuleIds == null) {
                if (MODULEIDS_CACHE.size() < 128 && (cacheModuleIds = MODULEIDS_CACHE.putIfAbsent(moduleIds, moduleIds)) != null) {
                    moduleIds = cacheModuleIds;
                }
                this.moduleIds = moduleIds;
            } else {
                this.moduleIds = cacheModuleIds;
            }
        }
        finally {
            super.unlock();
        }
    }

    boolean isModuleIdsFetched() {
        return this.moduleIds != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(long millis) throws BGException {
        DefaultContext context = (DefaultContext)ThreadContext.get();
        Connection con = context != null ? context.getConnection() : Setup.getSetup().getDBConnectionFromPool();
        try (ContractStatusDao contractStatusDao = new ContractStatusDao(con);
             ContractTariffOptionDao contractTariffOptionDao = new ContractTariffOptionDao(con);
             ProductPeriodDao productPeriodDao = new ProductPeriodDao(con, 0);){
            GregorianCalendar utilCalendar = new GregorianCalendar();
            utilCalendar.setTimeInMillis(millis);
            TimeUtils.clear_HOUR_MIN_MIL_SEC(utilCalendar);
            utilCalendar.set(5, 1);
            Date initialDate = utilCalendar.getTime();
            List<ContractStatus> statusList = contractStatusDao.getStatusList(this.contractId, initialDate);
            this.load(statusList, contractTariffOptionDao, productPeriodDao, initialDate, utilCalendar);
        }
        finally {
            if (context == null) {
                ServerUtils.closeConnection((Connection)con);
            }
        }
    }

    void load(List<ContractStatus> statusList, ContractTariffOptionDao contractTariffOptionDao, ProductPeriodDao productPeriodDao, Date initialDate, Calendar utilCalendar) throws BGException {
        try {
            this.contractStatuses = new ContractStatusList2(statusList, utilCalendar);
            this.tariffOptions = contractTariffOptionDao.getContractRealtimeTariffOptionList(this.contractId, initialDate);
            List fullProductPeriodList = productPeriodDao.list(-1, this.contractId, -1, true, null, initialDate, true);
            this.contractProductPeriodItemList = ProductPeriodRuntimeList.newInstance(fullProductPeriodList.stream().filter(a -> a.getAccountId() == 0).collect(Collectors.toList()));
            this.productPeriodItemList = ProductPeriodRuntimeList.newInstance((List)fullProductPeriodList);
            this.periodDataStart = initialDate.getTime();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public int getBalanceMode() {
        return this.contractMode;
    }

    public int getStatus() {
        return this.contractStatus;
    }

    public void setStatus(int status) {
        this.contractStatus = status;
    }

    public String getContractTitle() {
        return this.contractTitle;
    }

    @Override
    public String toString() {
        return "ContractRuntime[" + this.contractId + "]@" + System.identityHashCode(this);
    }

    public Contract toContract(ConnectionSet connectionSet, long now) throws BGException {
        Contract result = new Contract();
        result.setId(this.contractId);
        result.setTitle(this.contractTitle);
        if (this.dependSubContractIds != null) {
            result.setDependSubList(Utils.toString(Arrays.asList(new int[][]{this.dependSubContractIds})));
        } else {
            result.setDependSubList("");
        }
        result.setDomainId(this.domainId);
        result.setGroups(this.contractGroups);
        result.setBalanceMode(this.contractMode);
        result.setStatus(this.contractStatus);
        if (this.superContractId > 0) {
            result.setSuperId(this.superContractId);
            result.setSubMode(0);
        } else if (this.independentSuperContractId > 0) {
            result.setSuperId(this.independentSuperContractId);
            result.setSubMode(1);
        }
        ConvergenceBalance convergenceBalance = ConvergenceBalanceManager.getInstance().getBalance(connectionSet, this.contractId, now);
        result.setBalanceLimit(convergenceBalance.getLimit());
        return result;
    }

    public int getIndependentSuperContractId() {
        return this.independentSuperContractId;
    }

    static {
        try {
            GregorianCalendar utilCalendar = new GregorianCalendar();
            ContractRuntime.STUB.contractStatuses = new ContractStatusList2(new ArrayList<ContractStatus>(), utilCalendar);
            ContractRuntime.STUB.tariffOptions = new ContractTariffOptionList(new ArrayList<ContractTariffOptionList.OptionItem>());
            ContractRuntime.STUB.contractProductPeriodItemList = ProductPeriodRuntimeList.newInstance(new ArrayList());
            ContractRuntime.STUB.productPeriodItemList = ProductPeriodRuntimeList.newInstance(new ArrayList());
            ((Calendar)utilCalendar).add(1, -1);
            ContractRuntime.STUB.periodDataStart = utilCalendar.getTimeInMillis();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }
}

