/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class ListValueDirectory
extends BGPanel
implements ActionListener {
    private BGUList<BGUListItem> paramList = new BGUList();
    private BGUList<BGUListItem> valuesList = new BGUList();
    private BGTextField valueTitle_TF = new BGTextField();
    private JPanel editor = new JPanel(new GridBagLayout());
    private ContractObjectService contractObjectService;

    public ListValueDirectory() {
        this.jbInit();
        this.editor.setVisible(false);
        ClientUtils.addShowCodeListener(this.valuesList);
    }

    private void jbInit() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(this);
        toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        JPanel paramViewer = new JPanel(new GridBagLayout());
        paramViewer.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        paramViewer.add((Component)new JScrollPane(this.valuesList), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramViewer.add((Component)this.editor, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JSplitPane mainSplit = new JSplitPane();
        mainSplit.setOrientation(0);
        mainSplit.setTopComponent(new JScrollPane(this.paramList));
        mainSplit.setBottomComponent(paramViewer);
        mainSplit.setDividerSize(4);
        mainSplit.setDividerLocation(500);
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopValueEdit(e.getActionCommand().equals("ok")));
        this.editor.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)this.valueTitle_TF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 10), 0, 0));
        this.editor.add((Component)okCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)mainSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.paramList.setSelectionMode(0);
        this.paramList.getSelectionModel().addListSelectionListener(a -> {
            if (!a.getValueIsAdjusting()) {
                this.showValues();
            }
        });
        this.valuesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListValueDirectory.this.actionPerformed(new ActionEvent(this, 0, "editItem"));
                }
            }
        });
    }

    @Override
    public void setData() {
        try {
            this.paramList.setData(this.getContractObjectService().getListParameters().stream().map(a -> new BGUListItem((IdTitle)((Object)a))).toList());
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void showValues() {
        this.paramList.optSelectedValue().ifPresentOrElse(item -> {
            try {
                this.valuesList.setData(this.getContractObjectService().getValuesForListParameter(item.getId()).stream().map(a -> new BGUListItem((IdTitle)a)).toList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            this.editor.setVisible(false);
        }, () -> this.valuesList.setData(Collections.emptyList()));
    }

    private void startValueEdit() {
        this.editor.setVisible(true);
    }

    private void stopValueEdit(boolean save) {
        if (save) {
            int paramId = this.paramList.optSelectedValue().map(a -> a.getId()).orElse(-1);
            String title = this.valueTitle_TF.getText();
            if (paramId < 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440!");
                return;
            }
            if (Utils.isBlankString(title)) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
                return;
            }
            try {
                ListValue value = new ListValue();
                value.setId(Integer.parseInt(this.id));
                value.setParamId(paramId);
                value.setTitle(title);
                this.getContractObjectService().updateListParameterValue(value);
                this.editor.setVisible(false);
                this.showValues();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        } else {
            this.editor.setVisible(false);
        }
    }

    private void deleteValue() {
        int valueId = this.valuesList.optSelectedValue().map(a -> a.getId()).orElse(-1);
        if (valueId > 0 && ClientUtils.confirmDelete("\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435")) {
            try {
                this.getContractObjectService().deleteListParameterValue(valueId);
                this.showValues();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command != null) {
            if (command.equals("newItem")) {
                this.id = "0";
                this.valueTitle_TF.setText("");
                this.startValueEdit();
            }
            if (command.equals("editItem")) {
                this.valuesList.optSelectedValue().ifPresentOrElse(item -> {
                    this.id = String.valueOf(item.getId());
                    this.valueTitle_TF.setText(item.getTitle());
                    this.startValueEdit();
                }, () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!"));
            } else if (command.equals("deleteItem")) {
                this.deleteValue();
            }
        }
    }

    private ContractObjectService getContractObjectService() {
        if (this.contractObjectService == null) {
            this.contractObjectService = this.getContext().getWebService(ContractObjectService.class, 0);
        }
        return this.contractObjectService;
    }
}

