/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.common.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class TransactionUtils {
    public static void setMinMaxSum(ParameterMap moduleSetup, Map<String, Object> dataMap, String prefix, Class<?> constantsClass) {
        try {
            String keyModuleSumMin = (String)constantsClass.getDeclaredField("KEY_" + prefix + "_SUM_MIN").get(null);
            String keyModuleSumMax = (String)constantsClass.getDeclaredField("KEY_" + prefix + "_SUM_MAX").get(null);
            Integer moduleSumMin = (Integer)constantsClass.getDeclaredField(prefix + "_SUM_MIN").get(null);
            Integer moduleSumMax = (Integer)constantsClass.getDeclaredField(prefix + "_SUM_MAX").get(null);
            dataMap.put("sumMin", Utils.formatBigDecimalSumm(moduleSetup.getBigDecimal(keyModuleSumMin, new BigDecimal(moduleSumMin))));
            dataMap.put("sumMax", Utils.formatBigDecimalSumm(moduleSetup.getBigDecimal(keyModuleSumMax, new BigDecimal(moduleSumMax))));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAutopaymentData(int moduleId, int contractId, ParameterMap moduleSetup, Map<String, Object> dataMap, Connection con, String prefix, AbstractAutopaymentManager autopaymentManager, Class<?> constantsClass) throws BGException {
        boolean autopaymentEnable = moduleSetup.getBoolean(prefix + ".autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled(con, moduleId, contractId)) {
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
            Preferences autopaymentModePreferences = new Preferences();
            TransactionUtils.setAutopaymentEnabled(moduleSetup, dataMap, autopayment, autopaymentModePreferences, prefix, constantsClass);
            TransactionUtils.setAutopaymentModeWeek(moduleSetup, dataMap, autopayment, autopaymentModePreferences, prefix, constantsClass);
            TransactionUtils.setAutopaymentModeMonth(moduleSetup, dataMap, autopayment, autopaymentModePreferences, prefix, constantsClass);
            TransactionUtils.setAutopaymentModeAuto(moduleSetup, dataMap, autopayment, autopaymentModePreferences, prefix, constantsClass);
        }
    }

    public static void setAutopaymentEnabled(ParameterMap moduleSetup, Map<String, Object> dataMap, Autopayment autopayment, Preferences autopaymentModePreferences, String prefix, Class<?> constantsClass) {
        try {
            int autopaymentModeDefault = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_DEFAULT").get(null);
            int autopaymentMode = moduleSetup.getInt(prefix + ".autopayment.mode.default", autopaymentModeDefault);
            if (autopayment != null) {
                autopaymentMode = autopayment.getMode().getCode();
                autopaymentModePreferences.loadData(autopayment.getModeData(), "\n");
            }
            dataMap.put("autopayment.enable", true);
            dataMap.put("autopayment.mode", autopaymentMode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAutopaymentModeWeek(ParameterMap moduleSetup, Map<String, Object> dataMap, Autopayment autopayment, Preferences autopaymentModePreferences, String prefix, Class<?> constantsClass) {
        boolean autopaymentModeWeekEnable = moduleSetup.getBoolean(prefix + ".autopayment.mode.week.enable", false);
        dataMap.put("autopayment.mode.week.enable", autopaymentModeWeekEnable);
        if (autopaymentModeWeekEnable) {
            try {
                int autopaymentWeekDay = moduleSetup.getInt(prefix + ".autopayment.mode.week.day.default", 1);
                int autopaymentWeekSumDefault = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_WEEK_SUM_DEFAULT").get(null);
                BigDecimal autopaymentWeekSum = moduleSetup.getBigDecimal(prefix + ".autopayment.mode.week.sum.default", new BigDecimal(autopaymentWeekSumDefault));
                if (autopayment != null) {
                    autopaymentWeekDay = autopaymentModePreferences.getInt("autopayment.mode.week.day", autopaymentWeekDay);
                    autopaymentWeekSum = autopaymentModePreferences.getBigDecimal("autopayment.mode.week.sum", autopaymentWeekSum);
                }
                dataMap.put("autopayment.mode.week.day", autopaymentWeekDay);
                dataMap.put("autopayment.mode.week.sum", autopaymentWeekSum);
                int autopaymentModeWeekSumMin = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_WEEK_SUM_MIN").get(null);
                dataMap.put("autopayment.mode.week.sum.min", moduleSetup.getInt(prefix + ".autopayment.mode.week.sum.min", autopaymentModeWeekSumMin));
                int autopaymentModeWeekSumMax = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_WEEK_SUM_MAX").get(null);
                dataMap.put("autopayment.mode.week.sum.max", moduleSetup.getInt(prefix + ".autopayment.mode.week.sum.max", autopaymentModeWeekSumMax));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setAutopaymentModeMonth(ParameterMap moduleSetup, Map<String, Object> dataMap, Autopayment autopayment, Preferences autopaymentModePreferences, String prefix, Class<?> constantsClass) {
        boolean autopaymentModeMonthEnable = moduleSetup.getBoolean(prefix + ".autopayment.mode.month.enable", false);
        dataMap.put("autopayment.mode.month.enable", autopaymentModeMonthEnable);
        if (autopaymentModeMonthEnable) {
            try {
                int autopaymentMonthDay = moduleSetup.getInt(prefix + ".autopayment.mode.month.day.default", 1);
                int autopaymentMonthSumDefault = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_MONTH_SUM_DEFAULT").get(null);
                BigDecimal autopaymentMonthSum = moduleSetup.getBigDecimal(prefix + ".autopayment.mode.month.sum.default", new BigDecimal(autopaymentMonthSumDefault));
                if (autopayment != null) {
                    autopaymentMonthDay = autopaymentModePreferences.getInt("autopayment.mode.month.day", autopaymentMonthDay);
                    autopaymentMonthSum = autopaymentModePreferences.getBigDecimal("autopayment.mode.month.sum", autopaymentMonthSum);
                }
                dataMap.put("autopayment.mode.month.day", autopaymentMonthDay);
                dataMap.put("autopayment.mode.month.sum", autopaymentMonthSum);
                int autopaymentModeMonthSumMin = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_MONTH_SUM_MIN").get(null);
                dataMap.put("autopayment.mode.month.sum.min", moduleSetup.getInt(prefix + ".autopayment.mode.month.sum.min", autopaymentModeMonthSumMin));
                int autopaymentModeMonthSumMax = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_MONTH_SUM_MAX").get(null);
                dataMap.put("autopayment.mode.month.sum.max", moduleSetup.getInt(prefix + ".autopayment.mode.month.sum.max", autopaymentModeMonthSumMax));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setAutopaymentModeAuto(ParameterMap moduleSetup, Map<String, Object> dataMap, Autopayment autopayment, Preferences autopaymentModePreferences, String prefix, Class<?> constantsClass) {
        boolean autopaymentModeAutoEnable = moduleSetup.getBoolean(prefix + ".autopayment.mode.auto.enable", false);
        dataMap.put("autopayment.mode.auto.enable", autopaymentModeAutoEnable);
        if (autopaymentModeAutoEnable) {
            try {
                int autopaymentAutoDaySumDefault = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_AUTO_DAY_SUM_DEFAULT").get(null);
                BigDecimal autopaymentAutoDaySum = moduleSetup.getBigDecimal(prefix + ".autopayment.mode.auto.day.sum.default", new BigDecimal(autopaymentAutoDaySumDefault));
                int autopaymentAutoWeekSumDefault = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_AUTO_WEEK_SUM_DEFAULT").get(null);
                BigDecimal autopaymentAutoWeekSum = moduleSetup.getBigDecimal(prefix + ".autopayment.mode.auto.week.sum.default", new BigDecimal(autopaymentAutoWeekSumDefault));
                int autopaymentAutoMonthSumDefault = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_AUTO_MONTH_SUM_DEFAULT").get(null);
                BigDecimal autopaymentAutoMonthSum = moduleSetup.getBigDecimal(prefix + ".autopayment.mode.auto.month.sum.default", new BigDecimal(autopaymentAutoMonthSumDefault));
                if (autopayment != null) {
                    autopaymentAutoDaySum = autopaymentModePreferences.getBigDecimal("autopayment.mode.auto.day.sum", autopaymentAutoDaySum);
                    autopaymentAutoWeekSum = autopaymentModePreferences.getBigDecimal("autopayment.mode.auto.week.sum", autopaymentAutoWeekSum);
                    autopaymentAutoMonthSum = autopaymentModePreferences.getBigDecimal("autopayment.mode.auto.month.sum", autopaymentAutoMonthSum);
                }
                dataMap.put("autopayment.mode.auto.day.sum", autopaymentAutoDaySum);
                int autopaymentModeAutoDaySumMax = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_AUTO_DAY_SUM_MAX").get(null);
                dataMap.put("autopayment.mode.auto.day.sum.max", moduleSetup.getInt(prefix + ".autopayment.mode.auto.day.sum.max", autopaymentModeAutoDaySumMax));
                dataMap.put("autopayment.mode.auto.week.sum", autopaymentAutoWeekSum);
                int autopaymentModeAutoWeekSumMax = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_AUTO_WEEK_SUM_MAX").get(null);
                dataMap.put("autopayment.mode.auto.week.sum.max", moduleSetup.getInt(prefix + ".autopayment.mode.auto.week.sum.max", autopaymentModeAutoWeekSumMax));
                dataMap.put("autopayment.mode.auto.month.sum", autopaymentAutoMonthSum);
                int autopaymentModeAutoMonthSumMax = (Integer)constantsClass.getDeclaredField(prefix.toUpperCase() + "_AUTOPAYMENT_MODE_AUTO_MONTH_SUM_MAX").get(null);
                dataMap.put("autopayment.mode.auto.month.sum.max", moduleSetup.getInt(prefix + ".autopayment.mode.auto.month.sum.max", autopaymentModeAutoMonthSumMax));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void doAutopayment(ParameterMap moduleSetup, String prefix, Class<?> constantsClass) {
    }
}

