/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.Utils;
import ru.bitel.common.model.TreeNode;
import ru.bitel.common.xml.JAXBUtils;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;

public abstract class Device<D extends Device<D, T>, T extends DeviceType>
extends Entity
implements TreeNode<D>,
Transferable {
    private static final Logger logger = LogManager.getLogger();
    private final DataFlavor[] dataFlavors = new DataFlavor[]{new DataFlavor(Device.class, "Device")};
    private int sort = 0;
    protected int deviceTypeId;
    protected transient T deviceType;
    protected String identifier;
    protected String host;
    protected Set<Integer> deviceGroupIds;
    private String username;
    private String password;
    protected String secret;
    protected String config;
    protected String comment;
    protected int parentId;
    protected List<D> children;
    protected volatile String uptime;
    protected volatile Date uptimeTime;
    protected Date dateFrom;
    protected Date dateTo;
    protected boolean orderManagerDisabled;

    @XmlAttribute
    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    @XmlAttribute
    public int getDeviceTypeId() {
        return this.deviceTypeId;
    }

    public void setDeviceTypeId(int deviceTypeId) {
        this.deviceTypeId = deviceTypeId;
    }

    @XmlAttribute
    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    @XmlTransient
    public T getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(T deviceType) {
        this.deviceType = deviceType;
    }

    @XmlAttribute(name="ident")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @XmlAttribute
    public Set<Integer> getDeviceGroupIds() {
        return this.deviceGroupIds;
    }

    public void setDeviceGroupIds(Set<Integer> deviceGroupIds) {
        this.deviceGroupIds = deviceGroupIds;
    }

    public String getHost() {
        return this.host;
    }

    @XmlTransient
    public List<InetSocketAddress> getHosts() {
        ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>();
        String[] hosts = this.getHost().split("\\s*,\\s*");
        for (int i = 0; i < hosts.length; ++i) {
            try {
                if (!Utils.notBlankString(hosts[i]) || hosts[i].startsWith("\"") && hosts[i].endsWith("\"")) continue;
                String[] hostPort = hosts[i].split(":");
                if (hostPort.length == 2) {
                    String host = hostPort[0].trim();
                    int port = Utils.parseInt(hostPort[1].trim());
                    result.add(new InetSocketAddress(host, port));
                    continue;
                }
                result.add(new InetSocketAddress(hosts[i], 0));
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        InetSocketAddress addr = new InetSocketAddress("81.30.206.92", 0);
        System.out.println(addr.getHostName());
        System.out.println(addr.getAddress());
        System.out.println(addr.getAddress().getHostName());
        System.out.println(addr.getAddress().getCanonicalHostName());
        System.out.println(addr.getAddress().getHostAddress());
    }

    @XmlTransient
    public List<String[]> getHostsAsString() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        String[] hosts = this.getHost().split("\\s*,\\s*");
        for (int i = 0; i < hosts.length; ++i) {
            try {
                if (!Utils.notBlankString(hosts[i]) || hosts[i].startsWith("\"") && hosts[i].endsWith("\"")) continue;
                String[] hostPort = hosts[i].split(":");
                if (hostPort.length == 2) {
                    String host = hostPort[0];
                    result.add(new String[]{host, hostPort[1]});
                    continue;
                }
                result.add(new String[]{hosts[i], "0"});
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String user) {
        this.username = user;
    }

    @XmlAttribute
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @XmlAttribute
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    @Override
    public List<D> getChildren() {
        return this.children;
    }

    public void setChildren(List<D> children) {
        this.children = children;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getUptime() {
        return this.uptime;
    }

    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    public Date getUptimeTime() {
        return this.uptimeTime;
    }

    public void setUptimeTime(Date uptimeCheckTime) {
        this.uptimeTime = uptimeCheckTime;
    }

    public static String generateTitle(Device<?, ?> device, DeviceType type) {
        String identifier = device.getIdentifier();
        String host = device.getHost();
        return Device.generateTitle(identifier, host, type != null ? type.getGuiTitle() : null);
    }

    public static String generateTitle(String identifier, String host, String type) {
        Object title = identifier;
        if (Utils.notBlankString(host)) {
            Object object = title = Utils.notBlankString(identifier) ? identifier + " [" + host + "]" : "[" + host + "]";
        }
        if (Utils.notEmptyString((String)title)) {
            return (type == null ? "" : type) + ": " + (String)title;
        }
        return type == null ? "" : type.toString();
    }

    public D[] findCodePath(int pid) {
        ArrayList result = new ArrayList();
        this.findCodePath(pid, result);
        int size = result.size();
        Device[] r = (Device[])Array.newInstance(this.getClass(), size);
        for (int i = 0; i < size; ++i) {
            r[i] = (Device)result.get(size - i - 1);
        }
        return r;
    }

    private void findCodePath(int pid, List<D> path) {
        if (pid == this.getId()) {
            path.add(this);
            return;
        }
        if (this.children != null) {
            for (Device item : this.children) {
                item.findCodePath(pid, path);
                if (path.isEmpty()) continue;
                path.add(this);
                return;
            }
        }
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    @XmlAttribute(name="omDisabled")
    public boolean isOrderManagerDisabled() {
        return this.orderManagerDisabled;
    }

    public void setOrderManagerDisabled(boolean orderManagerDisabled) {
        this.orderManagerDisabled = orderManagerDisabled;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.dataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor != null && flavor.equals(this.dataFlavors[0]);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this;
    }

    public List<Device<D, T>> toList() {
        ArrayList<Device<D, T>> list = new ArrayList<Device<D, T>>();
        this.toList(this, list);
        return list;
    }

    private void toList(Device<D, T> device, List<Device<D, T>> list) {
        list.add(device);
        if (device.children != null) {
            for (Device d : device.children) {
                this.toList(d, list);
            }
        }
    }
}

