/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrListDao
extends EntityAttrDefaultDao<EntityAttrList> {
    private String listValueTable;

    public EntityAttrListDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String listTable, String listValueTable) {
        super(con, entityAttrDao, listTable);
        this.listValueTable = listValueTable;
    }

    @Override
    protected void createTable() {
        try (Statement createStatement = this.con.createStatement();){
            createStatement.execute("CREATE TABLE IF NOT EXISTS `" + this.table + "` ( `entityId` int(11) NOT NULL DEFAULT 0, `entitySpecAttrId` int(11) NOT NULL DEFAULT 0, `value` int(11) NOT NULL DEFAULT 0, PRIMARY KEY (`entityId`,`entitySpecAttrId`) )");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        String query = "SELECT v." + this.valueName() + ", t.title AS title FROM " + this.table + " as v LEFT JOIN " + this.listValueTable + " as t ON t.id=v." + this.valueName() + " WHERE v." + this.idName() + "=? AND v." + this.typeName() + "=?";
        PreparedStatement selectPS = this.con.prepareStatement(query);
        selectPS.setInt(1, entityId);
        selectPS.setInt(2, entitySpecAttrId);
        return selectPS;
    }

    @Override
    public EntityAttrList get(int entityId, int attrSpecId) throws BGException {
        EntityAttrList result = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = new EntityAttrList(entityId, attrSpecId, rs.getInt(1), rs.getString("title"));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        EntityAttrList attr = (EntityAttrList)a;
        if (attr.getValue() <= 0 && Utils.isBlankString((String)attr.getCustomValue())) {
            return;
        }
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setInt(3, attr.getValue());
            ps.executeUpdate();
        }
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrList attr) throws SQLException {
        if (attr.getValue() <= 0 && Utils.isBlankString((String)attr.getCustomValue())) {
            return this.deleteImpl(entityId, attr.getEntitySpecAttrId());
        }
        boolean update = false;
        int oldValue = 0;
        try (PreparedStatement ps = this.getSelectPS(entityId, attr.getEntitySpecAttrId());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                oldValue = rs.getInt(1);
                update = true;
            }
        }
        if (update) {
            ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setInt(1, attr.getValue());
                ps.executeUpdate();
                boolean bl = attr.getValue() != oldValue;
                return bl;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
        try {
            ps.setInt(3, attr.getValue());
            ps.executeUpdate();
            boolean bl = true;
            return bl;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    @Override
    protected void insertHistory(int contractId, int entitySpecAttrId, EntityAttrList attr) throws SQLException {
        String title = attr != null ? (attr.getValue() <= 0 ? attr.getCustomValue() : attr.getTitle()) : null;
        String query = "INSERT INTO " + this.table + "_log SET  " + this.idName() + "=?, " + this.typeName() + "=?, val=?, title=?, dt_change=?, user_id=?";
        try (PreparedStatement insertHistoryPS = this.con.prepareStatement(query);){
            insertHistoryPS.setInt(1, contractId);
            insertHistoryPS.setInt(2, entitySpecAttrId);
            insertHistoryPS.setInt(3, attr != null ? Integer.valueOf(attr.getValue()) : null);
            insertHistoryPS.setString(4, title);
            insertHistoryPS.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            insertHistoryPS.setInt(6, this.entityAttrDao.userId);
            insertHistoryPS.executeUpdate();
        }
    }
}

