/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import jakarta.servlet.http.HttpSession;
import java.time.LocalDateTime;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.common.Utils;

public class ActionContracts
extends AbstractAction {
    public ActionContracts() {
        super("contract");
    }

    @Override
    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
        this.setResultParam("pageTitle", "\u041a\u043b\u0438\u0435\u043d\u0442. \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        if (this.req.getBoolean("getBody", false)) {
            this.requestDispatcher(this.moduleName, "../contract/contracts");
        } else {
            this.setResultParam("jspPage", "contract/contracts.jsp");
        }
    }

    @WebOperation(title="\u0414\u0430\u043d\u043d\u044b\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430")
    public void customer() throws BGException {
        CustomerDao customerDao = new CustomerDao(this.con);
        HttpSession httpSession = this.context.getRequest().getSession();
        Contract generalContract = (Contract)httpSession.getAttribute("contract_general");
        Optional<CustomerLink> optional = customerDao.getCustomerLink(generalContract.getId(), LocalDateTime.now());
        if (optional.isPresent()) {
            Customer customer = customerDao.getCustomer(optional.get().getCustomerId());
            JSONObject customerJSON = new JSONObject(customer.getData());
            if (customer.getCustomerType().equals((Object)Customer.CustomerType.FIZ_CUSTOMER)) {
                this.setResultParam("customerFioLast", Utils.maskNull((String)((String)customerJSON.optQuery("/customer/fio/last"))));
                this.setResultParam("customerFioFirst", Utils.maskNull((String)((String)customerJSON.optQuery("/customer/fio/first"))));
                this.setResultParam("customerFioMiddle", Utils.maskNull((String)((String)customerJSON.optQuery("/customer/fio/middle"))));
                this.setResultParam("customerPhone", this.contactToString(customerJSON.optQuery("/customer/contact/phone")));
                this.setResultParam("customerEmail", this.contactToString(customerJSON.optQuery("/customer/contact/email")));
                this.setResultParam("customerMobile", this.contactToString(customerJSON.optQuery("/customer/contact/mobile")));
            } else if (customer.getCustomerType().equals((Object)Customer.CustomerType.JUR_CUSTOMER)) {
                this.setResultParam("customerName", Utils.maskNull((String)((String)customerJSON.optQuery("/customer/name"))));
                this.setResultParam("customerOgrn", Utils.maskNull((String)((String)customerJSON.optQuery("/customer/ogrn"))));
                this.setResultParam("customerDirector", Utils.maskNull((String)((String)customerJSON.optQuery("/customer/director/post"))) + " " + Utils.maskNull((String)((String)customerJSON.optQuery("/customer/director/fio"))));
                this.setResultParam("customerInn", Utils.maskNull((String)((String)customerJSON.optQuery("/customer/inn"))) + " / " + Utils.maskNull((String)((String)customerJSON.optQuery("/customer/kpp"))));
                this.setResultParam("customerPhone", this.contactToString(customerJSON.optQuery("/customer/contact/phone")));
                this.setResultParam("customerEmail", this.contactToString(customerJSON.optQuery("/customer/contact/email")));
            }
            this.setResultParam("customer", customer);
            this.setResultParam("customerJson", customerJSON.toString());
        }
        this.requestDispatcher(this.moduleName, "customer");
    }

    private String contactToString(Object object) {
        StringBuilder str = new StringBuilder();
        if (object instanceof JSONArray) {
            JSONArray array = (JSONArray)object;
            int len = array.length();
            for (int index = 0; index < len; ++index) {
                JSONObject json = array.getJSONObject(index);
                str.append(str.length() > 0 ? "; " : "").append(json.get("value"));
            }
        }
        return str.toString();
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432")
    public void contracts() throws BGException {
        this.requestDispatcher(this.moduleName, "contract_list");
    }

    @WebOperation(title="\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    public void subcontracts() throws BGException {
        this.requestDispatcher(this.moduleName, "contract_sublist");
    }

    @WebOperation(title="\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440")
    public void changeContract() throws BGException {
        String contractTitle = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle().toUpperCase();
        ActionMessage message = new ActionMessage("", "", "?", this.moduleSetup.get("web.message.switch.to.contract", "\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 ${contractTitle}").replaceAll("\\$\\{contractTitle\\}", contractTitle));
        message.setOnClose("reload");
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }
}

