/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.editor.RuleTypeEditorPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class RuleTypeEditor
extends BGPanel {
    private BGTextField title_TF = new BGTextField();
    private JTextArea comment_TA = new JTextArea();
    private JPanel rightPanel = new JPanel(new GridBagLayout());
    private JLabel emptyLabel = new JLabel("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043d\u0435 \u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d");
    private GridBagConstraints rightConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
    private RuleTypeEditorPanel ruleTypeEditor;

    public RuleTypeEditor() {
        this.jbInit();
    }

    private void jbInit() {
        this.title_TF.setMinimumSize(new Dimension(300, 24));
        this.title_TF.setPreferredSize(new Dimension(300, 24));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleTypeEditor.this.stopEdit(e.getActionCommand().equals("ok"));
            }
        });
        this.rightPanel.add((Component)this.emptyLabel, this.rightConstraints);
        this.setLayout(new GridBagLayout());
        this.add(new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.title_TF, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JScrollPane(this.comment_TA), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.rightPanel, new GridBagConstraints(1, 0, 1, 4, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void init(String module, int mid) {
        super.init(module, mid);
    }

    public void setData() {
        this.rightPanel.removeAll();
        this.rightPanel.add((Component)this.emptyLabel, this.rightConstraints);
        this.ruleTypeEditor = new RuleTypeEditorPanel();
        if (this.ruleTypeEditor != null) {
            this.rightPanel.removeAll();
            this.rightPanel.add((Component)((Object)this.ruleTypeEditor), this.rightConstraints);
        }
        if ("0".equals(this.id)) {
            this.title_TF.setText("");
            this.comment_TA.setText("");
        } else {
            Request req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAction("GetRuleType");
            req.setAttribute("id", this.id);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element type = XMLUtils.getElement((Document)doc, (String)"rule_type");
                this.title_TF.setText(type.getAttribute("title"));
                this.comment_TA.setText(ClientUtils.linesToString((Element)XMLUtils.getElement((Document)doc, (String)"comment")));
                if (this.ruleTypeEditor != null) {
                    Element data = XMLUtils.selectElement((Node)doc, (String)"/data/rule_type/data");
                    this.ruleTypeEditor.setData(ClientUtils.linesToString((Element)data));
                }
            }
        }
        this.updateUI();
    }

    private void stopEdit(boolean save) {
        if (save && this.ruleTypeEditor != null) {
            String title = this.title_TF.getText();
            if (Utils.isBlankString((String)title)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("UpdateRuleType");
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", this.id);
            request.setAttribute("title", title);
            request.setAttribute("comment", this.comment_TA.getText());
            request.setAttribute("data", this.ruleTypeEditor.getData());
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }
}

