/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn;

import bitel.billing.server.ext.DatagramChannelListener;
import bitel.billing.server.netflow.ipn.FlowsLoader;
import bitel.billing.server.netflow.ipn.NetFlowRequestThread;
import bitel.billing.server.netflow.ipn.NetFlowSetup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class NetFlowPortListener
extends DatagramChannelListener<NetFlowSetup> {
    private static Logger logger = LogManager.getLogger((String)"collector");
    private FlowsLoader flowLoader;

    public NetFlowPortListener(NetFlowSetup setup, FlowsLoader flowLoader, int port) {
        super(port, setup.getInt("netflow.thread.count", 20), true, logger, setup.getInt("netflow.receive.buffer.capacity", 0x800000), null, (Object)setup);
        this.flowLoader = flowLoader;
        this.init();
        this.setPriority(10);
        this.start();
    }

    public void init() {
        try {
            this.channel.socket().setReceiveBufferSize(((NetFlowSetup)((Object)this.setup)).getInt("netflow.receive.socket.buffer.size", 0x300000));
            super.init();
            this.channel.socket().setBroadcast(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ThreadPoolExecutor newThreadPoolExecutor(boolean multiThread) {
        RejectedExecutionHandler rejectedExecutionHandler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    NetFlowPortListener.this.log.warn("Wating for free Thread..");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    executor.execute(r);
                }
            }
        };
        return new ThreadPoolExecutor(this.threadCount, this.threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), rejectedExecutionHandler);
    }

    public Runnable createProcessingRunnable(SocketAddress clientAddress, ByteBuffer data) {
        return new NetFlowRequestThread(this.flowLoader, (InetSocketAddress)clientAddress, data);
    }

    public String getStatus() {
        StringBuilder result = new StringBuilder();
        if (this.pool != null) {
            result.append("queue_size: ");
            result.append(this.pool.getQueue().size());
            result.append("; threads_active: ");
            result.append(this.pool.getActiveCount());
            result.append("; largest: ");
            result.append(this.pool.getLargestPoolSize());
            result.append("; core: ");
            result.append(this.pool.getCorePoolSize());
            result.append("; pool_size: ");
            result.append(this.pool.getPoolSize());
        }
        DecimalFormat df = new DecimalFormat("###,###,###,###");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(' ');
        df.setDecimalFormatSymbols(dfs);
        if (result.length() > 0) {
            result.append("; ");
        }
        result.append("recv_socket_buf_size: ");
        try {
            result.append(df.format(this.channel.socket().getReceiveBufferSize()));
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        result.append("; recv_buf_size: ").append(df.format(this.byteBufferCapacity));
        return result.toString();
    }
}

