/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetServModifiedEvent;
import ru.bitel.common.sql.ConnectionSet;

public class InetServUtils {
    private static final Logger logger = LogManager.getLogger();

    public static void updateIdentifier(ConnectionSet connectionSet, int moduleId, InetServ inetServ, String identifier, boolean add) throws BGException {
        InetServ oldInetServ = inetServ.clone();
        ArrayList<String> identifierList = inetServ.getIdentifierList();
        identifierList = add ? new ArrayList<String>(identifierList) : new ArrayList(4);
        identifierList.add(identifier);
        try (InetServDao dao = new InetServDao(connectionSet.getConnection(), moduleId);){
            dao.updateIdentifier(inetServ.getId(), identifierList);
            connectionSet.commit();
            inetServ.setIdentifierList(identifierList);
        }
        EventProcessor.getInstance().publish((Event)new InetServModifiedEvent(moduleId, inetServ.getContractId(), 0, oldInetServ, inetServ, null));
    }

    public static boolean checkIdentifier(ConnectionSet connectionSet, int moduleId, InetServ inetServ, String identifier, int setIdentifier) throws BGException {
        if (identifier == null || identifier.length() == 0) {
            return true;
        }
        switch (setIdentifier) {
            default: {
                Boolean result = InetUtils.checkIdentifier(inetServ, identifier);
                if (!Boolean.FALSE.equals(result)) break;
                return false;
            }
            case 1: {
                Boolean result = InetUtils.checkIdentifier(inetServ, identifier);
                if (Boolean.FALSE.equals(result)) {
                    return false;
                }
                if (result != null) break;
                InetServUtils.updateIdentifier(connectionSet, moduleId, inetServ, identifier, false);
                break;
            }
            case 2: {
                Boolean result = InetUtils.checkIdentifier(inetServ, identifier);
                if (Boolean.TRUE.equals(result)) break;
                InetServUtils.updateIdentifier(connectionSet, moduleId, inetServ, identifier, false);
                break;
            }
            case 3: {
                Boolean result = InetUtils.checkIdentifier(inetServ, identifier);
                if (Boolean.TRUE.equals(result)) break;
                InetServUtils.updateIdentifier(connectionSet, moduleId, inetServ, identifier, true);
                break;
            }
        }
        return true;
    }

    public static void updateMacAddress(ConnectionSet connectionSet, int moduleId, InetServ inetServ, byte[] macAddress, boolean add) throws BGException {
        InetServ oldInetServ = inetServ.clone();
        byte[] macAddressListBytes = inetServ.getMacAddressListBytes();
        if (add && macAddressListBytes != null && macAddressListBytes.length > 0 && (macAddress.length == 6 || macAddress.length == 8) && macAddressListBytes.length % macAddress.length == 0) {
            byte[] newMacAddressListBytes = Arrays.copyOf(macAddressListBytes, macAddressListBytes.length + macAddress.length);
            System.arraycopy(macAddress, 0, newMacAddressListBytes, macAddressListBytes.length, macAddress.length);
            macAddressListBytes = newMacAddressListBytes;
        } else {
            macAddressListBytes = macAddress;
        }
        try (InetServDao dao = new InetServDao(connectionSet.getConnection(), moduleId);){
            dao.updateMacAddress(inetServ.getId(), macAddressListBytes);
            connectionSet.commit();
            inetServ.setMacAddressListBytes(macAddress);
        }
        EventProcessor.getInstance().publish((Event)new InetServModifiedEvent(moduleId, inetServ.getContractId(), 0, oldInetServ, inetServ, null));
    }

    public static boolean checkMacAddress(ConnectionSet connectionSet, int moduleId, InetServ inetServ, byte[] macAddress, int setMacAddress) throws BGException {
        logger.debug("checkMacAddress [setMacAddressMode = {}] macAddress.length={}", (Object)setMacAddress, macAddress == null ? null : Integer.valueOf(macAddress.length));
        if (macAddress == null || macAddress.length == 0) {
            return true;
        }
        switch (setMacAddress) {
            default: {
                Boolean result = InetUtils.checkMacAddress(inetServ, macAddress);
                if (!Boolean.FALSE.equals(result)) break;
                return false;
            }
            case 1: {
                Boolean result = InetUtils.checkMacAddress(inetServ, macAddress);
                if (Boolean.FALSE.equals(result)) {
                    return false;
                }
                if (result != null) break;
                InetServUtils.updateMacAddress(connectionSet, moduleId, inetServ, macAddress, false);
                break;
            }
            case 2: {
                Boolean result = InetUtils.checkMacAddress(inetServ, macAddress);
                if (Boolean.TRUE.equals(result)) break;
                InetServUtils.updateMacAddress(connectionSet, moduleId, inetServ, macAddress, false);
                break;
            }
            case 3: {
                Boolean result = InetUtils.checkMacAddress(inetServ, macAddress);
                if (Boolean.TRUE.equals(result)) break;
                InetServUtils.updateMacAddress(connectionSet, moduleId, inetServ, macAddress, true);
                break;
            }
        }
        return true;
    }
}

