/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.contract;

import bitel.billing.module.common.BGTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.util.MACParser;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.modules.inet.client.InetDevicePanel;
import ru.bitel.bgbilling.modules.inet.client.contract.AdditionalParamsPanel;
import ru.bitel.bgbilling.modules.inet.client.contract.InetErrorPanel;
import ru.bitel.bgbilling.modules.inet.client.contract.InetServAddressDialog;
import ru.bitel.bgbilling.modules.inet.client.contract.InetServDeviceInterfaceForm;
import ru.bitel.bgbilling.modules.inet.client.contract.InetServPanel;
import ru.bitel.bgbilling.modules.inet.client.contract.InetServRestrictionPanel;
import ru.bitel.bgbilling.modules.inet.client.contract.OptionPanel;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetOption;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServTypeIPMode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetAddressType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServStatus;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.client.EntityAttributesForm;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public class InetServForm
extends BGUPanel {
    private List<ParamRowData> params = null;
    private ParamRowData paramDevice = new ParamRowData("device", "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", "");
    private ParamRowData paramIface = new ParamRowData("iface", "\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", "");
    private ParamRowData paramVLAN = new ParamRowData("vlan", "VLAN", "0");
    private ParamRowData paramMAC = new ParamRowData("mac", "MAC-\u0430\u0434\u0440\u0435\u0441", "");
    private ParamRowData paramIdentifier = new ParamRowData("identifier", "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", "");
    private ParamRowData paramLogin = new ParamRowData("login", "\u041b\u043e\u0433\u0438\u043d", "");
    private ParamRowData paramAutoLogin = new ParamRowData("autoLogin", "\u0410\u0432\u0442\u043e\u043c. \u0433\u0435\u043d\u0435\u0440. \u043b\u043e\u0433\u0438\u043d\u0430", "");
    private ParamRowData paramPassword = new ParamRowData("password", "\u041f\u0430\u0440\u043e\u043b\u044c", "");
    private ParamRowData paramAutoPassword = new ParamRowData("autoPassword", "\u0410\u0432\u0442\u043e\u043c. \u0433\u0435\u043d\u0435\u0440. \u043f\u0430\u0440\u043e\u043b\u044f", "");
    private ParamRowData paramIPv4FramedAddress = new ParamRowData("IPv4FramedAddress", "Framed-IP-Address", "");
    private ParamRowData paramIPv4Range = new ParamRowData("IPv4Range", "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432 (IPv4)", "");
    private ParamRowData paramIPv4Net = new ParamRowData("IPv4Net", "\u0421\u0435\u0442\u044c (IPv4)", "");
    private ParamRowData paramIPv6FramedAddress = new ParamRowData("IPv6FramedAddress", "Framed-IPv6-Address", null);
    private ParamRowData paramIPv6FramedPrefix = new ParamRowData("IPv6FramedPrefix", "Framed-IPv6-Prefix", null);
    private ParamRowData paramIPv6DelegatedPrefix = new ParamRowData("IPv6DelegatedPrefix", "Delegated-IPv6-Prefix", null);
    private ParamRowData paramIPv6Range = new ParamRowData("IPv6Range", "\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432 (IPv6)", "");
    private ParamRowData paramIPv6Net = new ParamRowData("IPv6Net", "\u0421\u0435\u0442\u044c (IPv6)", "");
    private int deviceId = 0;
    private int interfaceId = 0;
    private ResourceService resourceService = null;
    private ParamTableModel paramTableModel = new ParamTableModel();
    InetServ parent;
    InetServ current;
    private BGTextField accountId = new BGTextField(6);
    protected BGUComboBox<InetServType> serviceType;
    protected BGControlPanelPeriodNoB period;
    private BGUComboBox<IdTitle> status;
    private JComponent sessionCountLimitPanel;
    private BGUComboBox<IdTitle> sessionCountLimit;
    private BGUComboBox<ContractObject> contractObject;
    private JComponent contractObjectPanel;
    private BGTextArea comment = new BGTextArea(3, 30);
    private BGTextArea state = new BGTextArea(3, 30);
    private final InetServPanel panel;
    private BGEditor editor;
    private InetServDeviceInterfaceForm interfaceForm;
    private OptionPanel optionPanel;
    private InetServRestrictionPanel restrictionPanel;
    private AdditionalParamsPanel additionalParamsPanel;
    private EntityAttributesForm entityAttributesForm;
    private InetErrorPanel errorPanel;
    private JTabbedPane pane;
    private JPopupMenu tableJPopupMenu = null;
    private volatile boolean onInetServSelected = true;
    private InetDevicePanel inetDevicePanel;
    private AtomicReference<InetServ> currentTypeRef = new AtomicReference();

    public InetServForm(InetServPanel panel) {
        super((LayoutManager)new BorderLayout());
        this.panel = panel;
        this.params = Arrays.asList(this.paramMAC, this.paramIdentifier);
    }

    protected void jbInit() {
        this.contractObject = new BGUComboBox();
        this.contractObjectPanel = BGSwingUtilites.wrapBorder(this.contractObject, (String)"\u041e\u0431\u044a\u0435\u043a\u0442");
        ActionListener editorsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if ("device.selected".equals(command)) {
                    InetDevicePanel panel = (InetDevicePanel)((Object)e.getSource());
                    InetDevice selectedDevice = (InetDevice)panel.getSelectedDevice();
                    InetServForm.this.current.setDeviceId(selectedDevice.getId());
                    InetServForm.this.paramDevice.value = selectedDevice.getFullTitle() + " (" + selectedDevice.getId() + ")";
                    InetServForm.this.deviceId = selectedDevice.getId();
                    ((BGUPanel)e.getSource()).performActionClose();
                }
            }
        };
        this.optionPanel = new OptionPanel((ClientContext)this.getContext(), null, false);
        this.restrictionPanel = new InetServRestrictionPanel((ClientContext)this.getContext(), null);
        this.additionalParamsPanel = new AdditionalParamsPanel((ClientContext)this.getContext());
        this.entityAttributesForm = new EntityAttributesForm(this.currentTypeRef, (ClientContext)this.getContext());
        this.errorPanel = new InetErrorPanel((ClientContext)this.getContext());
        this.pane = new JTabbedPane();
        this.pane.add((Component)this.getMainPanel(), "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438");
        this.pane.add((Component)((Object)this.optionPanel), "\u041e\u043f\u0446\u0438\u0438");
        this.pane.add((Component)((Object)this.restrictionPanel), "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f");
        this.pane.add((Component)((Object)this.additionalParamsPanel), "\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e");
        this.pane.add((Component)this.entityAttributesForm, "\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b");
        this.pane.add((Component)((Object)this.errorPanel), "\u041e\u0448\u0438\u0431\u043a\u0438");
        this.editor = new BGEditor("main");
        this.editor.addForm((JComponent)this.pane, (Object)"main");
        this.interfaceForm = new InetServDeviceInterfaceForm(this, editorsListener);
        this.editor.addForm((JComponent)((Object)this.interfaceForm));
        this.inetDevicePanel = new InetDevicePanel((ClientContext)this.getContext(), 2, editorsListener);
        this.editor.addForm((JComponent)BGSwingUtilites.wrapBorder((JPanel)((Object)this.inetDevicePanel), (String)"\u0412\u044b\u0431\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430"));
        this.add((Component)this.editor, "Center");
    }

    private JPanel getMainPanel() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ParamRowData paramRowData = (ParamRowData)InetServForm.this.paramTableModel.getSelectedRow();
                    int n = InetServForm.this.interfaceId = InetServForm.this.parent != null ? InetServForm.this.parent.getInterfaceId() : InetServForm.this.interfaceForm.getInterfaceId();
                    if (InetServForm.this.paramDevice.equals(paramRowData)) {
                        InetServForm.this.performAction("device.select", String.valueOf(InetServForm.this.current.getDeviceId()));
                    } else if (InetServForm.this.paramIface.equals(paramRowData)) {
                        InetServForm.this.interfaceForm.interfaceSelect.perform();
                    } else if (InetServForm.this.paramVLAN.equals(paramRowData)) {
                        String freeVlan = null;
                        try {
                            Set vlanResourceCategoryIds = InetServForm.this.panel.getInetServService().vlanResourceCategoryIds(InetServForm.this.current.getDeviceId());
                            freeVlan = String.valueOf(InetServForm.this.getResourceService().freeVlan(vlanResourceCategoryIds, InetServForm.this.period.getDateFrom(), InetServForm.this.period.getDateTo()));
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                        new VlanEditorDialog(paramRowData, freeVlan).open();
                    } else if (InetServForm.this.paramAutoLogin.equals(paramRowData)) {
                        boolean newValue = Boolean.valueOf(InetServForm.this.paramAutoLogin.value) == false;
                        InetServForm.this.paramAutoLogin.value = String.valueOf(newValue);
                        InetServForm.this.paramLogin.value = newValue ? "" : InetServForm.this.paramLogin.value;
                    } else if (InetServForm.this.paramAutoPassword.equals(paramRowData)) {
                        boolean newValue = Boolean.valueOf(InetServForm.this.paramAutoPassword.value) == false;
                        InetServForm.this.paramAutoPassword.value = String.valueOf(newValue);
                        InetServForm.this.paramPassword.value = newValue ? "" : InetServForm.this.paramPassword.value;
                    } else if (InetServForm.this.paramIPv4FramedAddress.equals(paramRowData) || InetServForm.this.paramIPv6FramedAddress.equals(paramRowData)) {
                        new ResourceInetServAddressDialog(0, paramRowData).open();
                    } else if (InetServForm.this.paramIPv4Net.equals(paramRowData) || InetServForm.this.paramIPv6FramedPrefix.equals(paramRowData) || InetServForm.this.paramIPv6DelegatedPrefix.equals(paramRowData)) {
                        new ResourceInetServAddressDialog(1, paramRowData).open();
                    } else if (InetServForm.this.paramIPv4Range.equals(paramRowData)) {
                        new ResourceInetServAddressDialog(3, paramRowData).open();
                    }
                    InetServForm.this.paramTableModel.fireTableDataChanged();
                }
            }
        };
        FontUIResource font = (FontUIResource)UIManager.get("Table.font");
        font = new FontUIResource(new Font(font.getName(), font.getStyle(), font.getSize() + 2));
        int fontHeight = this.getFontMetrics(font).getHeight() + 3;
        BGUTable paramTable = new BGUTable((TableModel)((Object)this.paramTableModel));
        paramTable.setFont((Font)font);
        paramTable.setRowHeight(fontHeight);
        paramTable.setSelectionMode(0);
        paramTable.addMouseListener((MouseListener)mouseAdapter);
        paramTable.setComponentPopupMenu(this.getPopupMenu());
        paramTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u007f') {
                    InetServForm.this.deleteParamValue();
                }
            }
        });
        paramTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        JTextField textCellEditor = new JTextField();
        TableColumn column = paramTable.getColumnModel().getColumn(1);
        column.setCellEditor(new DefaultCellEditor(textCellEditor));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)paramTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 3, 0, 3), 0, 0));
        panel.add((Component)this.contractObjectPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getCommentStatePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 3, 0, 3), 0, 0));
        return panel;
    }

    private JPanel getCommentStatePanel() {
        this.state.setEditable(false);
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(BGSwingUtilites.wrapBorder((JComponent)BGSwingUtilites.wrapScrollPane((JComponent)this.comment, (int)200, (int)55), (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
        panel.add(BGSwingUtilites.wrapBorder((JComponent)BGSwingUtilites.wrapScrollPane((JComponent)this.state, (int)200, (int)55), (String)"\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435"));
        return panel;
    }

    private JPanel getTopPanel() {
        this.serviceType = new BGUComboBox(false);
        this.serviceType.addActionListener(e -> {
            if (this.onInetServSelected) {
                this.onInetServSelected();
            }
        });
        this.status = new BGUComboBox();
        this.status.setData(Stream.of(InetServStatus.values()).map(InetServStatus::toIdTitle).toList());
        ArrayList<IdTitle> data = new ArrayList<IdTitle>();
        data.add(new IdTitle(0, "\u043d\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e"));
        for (int i = 1; i <= 30; ++i) {
            data.add(new IdTitle(i, String.valueOf(i)));
        }
        this.sessionCountLimit = new BGUComboBox();
        this.sessionCountLimit.setData(data);
        this.period = new BGControlPanelPeriod();
        this.accountId.setEditable(false);
        this.accountId.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapBorder(this.serviceType, (String)"\u0422\u0438\u043f"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder((JComponent)this.accountId, (String)"ID#"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.period, (String)"\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder(this.status, (String)"\u0421\u0442\u0430\u0442\u0443\u0441"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.sessionCountLimitPanel = BGSwingUtilites.wrapBorder(this.sessionCountLimit, (String)"\u041a\u043e\u043b-\u0432\u043e \u0441\u0435\u0441\u0441\u0438\u0439");
        panel.add((Component)this.sessionCountLimitPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void onInetServSelected() {
        Preferences inetServTypeConfig;
        int constDeviceId;
        InetServType inetServType = (InetServType)this.serviceType.getSelectedItem();
        if (inetServType == null) {
            return;
        }
        this.paramTableModel.deleteRows();
        this.inetDevicePanel.setFilter(inetServType.getDeviceTypeIds(), inetServType.getDeviceGroupIds());
        this.additionalParamsPanel.setData(inetServType.getConfig(), this.current.getConfig());
        if (this.current.getId() <= 0) {
            this.current.setSessionCountLimit(inetServType.getSessionCountLimit());
            this.sessionCountLimit.setSelectedItem((Object)inetServType.getSessionCountLimit());
        }
        if (inetServType.isNeedDevice()) {
            this.paramDevice.value = "";
            this.paramTableModel.getRows().add(this.paramDevice);
        }
        if (inetServType.isNeedInterface()) {
            this.paramIface.value = "";
            this.paramTableModel.getRows().add(this.paramIface);
        }
        if (inetServType.isNeedVlan()) {
            this.paramVLAN.value = "";
            this.paramTableModel.getRows().add(this.paramVLAN);
        }
        if (inetServType.isNeedMacAddress()) {
            this.paramMAC.value = "";
            this.paramTableModel.getRows().add(this.paramMAC);
        }
        if (inetServType.isNeedIdentifier()) {
            this.paramIdentifier.value = "";
            this.paramTableModel.getRows().add(this.paramIdentifier);
        }
        if (inetServType.isNeedLogin()) {
            this.paramLogin.value = "";
            this.paramAutoLogin.value = "true";
            this.paramTableModel.getRows().add(this.paramLogin);
            this.paramTableModel.getRows().add(this.paramAutoLogin);
            this.paramPassword.value = "";
            this.paramAutoPassword.value = "true";
            this.paramTableModel.getRows().add(this.paramPassword);
            this.paramTableModel.getRows().add(this.paramAutoPassword);
        }
        if (inetServType.getAddressType().getCode() > -1) {
            switch (inetServType.getAddressType()) {
                case SINGLE_IPV4: 
                case DYNAMIC_OR_SINGLE: 
                case NONE_OR_SINGLE: {
                    this.paramTableModel.getRows().add(this.paramIPv4FramedAddress);
                    break;
                }
                case NET: {
                    this.paramTableModel.getRows().add(this.paramIPv4Net);
                    break;
                }
                case RANGE: 
                case DYNAMIC_OR_RANGE: {
                    this.paramTableModel.getRows().add(this.paramIPv4Range);
                    break;
                }
            }
        } else {
            JSONObject ipData = new JSONObject(inetServType.getData());
            InetServTypeIPMode iPv4Mode = new InetServTypeIPMode(ipData.optJSONObject("ipv4"));
            if (iPv4Mode.isSelectStatic()) {
                this.paramTableModel.getRows().add(this.paramIPv4FramedAddress);
            }
            if (iPv4Mode.getNetMode() == 1) {
                this.paramTableModel.getRows().add(this.paramIPv4Net);
            } else if (iPv4Mode.getNetMode() == 2) {
                this.paramTableModel.getRows().add(this.paramIPv4Range);
            }
            InetServTypeIPMode iPv6Mode = new InetServTypeIPMode(ipData.optJSONObject("ipv6"));
            if (iPv6Mode.isSelectStatic()) {
                this.paramIPv6FramedAddress.reset();
                this.paramIPv6FramedPrefix.reset();
                this.paramIPv6DelegatedPrefix.reset();
                this.paramTableModel.getRows().add(this.paramIPv6FramedAddress);
                this.paramTableModel.getRows().add(this.paramIPv6FramedPrefix);
                this.paramTableModel.getRows().add(this.paramIPv6DelegatedPrefix);
            }
            if (iPv6Mode.getNetMode() == 1) {
                this.paramTableModel.getRows().add(this.paramIPv6Net);
            } else if (iPv6Mode.getNetMode() == 2) {
                this.paramTableModel.getRows().add(this.paramIPv6Range);
            }
        }
        this.contractObjectPanel.setVisible(inetServType.isNeedContractObject());
        this.sessionCountLimitPanel.setVisible(!inetServType.isSessionCountLimitLock());
        if (this.current.getParentId() <= 0) {
            if (this.pane.isAncestorOf((Component)((Object)this.restrictionPanel))) {
                if (!inetServType.isNeedRestriction()) {
                    this.pane.remove((Component)((Object)this.restrictionPanel));
                }
            } else if (inetServType.isNeedRestriction()) {
                this.pane.insertTab("\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f", null, (Component)((Object)this.restrictionPanel), null, 2);
            }
        }
        this.current.setTypeId(inetServType.getId());
        this.current.setEntitySpecId(inetServType.getEntitySpecId());
        try {
            this.entityAttributesForm.refresh();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        if (inetServType.isNeedContractObject()) {
            try {
                ArrayList<ContractObject> contractObjectList = ((ContractObjectService)((ClientContext)this.getContext()).getPort(ContractObjectService.class, 0)).contractObjectList(this.current.getContractId());
                contractObjectList = new ArrayList<ContractObject>(contractObjectList);
                ContractObject nil = new ContractObject();
                nil.setTitle("---");
                contractObjectList.add(0, nil);
                this.contractObject.setData(contractObjectList);
                if (((ClientContext)this.getContext()).getObjectId() > 0) {
                    this.contractObject.setEnabled(false);
                    if (this.current.getContractObjectId() == 0) {
                        this.contractObject.setSelectedItem((Object)((ClientContext)this.getContext()).getObjectId());
                    }
                } else {
                    this.contractObject.setEnabled(true);
                }
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        if (this.current.getId() <= 0 && (constDeviceId = (inetServTypeConfig = new Preferences(inetServType.getConfig(), "\n\r")).getInt("const.device.id", -1)) > 0) {
            this.current.setDeviceId(constDeviceId);
            this.deviceId = constDeviceId;
            if (inetServType.isNeedDevice()) {
                try {
                    InetDevice device = ((InetDeviceService)((ClientContext)this.getContext()).getPort(InetDeviceService.class)).inetDeviceGet(constDeviceId);
                    if (device != null) {
                        this.current.setDeviceTitle(device.getFullTitle());
                        this.paramDevice.value = device.getFullTitle() + " (" + device.getId() + ")";
                    }
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        }
        this.paramTableModel.fireTableStructureChanged();
    }

    public void performActionOpen() {
        byte[] bytes;
        if (this.serviceType.getData().size() == 2 && this.current.getTypeId() == 0) {
            this.serviceType.setSelectedIndex(1);
        } else {
            this.serviceType.setSelectedItem((Object)this.current.getTypeId());
        }
        if (this.parent != null && this.paramTableModel.getRows().stream().noneMatch(p -> p.key.equals("device"))) {
            this.current.setDeviceId(this.parent.getDeviceId());
        }
        this.sessionCountLimit.setSelectedItem((Object)this.current.getSessionCountLimit());
        this.period.setDateString1(TimeUtils.formatDate((Date)this.current.getDateFrom()));
        this.period.setDateString2(TimeUtils.formatDate((Date)this.current.getDateTo()));
        this.comment.setText(this.current.getComment());
        this.paramIPv4FramedAddress.value = this.current.getAddressFrom() != null ? IpAddress.toString((byte[])this.current.getAddressFrom()) : "";
        String tire = this.current.getAddressFrom() != null || this.current.getAddressTo() != null ? " - " : "";
        this.paramIPv4Range.value = (this.current.getAddressFrom() != null ? IpAddress.toString((byte[])this.current.getAddressFrom()) : "") + tire + (this.current.getAddressTo() != null ? IpAddress.toString((byte[])this.current.getAddressTo()) : "");
        if (this.paramIPv6FramedAddress.value != null) {
            bytes = this.current.getFramedIPv6Address();
            this.paramIPv6FramedAddress.value = bytes == null ? "" : IpAddress.toString((byte[])bytes);
            this.paramIPv6FramedAddress.resourceId = this.current.getFramedIPv6AddressResourceId();
        }
        if (this.paramIPv6FramedPrefix.value != null) {
            bytes = this.current.getFramedIPv6Prefix();
            this.paramIPv6FramedPrefix.value = bytes == null ? "" : IpAddress.toString((byte[])bytes);
            this.paramIPv6FramedPrefix.length = this.current.getFramedIPv6PrefixLength();
            this.paramIPv6FramedPrefix.resourceId = this.current.getFramedIPv6PrefixResourceId();
        }
        if (this.paramIPv6DelegatedPrefix.value != null) {
            bytes = this.current.getDelegatedIPv6Prefix();
            this.paramIPv6DelegatedPrefix.value = bytes == null ? "" : IpAddress.toString((byte[])bytes);
            this.paramIPv6DelegatedPrefix.length = this.current.getDelegatedIPv6PrefixLength();
            this.paramIPv6DelegatedPrefix.resourceId = this.current.getDelegatedIPv6PrefixResourceId();
        }
        if (this.current.getMacAddressList() == null) {
            this.paramMAC.value = "";
        } else {
            StringBuilder sb = new StringBuilder();
            for (byte[] macAddress : this.current.getMacAddressList()) {
                sb.append(MACParser.macAddressToString((byte[])macAddress)).append(", ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            }
            this.paramMAC.value = sb.toString();
        }
        this.paramIdentifier.value = Utils.toString((Iterable)this.current.getIdentifierList());
        InetServType inetServ = (InetServType)this.serviceType.getSelectedItem();
        if (inetServ != null && inetServ.getAddressType() == InetAddressType.NET && this.current.getAddressFrom() != null && this.current.getAddressTo() != null) {
            this.paramIPv4Net.value = IpAddress.toString((byte[])this.current.getAddressFrom()) + "/" + String.valueOf(IpNet.getMask((byte[])this.current.getAddressFrom(), (byte[])this.current.getAddressTo()));
        }
        InetDevice device = null;
        try {
            device = ((InetDeviceService)((ClientContext)this.getContext()).getPort(InetDeviceService.class)).inetDeviceGet(this.current.getDeviceId());
        }
        catch (BGException ex) {
            ex.printStackTrace();
        }
        if (device != null) {
            this.current.setDeviceTitle(device.getFullTitle());
            this.paramDevice.value = device.getFullTitle() + " (" + device.getId() + ")";
        } else {
            this.paramDevice.value = Utils.maskNull((String)this.current.getDeviceTitle());
        }
        try {
            if (this.current.getInterfaceId() >= 0) {
                this.interfaceForm.setInterfaceId(this.current.getInterfaceId());
                this.paramIface.value = this.interfaceForm.getInterfaceTitle();
            } else {
                this.interfaceForm.setInterfaceId(-1);
                this.paramIface.value = "";
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.paramVLAN.value = this.current.getVlan() > 0 ? String.valueOf(this.current.getVlan()) : "";
        this.paramLogin.value = Utils.maskNull((String)this.current.getLogin());
        this.paramPassword.value = Utils.maskNull((String)this.current.getPassword());
        this.status.setSelectedItem((Object)this.current.getStatus().toIdTitle());
        this.status.setEnabled(this.current.getParentId() <= 0);
        if (this.current.getParentId() <= 0) {
            if (!this.pane.isAncestorOf((Component)((Object)this.optionPanel))) {
                this.pane.add((Component)((Object)this.optionPanel), "\u041e\u043f\u0446\u0438\u0438");
                if (inetServ.isNeedRestriction()) {
                    this.pane.add((Component)((Object)this.restrictionPanel), "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f");
                }
                this.pane.add((Component)((Object)this.additionalParamsPanel), "\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e");
            }
        } else if (this.pane.isAncestorOf((Component)((Object)this.optionPanel))) {
            this.pane.remove((Component)((Object)this.additionalParamsPanel));
            this.pane.remove((Component)((Object)this.restrictionPanel));
            this.pane.remove((Component)((Object)this.optionPanel));
        }
        this.contractObject.setSelectedItem((Object)this.current.getContractObjectId());
        if (((ClientContext)this.getContext()).getObjectId() > 0) {
            this.contractObject.setEnabled(false);
            if (this.current.getContractObjectId() == 0) {
                this.contractObject.setSelectedItem((Object)((ClientContext)this.getContext()).getObjectId());
            }
        } else {
            this.contractObject.setEnabled(true);
        }
        this.deviceId = this.current.getDeviceId();
        this.interfaceId = this.current.getInterfaceId();
        this.errorPanel.setData();
        this.paramTableModel.fireTableDataChanged();
        super.performActionOpen();
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.pane.setSelectedIndex(0);
            this.entityAttributesForm.reset();
            this.parent = (InetServ)this.panel.model.getSelectedRow();
            if (this.parent != null && this.parent.getId() <= 0) {
                this.parent = null;
            }
            InetServType parentType = null;
            ArrayList<InetServType> servTypeList = this.panel.getInetServService().inetServTypeList();
            if (this.parent != null) {
                int parentTypeId = this.parent.getTypeId();
                for (InetServType type : servTypeList) {
                    if (type.getId() != parentTypeId) continue;
                    parentType = type;
                    break;
                }
            }
            if (parentType != null) {
                ArrayList<InetServType> newServTypeList = new ArrayList<InetServType>();
                for (InetServType type : servTypeList) {
                    if (!type.getParentTypeIds().contains(parentType.getId())) continue;
                    newServTypeList.add(type);
                }
                if (newServTypeList.size() > 0) {
                    servTypeList = newServTypeList;
                } else {
                    parentType = null;
                }
            }
            if (parentType == null) {
                this.parent = null;
                ArrayList<InetServType> newServTypeList = new ArrayList<InetServType>();
                for (InetServType type : servTypeList) {
                    if (type.getParentTypeIds() != null && type.getParentTypeIds().size() != 0) continue;
                    newServTypeList.add(type);
                }
                servTypeList = newServTypeList;
            }
            InetServType emptyType = new InetServType();
            emptyType.setTitle("===== \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f =====");
            emptyType.setAddressType(InetAddressType.OFF);
            emptyType.setData("{}");
            servTypeList.add(0, emptyType);
            this.current = new InetServ();
            this.current.setContractId(((ClientContext)this.getContext()).getContractId());
            this.current.setDateFrom(new Date());
            if (this.parent != null) {
                this.current.setParentId(this.parent.getId());
            }
            this.currentTypeRef.set(this.current);
            this.accountId.setText("");
            this.optionPanel.setInetServId(null);
            this.restrictionPanel.setInetServId(null);
            this.additionalParamsPanel.setData("", "");
            this.onInetServSelected = false;
            this.serviceType.setData(servTypeList);
            this.serviceType.setEnabled(true);
            this.onInetServSelected = true;
            this.state.setText("");
            this.optionPanel.performAction("refresh");
            this.restrictionPanel.performAction("refresh");
            this.performActionOpen();
            this.paramLogin.value = "";
            this.paramAutoLogin.value = "true";
            this.paramAutoPassword.value = "true";
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            this.pane.setSelectedIndex(0);
            this.entityAttributesForm.reset();
            this.current = (InetServ)this.panel.model.getSelectedRow();
            if (this.current == null || this.current.getId() == 0) {
                return;
            }
            this.accountId.setText(String.valueOf(this.current.getId()));
            this.optionPanel.setInetServId(this.current.getId());
            this.restrictionPanel.setInetServId(this.current.getId());
            this.errorPanel.setInetServId(this.current.getId());
            this.current = this.panel.getInetServService().inetServGet(this.current.getId());
            this.currentTypeRef.set(this.current);
            this.parent = this.current.getParentId() > 0 ? this.panel.getInetServService().inetServGet(this.current.getParentId()) : null;
            this.onInetServSelected = false;
            this.serviceType.setData(this.panel.getInetServService().inetServTypeList());
            this.serviceType.setEnabled(false);
            this.onInetServSelected = true;
            this.optionPanel.performAction("refresh");
            this.restrictionPanel.performAction("refresh");
            this.entityAttributesForm.refresh();
            if (this.current.getParentId() > 0) {
                this.state.setText("");
            } else {
                StringBuilder sb = new StringBuilder();
                switch (InetServState.getInetServState((int)this.current.getDeviceState())) {
                    case STATE_ENABLE: {
                        sb.append("\u0412\u043a\u043b\u044e\u0447\u0435\u043d");
                        break;
                    }
                    case STATE_DISABLE: {
                        sb.append("\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d");
                        String accessCodeTitle = this.current.getAccessCodeTitle();
                        if (accessCodeTitle == null) break;
                        sb.append(" [").append(accessCodeTitle).append("]");
                        break;
                    }
                    case STATE_DELETED: {
                        sb.append("\u0423\u0434\u0430\u043b\u0435\u043d");
                        break;
                    }
                    default: {
                        sb.append("null");
                    }
                }
                sb.append(", \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043e\u043f\u0446\u0438\u0438: ");
                if (this.current.getDeviceOptions() != null && this.current.getDeviceOptions().size() > 0) {
                    Map optionMap = Id.newMap(this.optionPanel.getOptionList());
                    for (Integer optionId : this.current.getDeviceOptions()) {
                        InetOption inetOption = (InetOption)optionMap.get(optionId);
                        if (inetOption == null) continue;
                        sb.append(inetOption.getGuiTitle()).append(", ");
                    }
                    sb.setLength(sb.length() - 2);
                } else {
                    sb.append("-");
                }
                this.state.setText(sb.toString());
            }
            this.performActionOpen();
            this.paramAutoLogin.value = "false";
            this.paramAutoPassword.value = "false";
        });
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetServType inetServType = (InetServType)InetServForm.this.serviceType.getSelectedItem();
                if (inetServType == null) {
                    return;
                }
                IdTitle _status = (IdTitle)InetServForm.this.status.getSelectedItem();
                if (_status == null) {
                    return;
                }
                InetServForm.this.entityAttributesForm.performAction("ok");
                InetServForm.this.current.setTypeId(inetServType.getId());
                InetServForm.this.current.setSessionCountLimit(((IdTitle)InetServForm.this.sessionCountLimit.getSelectedItem()).getId());
                InetServForm.this.current.setDateFrom(InetServForm.this.period.getDateFrom());
                InetServForm.this.current.setDateTo(InetServForm.this.period.getDateTo());
                InetServForm.this.current.setAddressFrom(null);
                InetServForm.this.current.setAddressTo(null);
                if (Utils.notBlankString((String)InetServForm.this.paramIPv4FramedAddress.value)) {
                    try {
                        InetServForm.this.current.setAddressFrom(InetAddress.getByName(InetServForm.this.paramIPv4FramedAddress.value).getAddress());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (inetServType.getAddressType() == InetAddressType.NET) {
                    if (Utils.notBlankString((String)InetServForm.this.paramIPv4Net.value)) {
                        try {
                            InetServForm.this.current.setAddressFrom(InetAddress.getByName(InetServForm.this.paramIPv4Net.value.substring(0, InetServForm.this.paramIPv4Net.value.indexOf(47))).getAddress());
                            InetServForm.this.current.setAddressTo(new IpNet(InetServForm.this.current.getAddressFrom(), Utils.parseInt((String)InetServForm.this.paramIPv4Net.value.substring(InetServForm.this.paramIPv4Net.value.indexOf(47) + 1))).getMaxIp());
                        }
                        catch (Exception exception) {}
                    }
                } else if (inetServType.getAddressType() == InetAddressType.RANGE && Utils.notBlankString((String)InetServForm.this.paramIPv4Range.value)) {
                    try {
                        InetServForm.this.current.setAddressFrom(InetAddress.getByName(InetServForm.this.paramIPv4Range.value.substring(0, InetServForm.this.paramIPv4Range.value.indexOf(45) - 1)).getAddress());
                        InetServForm.this.current.setAddressTo(InetAddress.getByName(InetServForm.this.paramIPv4Range.value.substring(InetServForm.this.paramIPv4Range.value.indexOf(45) + 2)).getAddress());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (InetServForm.this.paramIPv6FramedAddress.value != null) {
                    InetServForm.this.current.setFramedIPv6Address(InetServForm.this.paramIPv6FramedAddress.value.isBlank() ? null : InetAddress.getByName(InetServForm.this.paramIPv6FramedAddress.value).getAddress());
                    InetServForm.this.current.setFramedIPv6AddressResourceId(InetServForm.this.paramIPv6FramedAddress.resourceId);
                }
                if (InetServForm.this.paramIPv6FramedPrefix.value != null) {
                    InetServForm.this.current.setFramedIPv6Prefix(InetServForm.this.paramIPv6FramedPrefix.value.isBlank() ? null : InetAddress.getByName(InetServForm.this.paramIPv6FramedPrefix.value).getAddress());
                    InetServForm.this.current.setFramedIPv6PrefixLength(InetServForm.this.paramIPv6FramedPrefix.length);
                    InetServForm.this.current.setFramedIPv6PrefixResourceId(InetServForm.this.paramIPv6FramedPrefix.resourceId);
                }
                if (InetServForm.this.paramIPv6DelegatedPrefix.value != null) {
                    InetServForm.this.current.setDelegatedIPv6Prefix(InetServForm.this.paramIPv6DelegatedPrefix.value.isBlank() ? null : InetAddress.getByName(InetServForm.this.paramIPv6DelegatedPrefix.value).getAddress());
                    InetServForm.this.current.setDelegatedIPv6PrefixLength(InetServForm.this.paramIPv6DelegatedPrefix.length);
                    InetServForm.this.current.setDelegatedIPv6PrefixResourceId(InetServForm.this.paramIPv6DelegatedPrefix.resourceId);
                }
                InetServForm.this.current.setInterfaceId(InetServForm.this.interfaceForm.getInterfaceId());
                if (!Utils.isEmptyString((String)InetServForm.this.paramVLAN.value)) {
                    InetServForm.this.current.setVlan(Utils.parseInt((String)InetServForm.this.paramVLAN.value));
                }
                ArrayList<byte[]> macAddressList = new ArrayList<byte[]>();
                for (String macAddress : InetServForm.this.paramMAC.value.split("\\s*,\\s*")) {
                    if (macAddress.length() <= 0) continue;
                    macAddressList.add(MACParser.parseMacAddress((String)macAddress));
                }
                InetServForm.this.current.setMacAddressList(macAddressList);
                InetServForm.this.current.setIdentifierList(Utils.toList((String)InetServForm.this.paramIdentifier.value));
                InetServForm.this.current.setLogin(InetServForm.this.paramLogin.value);
                InetServForm.this.current.setPassword(InetServForm.this.paramPassword.value);
                InetServForm.this.current.setStatus(InetServStatus.getInetServStatus((int)_status.getId()));
                ContractObject contractObj = (ContractObject)InetServForm.this.contractObject.getSelectedItem();
                InetServForm.this.current.setContractObjectId(contractObj != null ? contractObj.getId() : 0);
                if (InetServForm.this.parent != null) {
                    InetServForm.this.current.setParentId(InetServForm.this.parent.getId());
                    if (InetServForm.this.paramTableModel.getRows().stream().noneMatch(p -> p.key.equals("devive"))) {
                        InetServForm.this.current.setDeviceId(InetServForm.this.parent.getDeviceId());
                    }
                }
                InetServForm.this.current.setConfig(InetServForm.this.additionalParamsPanel.getData());
                InetServForm.this.current.setComment(InetServForm.this.comment.getText());
                boolean autoLogin = Boolean.valueOf(InetServForm.this.paramAutoLogin.value);
                boolean autoPassword = Boolean.valueOf(InetServForm.this.paramAutoPassword.value);
                int id = InetServForm.this.panel.getInetServService().inetServUpdate(InetServForm.this.current, InetServForm.this.optionPanel.getInetServOptionList(), autoLogin, autoPassword, 0L);
                InetServForm.this.restrictionPanel.setInetServId(id);
                InetServForm.this.restrictionPanel.performAction("ok");
                InetServForm.this.performActionClose();
            }
        };
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            this.current = (InetServ)this.panel.model.getSelectedRow();
            if (this.current == null || this.current.getId() == 0) {
                return;
            }
            if (ClientUtils.confirmDelete((Object)"\u0441\u0435\u0440\u0432\u0438\u0441")) {
                this.panel.getInetServService().inetServDelete(this.current.getId(), false);
                this.panel.performAction("refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("address.parent.resource", "\u0420\u0435\u0441\u0443\u0440\u0441\u044b \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0438\u0441\u0430"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                byte[] address = InetServForm.this.panel.getInetServService().inetGetIpFromParent(InetServForm.this.current);
                InetServForm.this.paramIPv4FramedAddress.value = IpAddress.toString((byte[])address);
            }
        };
    }

    void setIface(String value) {
        this.paramIface.value = value;
        this.paramTableModel.fireTableDataChanged();
    }

    private ResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = (ResourceService)((ClientContext)this.getContext()).getPort(ResourceService.class);
        }
        return this.resourceService;
    }

    private void deleteParamValue() {
        ParamRowData paramRowData = (ParamRowData)this.paramTableModel.getSelectedRow();
        if (paramRowData != null) {
            paramRowData.value = "";
            this.paramTableModel.fireTableDataChanged();
        }
    }

    private JPopupMenu getPopupMenu() {
        if (this.tableJPopupMenu == null) {
            this.tableJPopupMenu = new JPopupMenu();
            JMenuItem deleteItem = new JMenuItem("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
            deleteItem.addActionListener(e -> this.deleteParamValue());
            this.tableJPopupMenu.add(deleteItem);
            JMenuItem copyItem = new JMenuItem("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
            copyItem.addActionListener(e -> {
                ParamRowData paramRowData = (ParamRowData)this.paramTableModel.getSelectedRow();
                if (paramRowData != null && paramRowData.value != null) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(paramRowData.value), null);
                }
            });
            this.tableJPopupMenu.add(copyItem);
        }
        return this.tableJPopupMenu;
    }

    public class ParamRowData {
        String key;
        String title;
        String value;
        short length = 0;
        int resourceId = 0;

        public ParamRowData(String key, String title, String value) {
            this.key = key;
            this.title = title;
            this.value = value;
        }

        public String getTitle() {
            return this.title;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public short getLength() {
            return this.length;
        }

        public void setLength(short length) {
            this.length = length;
        }

        public int getResourceId() {
            return this.resourceId;
        }

        public void setResourceId(int resourceId) {
            this.resourceId = resourceId;
        }

        public void reset() {
            this.value = "";
            this.length = 0;
            this.resourceId = 0;
        }
    }

    class ParamTableModel
    extends BGTableModel<ParamRowData> {
        public ParamTableModel() {
            super(ParamTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 100, 300, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", String.class, 100, 200, -1, "value", true, true, new ParamTableCellRenderer());
        }

        public Object getValue(ParamRowData val, int column) throws BGException {
            return super.getValue((Object)val, column);
        }

        protected void setValue(ParamRowData e, int column, Object val) {
            super.setValue((Object)e, column, val);
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            super.setValueAt(value, rowIndex, columnIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            ParamRowData data = (ParamRowData)this.getRows().get(rowIndex);
            return columnIndex == 1 && (InetServForm.this.params.contains(this.getRows().get(rowIndex)) || "login".equals(data.key) && this.getRows().stream().anyMatch(p -> p.key.equals("autoLogin") && !p.value.equals("true")) || "password".equals(data.key) && this.getRows().stream().anyMatch(p -> p.key.equals("autoPassword") && !p.value.equals("true")));
        }
    }

    public class VlanEditorDialog
    extends BGEditorDialog<ParamRowData> {
        private String freeVlanValue;
        private ButtonGroup buttonGroup;
        private JRadioButton free;
        private JRadioButton manual;
        private JTextField freeVlan;
        private JTextField manualVlan;

        public VlanEditorDialog(ParamRowData data, String freeVlanValue) {
            super("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 VLAN", (Object)data);
            this.freeVlanValue = null;
            this.buttonGroup = new ButtonGroup();
            this.free = new JRadioButton("\u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0439 VLAN");
            this.manual = new JRadioButton("\u0440\u0443\u0447\u043d\u043e\u0439 \u0432\u0432\u043e\u0434 VLAN");
            this.freeVlan = new JTextField();
            this.manualVlan = new JTextField();
            this.freeVlanValue = freeVlanValue;
        }

        public void doDialogPanel() {
            this.buttonGroup.add(this.free);
            this.buttonGroup.add(this.manual);
            this.free.setEnabled(this.freeVlanValue != null);
            boolean modeManual = !Utils.isBlankString((String)((ParamRowData)this.data).value) || this.freeVlanValue == null;
            this.manualVlan.setText(modeManual ? ((ParamRowData)this.data).value : "");
            this.manualVlan.setHorizontalAlignment(0);
            (modeManual ? this.manual : this.free).setSelected(true);
            this.freeVlan.setText(this.freeVlanValue == null ? "" : this.freeVlanValue);
            this.freeVlan.setHorizontalAlignment(0);
            this.freeVlan.setEditable(false);
            this.panel.add((Component)new JLabel("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.free, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.freeVlan, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.manual, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.manualVlan, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            if (this.manual.isSelected() && !this.manualVlan.getText().matches("^\\d+$")) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 \u043f\u043e\u043b\u0435 VLAN");
                return false;
            }
            ((ParamRowData)this.data).value = this.free.isSelected() ? this.freeVlan.getText() : this.manualVlan.getText();
            return true;
        }
    }

    public class ResourceInetServAddressDialog
    extends InetServAddressDialog {
        public ResourceInetServAddressDialog(int mode, ParamRowData paramRowData) {
            super("\u0412\u044b\u0431\u043e\u0440 \u0430\u0434\u0440\u0435\u0441\u0430 \u0438\u0437 \u0440\u0435\u0441\u0443\u0440\u0441\u0430", mode, InetServForm.this.deviceId, InetServForm.this.interfaceId, InetServForm.this, paramRowData, (ClientContext)InetServForm.this.getContext());
        }
    }

    class ParamTableCellRenderer
    implements TableCellRenderer {
        ParamTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ParamRowData data = (ParamRowData)((ParamTableModel)((Object)table.getModel())).getRows().get(row);
            if ("autoLogin".equals(data.key) || "autoPassword".equals(data.key)) {
                Component tableCellRenderer = table.getDefaultRenderer(Boolean.class).getTableCellRendererComponent(table, Boolean.valueOf((String)value), isSelected, hasFocus, row, column);
                if (tableCellRenderer instanceof JCheckBox) {
                    JCheckBox component = (JCheckBox)tableCellRenderer;
                    component.setHorizontalAlignment(2);
                    component.setBorder(new EmptyBorder(1, 5, 1, 1));
                    return component;
                }
                if (tableCellRenderer instanceof JLabel) {
                    JLabel component = (JLabel)tableCellRenderer;
                    component.setHorizontalAlignment(2);
                    component.setBorder(new EmptyBorder(1, 5, 1, 1));
                    return component;
                }
            } else if (InetServForm.this.paramPassword.equals(data)) {
                JLabel label = (JLabel)table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                label.setText("*".repeat(15));
                return label;
            }
            return table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

