/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.traffic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.dialup.server.traffic.ServiceLink;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ServiceLinkFinder {
    public static final int BOTH_MODE = 0;
    public static final int ALL_INCOMING_MODE = 1;
    public static final int ALL_OUTGOING_MODE = 2;
    private int mode = 0;
    private Logger logger = LogManager.getLogger();
    private Preferences setup;
    private volatile ServiceLink[] serviceLinks;

    public ServiceLinkFinder(Preferences setup) {
        this.setup = setup;
        this.reload();
    }

    public void reload() {
        this.serviceLinks = this.parseConfig();
    }

    private ServiceLink[] parseConfig() {
        this.logger.info("Parsing services link...");
        boolean inc = false;
        boolean outg = false;
        ParameterMap links = this.setup.sub("netflow.service.link.");
        ArrayList<ServiceLink> serviceLinkList = new ArrayList<ServiceLink>();
        for (Map.Entry entry : links.entrySet()) {
            String pos = (String)entry.getKey();
            String str = links.get(pos).trim();
            this.logger.info("Position: " + pos.trim() + "; string: " + str);
            ServiceLink sl = new ServiceLink();
            sl.setPos(Utils.parseInt((String)pos, (int)-1));
            if (sl.getPos() < 0) {
                this.logger.error("Error pos " + pos + "...");
                continue;
            }
            StringTokenizer st = new StringTokenizer(str);
            if (st.countTokens() < 3) {
                this.logger.error("Count tokens error in " + str);
            }
            String sidStr = st.nextToken().trim();
            sl.setServiceId(Utils.parseInt((String)sidStr, (int)-1));
            if (sl.getServiceId() < 0) {
                this.logger.error("Error service id: " + sidStr);
                continue;
            }
            String directStr = st.nextToken().trim();
            if (directStr.equals("IN")) {
                sl.setDirect(2);
            } else if (directStr.equals("OUT")) {
                sl.setDirect(1);
            } else {
                this.logger.error("Direct mast be IN or OUT");
                continue;
            }
            String addressesStr = st.nextToken();
            String[] range = addressesStr.trim().split("-");
            long ip1 = IPUtils.convertStringIPtoLong((String)range[0], (long)-1L);
            if (ip1 < 0L) {
                this.logger.error("Error start range : " + range[0]);
                continue;
            }
            long ip2 = 0L;
            if (range.length == 1) {
                ip2 = ip1;
            } else {
                ip2 = IPUtils.convertStringIPtoLong((String)range[1], (long)-1L);
                if (ip2 < 0L) {
                    this.logger.error("Error end range : " + range[1]);
                    continue;
                }
            }
            sl.setAddr1(ip1);
            sl.setAddr2(ip2);
            if (st.hasMoreTokens()) {
                String portStr = st.nextToken().trim();
                range = portStr.split("-");
                int port1 = Utils.parseInt((String)range[0], (int)-1);
                if (port1 < 0) {
                    this.logger.error("Error start port range " + range[0]);
                    continue;
                }
                int port2 = 0;
                if (range.length == 1) {
                    port2 = port1;
                } else {
                    port2 = Utils.parseInt((String)range[1], (int)-1);
                    if (port2 < 0) {
                        this.logger.error("Error stop port range " + range[1]);
                        continue;
                    }
                }
                sl.setPort1(port1);
                sl.setPort2(port2);
            }
            serviceLinkList.add(sl);
            inc = inc || sl.getDirect() == 2;
            outg = outg || sl.getDirect() == 1;
        }
        Collections.sort(serviceLinkList);
        this.logger.info("Loaded " + serviceLinkList.size() + " links..");
        if (inc && outg) {
            this.mode = 0;
            this.logger.info("Processing mode => BOTH");
        } else if (inc) {
            this.mode = 1;
            this.logger.info("Processing mode => ALL_INCOMING_MODE");
        } else if (outg) {
            this.mode = 2;
            this.logger.info("Processing mode => ALL_OUTGOING_MODE");
        }
        for (ServiceLink link : serviceLinkList) {
            this.logger.info(link.toString());
        }
        return serviceLinkList.toArray(new ServiceLink[serviceLinkList.size()]);
    }

    public int getServiceLinkMode() {
        return this.mode;
    }

    public int getServiceId(int direct, long addr, int port) {
        for (ServiceLink sl : this.serviceLinks) {
            if (!sl.isCoinside(direct, addr, port)) continue;
            return sl.getServiceId();
        }
        return -1;
    }

    @Deprecated
    public int getServiceID(int direct, long addr, int port) {
        return this.getServiceId(direct, addr, port);
    }

    public String getServiceIdList() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (ServiceLink link : this.serviceLinks) {
            result.add(link.getServiceId());
        }
        StringBuilder idStr = new StringBuilder(200);
        idStr.append("-1");
        for (Integer sid : result) {
            idStr.append(",");
            idStr.append(sid);
        }
        return idStr.toString();
    }
}

