/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.cerbercrypt.client.CardPacketProcessor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.CardPacketSyncer;
import ru.bitel.bgbilling.modules.cerbercrypt.client.UserCardFilterPanel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.StatusEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.CardPacketService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.PacketService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.UserCardService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class UserCardPacketEditor
extends BGUPanel {
    private CardPacket cardPacketId;
    private BGUTable table;
    private CardPacketTableModel model;
    private CardLayout mainCard = new CardLayout();
    private JPanel mainPanel = new JPanel(new GridBagLayout());
    private CardPacketProcessor packetOpener = new CardPacketProcessor(1);
    private CardPacketProcessor packetCloser = new CardPacketProcessor(2);
    private CardPacketSyncer packetSyncerPanel = new CardPacketSyncer();
    private CardLayout bottomCard = new CardLayout();
    private JPanel bottomPanel = new JPanel();
    private BGUComboBox<UserCard> cardCB = new BGUComboBox();
    private BGUComboBox<Packet> packetCB = new BGUComboBox();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private JTextArea commentTA = new JTextArea();
    private BGUTable statusTable;
    private BGTableModel<StatusEvent> statusModel;
    private BGUComboBox<IdTitle> statusCB = new BGUComboBox();
    private BGControlPanelDateNoB statusDate = new BGControlPanelDateNoB();
    private Directory<UserInfo> userDirectory;
    private UserCardFilterPanel filterPanel = new UserCardFilterPanel(this);
    private boolean init = false;

    protected String getTableHeader() {
        this.model = new CardPacketTableModel(CardPacketTableModel.class.getName());
        this.table = new BGUTable((TableModel)((Object)this.model));
        return "user_card_packet";
    }

    public UserCardPacketEditor() {
        this.getTableHeader();
        this.statusModel = new BGTableModel<StatusEvent>("StatusEvent"){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u0414\u0430\u0442\u0430", String.class, 120, 120, 120, "date", false);
                this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 50, 50, -1, "stringStatus", false);
                this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", String.class, -1, -1, -1, "userId", false);
            }

            public Object getValue(StatusEvent val, int column) throws BGException {
                if (column == 1) {
                    return TimeUtils.formatDate((Calendar)val.getTime());
                }
                if (column == 3) {
                    UserInfo user = (UserInfo)UserCardPacketEditor.this.userDirectory.get(val.getUserId());
                    return user != null ? user.getName() : "??? id=" + val.getUserId();
                }
                return super.getValue((Object)val, column);
            }
        };
        this.statusTable = new BGUTable(this.statusModel);
        this.packetOpener.setCardPacketEditor(this);
        this.packetCloser.setCardPacketEditor(this);
        this.packetSyncerPanel.setCardPacketEditor(this);
        this.build();
        this.showBottomStatusPanel();
    }

    protected void jbInit() throws Exception {
        this.userDirectory = ((ClientContext)this.getContext()).getDirectory(UserInfo.class, 0);
        this.setLayout(this.mainCard);
        this.add(this.mainPanel, "editor");
        this.add((Component)((Object)this.packetOpener), "opener");
        this.add((Component)((Object)this.packetCloser), "closer");
        this.bottomPanel.setLayout(this.bottomCard);
        this.mainPanel.add((Component)((Object)this.filterPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.bottomPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel leftEditorPanel = new JPanel();
        leftEditorPanel.setLayout(new GridBagLayout());
        leftEditorPanel.setBorder((Border)new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        leftEditorPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        leftEditorPanel.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        leftEditorPanel.add((Component)new JLabel("\u041a\u0430\u0440\u0442\u0430"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        leftEditorPanel.add((Component)this.cardCB, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        leftEditorPanel.add((Component)new JLabel("\u041f\u0430\u043a\u0435\u0442"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        leftEditorPanel.add((Component)this.packetCB, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        leftEditorPanel.add(Box.createVerticalStrut(1), new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        JPanel rightEditorPanel = new JPanel();
        rightEditorPanel.setLayout(new GridBagLayout());
        rightEditorPanel.setBorder((Border)new BGTitleBorder("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
        rightEditorPanel.add((Component)new JScrollPane(this.commentTA), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel editorPanel = new JPanel(new GridBagLayout());
        editorPanel.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        editorPanel.add((Component)leftEditorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        editorPanel.add((Component)rightEditorPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
        editorPanel.add((Component)okCancelPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals("ok")) {
                    UserCardPacketEditor.this.performAction("stopEdit");
                } else {
                    UserCardPacketEditor.this.showBottomStatusPanel();
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserCardPacketEditor.this.performAction("edit");
                } else if (e.getClickCount() == 1) {
                    UserCardPacketEditor.this.performAction("updateStatusTable");
                }
            }
        });
        editorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                UserCardPacketEditor.this.performAction("refresh");
            }
        });
        this.addEditorPanels(editorPanel);
    }

    protected void addEditorPanels(JPanel editorPanel) {
        JButton okButton = new JButton("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserCardPacketEditor.this.performAction("updateStatus");
            }
        });
        JPanel topStatusPanel = new JPanel(new GridBagLayout());
        topStatusPanel.add((Component)new JLabel("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        topStatusPanel.add((Component)this.statusCB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        topStatusPanel.add((Component)new JLabel(" \u0441 \u0434\u0430\u0442\u044b: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        topStatusPanel.add((Component)this.statusDate, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        topStatusPanel.add((Component)okButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        JPanel bottomStatusPanel = new JPanel(new GridBagLayout());
        bottomStatusPanel.add((Component)new JScrollPane((Component)this.statusTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        JPanel statusPanel = new JPanel(new GridBagLayout());
        statusPanel.setBorder((Border)new BGTitleBorder("\u0421\u0442\u0430\u0442\u0443\u0441"));
        statusPanel.add((Component)topStatusPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        statusPanel.add((Component)bottomStatusPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.bottomPanel.add((Component)editorPanel, "editor");
        this.bottomPanel.setMinimumSize(new Dimension(100, 200));
        this.bottomPanel.setPreferredSize(new Dimension(100, 200));
        this.bottomPanel.add((Component)statusPanel, "status");
        this.bottomPanel.add((Component)((Object)this.packetSyncerPanel), "syncer");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (!this.init) {
                this.init = true;
                List list = ((PacketService)((ClientContext)this.getContext()).getPort(PacketService.class)).packetList(Boolean.valueOf(false));
                this.packetCB.setData(list);
                this.statusCB.addItem((Object)new IdTitle(1, "\u0430\u043a\u0442\u0438\u0432\u0435\u043d"));
                this.statusCB.addItem((Object)new IdTitle(2, "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
                this.statusCB.addItem((Object)new IdTitle(3, "\u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d"));
            }
            this.filterPanel.refresh();
            UserCard cardItem = (UserCard)this.filterPanel.getCardFilterCB().getSelectedItem();
            List list = ((CardPacketService)((ClientContext)this.getContext()).getPort(CardPacketService.class)).cardPacketTable(((ClientContext)this.getContext()).getObjectId(), cardItem != null ? cardItem.getId() : -1, this.filterPanel.getDateFilter().getDate(), false, ((ClientContext)this.getContext()).getContractId());
            this.model.setData(list);
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.cardPacketId = null;
            this.performAction("startEdit");
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            this.cardPacketId = (CardPacket)this.model.getSelectedRow();
            if (this.cardPacketId != null) {
                this.performAction("startEdit");
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            this.cardPacketId = (CardPacket)this.model.getSelectedRow();
            if (this.cardPacketId != null && ClientUtils.confirmDelete((Object)"\u043f\u0430\u043a\u0435\u0442")) {
                block3: {
                    try {
                        ((CardPacketService)((ClientContext)this.getContext()).getPort(CardPacketService.class)).deleteCardPacket(((ClientContext)this.getContext()).getContractId(), this.cardPacketId.getId(), true);
                    }
                    catch (BGMessageException ex) {
                        String message = ex.getMessage();
                        if (!ClientUtils.confirm((String)(message + "\n\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?"), (String)"\u041e\u0448\u0438\u0431\u043a\u0430")) break block3;
                        ((CardPacketService)((ClientContext)this.getContext()).getPort(CardPacketService.class)).deleteCardPacket(((ClientContext)this.getContext()).getContractId(), this.cardPacketId.getId(), false);
                    }
                }
                this.performAction("refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("updateStatusTable", "updateStatusTable"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                CardPacket id = (CardPacket)UserCardPacketEditor.this.model.getSelectedRow();
                if (id != null) {
                    List list = ((CardPacketService)((ClientContext)UserCardPacketEditor.this.getContext()).getPort(CardPacketService.class)).cardPacketStatusTable(id.getId());
                    UserCardPacketEditor.this.statusModel.setData(list);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("startEdit", "startEdit"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List poolList = null;
                poolList = ((ClientContext)UserCardPacketEditor.this.getContext()).getObjectId() > 0 ? ((UserCardService)((ClientContext)UserCardPacketEditor.this.getContext()).getPort(UserCardService.class)).getCardListByObject(((ClientContext)UserCardPacketEditor.this.getContext()).getObjectId()) : ((UserCardService)((ClientContext)UserCardPacketEditor.this.getContext()).getPort(UserCardService.class)).getUserCardList(((ClientContext)UserCardPacketEditor.this.getContext()).getContractId(), false);
                UserCardPacketEditor.this.cardCB.setData(poolList);
                if (UserCardPacketEditor.this.cardPacketId != null) {
                    CardPacket cardPacket = ((CardPacketService)((ClientContext)UserCardPacketEditor.this.getContext()).getPort(CardPacketService.class)).getCardPacket(UserCardPacketEditor.this.cardPacketId.getId());
                    UserCardPacketEditor.this.periodPanel.setDateFrom(cardPacket.getDateFrom());
                    UserCardPacketEditor.this.periodPanel.setDateTo(cardPacket.getDateTo());
                    UserCardPacketEditor.this.commentTA.setText(cardPacket.getComment());
                    UserCardPacketEditor.this.cardCB.setSelectedItem((Object)cardPacket.getUsercardId());
                    UserCardPacketEditor.this.packetCB.setSelectedItem((Object)cardPacket.getPacketId());
                } else {
                    UserCardPacketEditor.this.periodPanel.setDateString1("");
                    UserCardPacketEditor.this.periodPanel.setDateString2("");
                    UserCardPacketEditor.this.commentTA.setText("");
                    UserCard cardFilterItem = (UserCard)UserCardPacketEditor.this.filterPanel.getCardFilterCB().getSelectedItem();
                    if (cardFilterItem != null) {
                        UserCardPacketEditor.this.cardCB.setSelectedItem((Object)cardFilterItem);
                    }
                }
                UserCardPacketEditor.this.bottomCard.show(UserCardPacketEditor.this.bottomPanel, "editor");
            }
        };
        new AbstractBGUPanel.DefaultAction("updateStatus", "updateStatus"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                CardPacket id = (CardPacket)UserCardPacketEditor.this.model.getSelectedRow();
                if (id != null) {
                    IdTitle statusItem = (IdTitle)UserCardPacketEditor.this.statusCB.getSelectedItem();
                    Date date = UserCardPacketEditor.this.statusDate.getDate();
                    if (date == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
                        return;
                    }
                    if (ClientUtils.confirm((String)"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u0441\u043c\u0435\u043d\u0443 \u0441\u0442\u0430\u0442\u0443\u0441\u0430?", (String)"\u0421\u043c\u0435\u043d\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430")) {
                        ((CardPacketService)((ClientContext)UserCardPacketEditor.this.getContext()).getPort(CardPacketService.class)).changeStatus(id.getId(), statusItem.getId(), date);
                        UserCardPacketEditor.this.performAction("updateStatusTable");
                    }
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("stopEdit", "stopEdit"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                block5: {
                    UserCard cardItem = (UserCard)UserCardPacketEditor.this.cardCB.getSelectedItem();
                    if (cardItem == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0440\u0442\u0443!");
                        return;
                    }
                    Packet packetItem = (Packet)UserCardPacketEditor.this.packetCB.getSelectedItem();
                    if (packetItem == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442!");
                        return;
                    }
                    if (UserCardPacketEditor.this.periodPanel.getDateFrom() == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u043d\u0430\u0447\u0430\u043b\u0430!");
                        return;
                    }
                    CardPacket cardPacket = new CardPacket();
                    cardPacket.setId(UserCardPacketEditor.this.cardPacketId != null ? UserCardPacketEditor.this.cardPacketId.getId() : 0);
                    cardPacket.setContractId(((ClientContext)UserCardPacketEditor.this.getContext()).getContractId());
                    cardPacket.setUsercardId(cardItem.getId());
                    cardPacket.setDateFrom(UserCardPacketEditor.this.periodPanel.getDateFrom());
                    cardPacket.setDateTo(UserCardPacketEditor.this.periodPanel.getDateTo());
                    cardPacket.setPacketId(packetItem.getId());
                    cardPacket.setComment(UserCardPacketEditor.this.commentTA.getText());
                    try {
                        ((CardPacketService)((ClientContext)UserCardPacketEditor.this.getContext()).getPort(CardPacketService.class)).updateCardPacket(cardPacket, true, 0);
                    }
                    catch (BGMessageException ex) {
                        String message = ex.getMessage();
                        if (!ClientUtils.confirm((String)(message + "\n\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?"), (String)"\u041e\u0448\u0438\u0431\u043a\u0430")) break block5;
                        ((CardPacketService)((ClientContext)UserCardPacketEditor.this.getContext()).getPort(CardPacketService.class)).updateCardPacket(cardPacket, false, 0);
                    }
                }
                UserCardPacketEditor.this.performAction("refresh");
                UserCardPacketEditor.this.showBottomStatusPanel();
            }
        };
    }

    public void openPackets() {
        this.mainCard.show((Container)((Object)this), "opener");
        this.packetOpener.performAction("refresh");
    }

    public void closePackets() {
        this.mainCard.show((Container)((Object)this), "closer");
        this.packetCloser.performAction("refresh");
    }

    public void syncPackets() {
        this.bottomCard.show(this.bottomPanel, "syncer");
        this.packetSyncerPanel.performAction("refresh");
    }

    public void showCardPackets() {
        this.mainCard.show((Container)((Object)this), "editor");
        this.performAction("refresh");
    }

    public void showBottomStatusPanel() {
        this.bottomCard.show(this.bottomPanel, "status");
    }

    class CardPacketTableModel
    extends BGTableModel<CardPacket> {
        public CardPacketTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u0430\u0440\u0442\u0430", 250, 250, 250, "card", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0430\u043a\u0435\u0442", 150, 150, -1, "packetTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 150, 150, 150, "stringStatus", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043c. \u0441\u0442\u0430\u0442.", 150, 150, 150, "change_date", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(CardPacket cardPacket, int column) throws BGException {
            String i;
            switch (i = this.getIdentifier(column)) {
                case "period": {
                    return TimeUtils.formatPeriod((Date)cardPacket.getDateFrom(), (Date)cardPacket.getDateTo());
                }
                case "card": {
                    return cardPacket.getCardNumber() > 0L ? new DecimalFormat("000000").format(cardPacket.getCardNumber()) : "???";
                }
                case "change_date": {
                    return TimeUtils.formatDate((Calendar)cardPacket.getChange_date());
                }
            }
            return super.getValue((Object)cardPacket, column);
        }
    }
}

