/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserDevice;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class UserDeviceManager
extends AbstractIdDao<UserDevice> {
    public UserDeviceManager(Connection con, int mid) {
        super(con, mid, "cerbercrypt_user_devices", null);
    }

    public List<UserDevice> getListAll() throws BGException {
        return this.list(null, null, new Object[0]);
    }

    protected UserDevice getFromRS(ResultSet rs) throws SQLException, BGException {
        UserDevice userDevice = new UserDevice();
        userDevice.setId(rs.getInt("id"));
        userDevice.setTitle(rs.getString("title"));
        userDevice.setComment(rs.getString("comment"));
        userDevice.setConfig(rs.getString("config"));
        return userDevice;
    }

    protected void updateImpl(UserDevice b) throws BGException, SQLException {
        String query = null;
        PreparedStatement ps = null;
        if (b.getId() <= 0) {
            query = "INSERT INTO " + this.tableName + " (title, comment, config) VALUES (?, ?, ?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE " + this.tableName + " SET title=?, comment=?, config=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(4, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.setString(2, b.getComment());
        ps.setString(3, b.getConfig());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }
}

