/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import jakarta.xml.ws.BindingProvider;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.Download;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.DownloadSoap;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.MarriageTag;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.Messaging;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.MessagingSoap;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.ParentalControl;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.ParentalControlSoap;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.Recovery;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.RecoverySoap;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.SmartcardMarriage;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.SmartcardMarriageSoap;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.TextMode;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.Tuning;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.TuningSoap;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.entitlement.Entitlement;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.entitlement.EntitlementSoap;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.sector.ArrayOfString;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.sector.Sector;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.sector.SectorSoap;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.secureclient.ArrayOfProperty;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.secureclient.ArrayOfSecureClientProfile;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.secureclient.CommandResultData;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.secureclient.Property;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.secureclient.Query;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.secureclient.QuerySoap;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.secureclient.SecureClientInfo;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.secureclient.SecureClientProfile;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.secureclient.SecureClientProfileCommandResult;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.secureclient.Smartcard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.secureclient.SmartcardSoap;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.smarty.Smarty;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.smarty.SmartyAuthOut;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.smarty.Smarty_Service;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class Pisys2ServiceActivator
extends DigitalTVServiceActivator {
    private static final Logger log = LogManager.getLogger();
    private static final int RESULT_OK = 1028;
    private Map<Integer, Con> connections = new HashMap<Integer, Con>();

    public Pisys2ServiceActivator(ParameterMap moduleSetup, Connection con, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, con, conSlave, mid, time);
    }

    private static void setupws(Object endpoint, String urlparamname, ParameterMap connectionSetup, String sessionKey) throws BGException {
        Map requestContext = ((BindingProvider)endpoint).getRequestContext();
        if (sessionKey != null) {
            requestContext.put("jakarta.xml.ws.http.request.headers", Collections.singletonMap("Cookie", Collections.singletonList("sessionid=" + sessionKey)));
        }
        requestContext.put("com.sun.xml.ws.connect.timeout", 10000);
        log.info("succesfull setup webservice " + urlparamname + ": " + endpoint);
    }

    private Con getConnection(Integer serverId, UserCard userCard) throws BGException {
        Con con = this.connections.get(serverId);
        if (con == null) {
            ParameterMap moduleSetup = this.getModuleSetup(userCard);
            ParameterMap connectionSetup = moduleSetup.sub("server." + serverId + ".");
            Object url = connectionSetup.get("url", null);
            if (Utils.isBlankString((String)url)) {
                String host = connectionSetup.get("host", null);
                int port = connectionSetup.getInt("port", -1);
                if (Utils.isEmptyString((String)host) || port <= 0) {
                    throw new BGException("url for server " + serverId + " undefined!");
                }
                url = "http://" + host + ":" + port + "/pisys";
            }
            try {
                con = new Con();
                con.operatorTag = connectionSetup.get("operatorTag", "");
                con.portalUsername = connectionSetup.get("portal.username", null);
                con.portalPassword = connectionSetup.get("portal.password", null);
                con.nationality = connectionSetup.get("nationality", "RUS");
                con.regionTag = connectionSetup.get("regionTag", "MO");
                con.refreshSectorCreate = connectionSetup.get("refreshSectorCreate", "?");
                con.locationTag = connectionSetup.get("locationTag", "?");
                try {
                    con.textMode = TextMode.valueOf(connectionSetup.get("textMode", "ANSI"));
                }
                catch (Exception e) {
                    con.textMode = TextMode.ANSI;
                }
                con.emergency_networkId = connectionSetup.getInt("emergency.networkId", 0);
                con.emergency_transportId = connectionSetup.getInt("emergency.transportId", 0);
                con.emergency_serviceId = connectionSetup.getInt("emergency.serviceId", 0);
                if (Utils.notBlankString((String)con.portalUsername) && Utils.notBlankString((String)con.portalPassword)) {
                    con.portal = new Smarty_Service((String)url).getSmarty();
                    Pisys2ServiceActivator.setupws(con.portal, "portal", connectionSetup, null);
                    SmartyAuthOut token = con.portal.smartyAuth(con.portalUsername, con.portalPassword);
                    String sessionKey = token.getSessionKey();
                    if (Utils.isBlankString((String)sessionKey)) {
                        throw new BGException("portal authorization error (" + token.getError() + ")");
                    }
                    log.info("succesfull portal authorization, username: " + con.portalUsername);
                    con.sessionKey = sessionKey;
                }
                con.sector = new Sector((String)url).getSectorSoap();
                Pisys2ServiceActivator.setupws(con.sector, "sector", connectionSetup, con.sessionKey);
                con.entitlement = new Entitlement((String)url).getEntitlementSoap();
                Pisys2ServiceActivator.setupws(con.entitlement, "entitlement", connectionSetup, con.sessionKey);
                con.messaging = new Messaging((String)url).getMessagingSoap();
                Pisys2ServiceActivator.setupws(con.messaging, "messaging", connectionSetup, con.sessionKey);
                con.parentalControl = new ParentalControl((String)url).getParentalControlSoap();
                Pisys2ServiceActivator.setupws(con.parentalControl, "parentalControl", connectionSetup, con.sessionKey);
                con.download = new Download((String)url).getDownloadSoap();
                Pisys2ServiceActivator.setupws(con.download, "download", connectionSetup, con.sessionKey);
                con.marriage = new SmartcardMarriage((String)url).getSmartcardMarriageSoap();
                Pisys2ServiceActivator.setupws(con.marriage, "marriage", connectionSetup, con.sessionKey);
                con.tuning = new Tuning((String)url).getTuningSoap();
                Pisys2ServiceActivator.setupws(con.tuning, "tuning", connectionSetup, con.sessionKey);
                con.recovery = new Recovery((String)url).getRecoverySoap();
                Pisys2ServiceActivator.setupws(con.recovery, "recovery", connectionSetup, con.sessionKey);
                con.smartcard = new Smartcard((String)url).getSmartcardSoap();
                Pisys2ServiceActivator.setupws(con.smartcard, "smartcard", connectionSetup, con.sessionKey);
                con.query = new Query((String)url).getQuerySoap();
                Pisys2ServiceActivator.setupws(con.query, "query", connectionSetup, con.sessionKey);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
            this.connections.put(serverId, con);
        }
        return con;
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.clientdevice.CommandResultData crd, String loginfo) {
        return 1028 == crd.getCode() ? new DigitalTVServiceActivator.ServiceActivationResult(true, "OK", loginfo, null) : new DigitalTVServiceActivator.ServiceActivationResult(false, crd.getCode() + ": " + crd.getMessage(), loginfo, null);
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(CommandResultData crd, String loginfo) {
        return 1028 == crd.getCode() ? new DigitalTVServiceActivator.ServiceActivationResult(true, "OK", loginfo, null) : new DigitalTVServiceActivator.ServiceActivationResult(false, crd.getCode() + ": " + crd.getMessage(), loginfo, null);
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.entitlement.CommandResultData crd, String loginfo) {
        return 1028 == crd.getCode() ? new DigitalTVServiceActivator.ServiceActivationResult(true, "OK", loginfo, null) : new DigitalTVServiceActivator.ServiceActivationResult(false, crd.getCode() + ": " + crd.getMessage(), loginfo, null);
    }

    private static DigitalTVServiceActivator.ServiceActivationResult checkAnswer(ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.sector.CommandResultData crd, String loginfo) {
        return 1028 == crd.getCode() ? new DigitalTVServiceActivator.ServiceActivationResult(true, "OK", loginfo, null) : new DigitalTVServiceActivator.ServiceActivationResult(false, crd.getCode() + ": " + crd.getMessage(), loginfo, null);
    }

    private static void sendErrorAlarm(Con con, String exMessage, String methodName) {
        String key = "pisys.service.activator.error";
        AlarmSender.sendAlarm((String)key, (long)300000L, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!", (String)("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c Pisys: \"" + exMessage + "\"!" + (String)(con != null ? "\n\u041a\u043e\u0434 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: " + con.operatorTag + "\n\u0412\u0435\u0431-\u0441\u0435\u0440\u0432\u0438\u0441: " + con.sector : "\n\u041d\u0435\u0442 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f (con == null)!") + "\n\u0424\u0443\u043d\u043a\u0446\u0438\u044f: " + methodName));
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult activateImpl(long cardNumber, UserCard card, List<CardPacket> cardPacketList) throws BGException {
        if (card == null) {
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041a\u0430\u0440\u0442\u0430 " + cardNumber + " \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443, \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0435\u0442, \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043d\u0435\u0447\u0435\u0433\u043e", null);
        }
        Object loginfo = "Info:\n";
        String line = "Activate card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size();
        log.info(line);
        loginfo = (String)loginfo + line + "\n";
        Con con = null;
        try {
            loginfo = (String)loginfo + "Connection...\n";
            con = this.getConnection(0, card);
            List<DigitalTVServiceActivator.CardPacketCodePair> cpcl = this.getCardPacketCodePairList(cardPacketList, false, true);
            ArrayOfString productTagList = new ArrayOfString();
            for (DigitalTVServiceActivator.CardPacketCodePair pairCardPacketPacketCode : cpcl) {
                productTagList.getString().add(pairCardPacketPacketCode.packetCode);
            }
            loginfo = (String)loginfo + String.format("call sector.overwriteSector(operatorTag=%s, serialNumber=%d, nationality=%s, regionTag=%s, productTagList=%s, refreshSectorCreate=%s, locationTag=%s)\n", con.operatorTag, card.getNumber(), con.nationality, con.regionTag, productTagList.getString(), con.refreshSectorCreate, con.locationTag);
            return Pisys2ServiceActivator.checkAnswer(con.sector.overwriteSector(con.operatorTag, Pisys2ServiceActivator._cn(card.getNumber()), con.nationality, con.regionTag, productTagList, con.refreshSectorCreate, con.locationTag), (String)loginfo);
        }
        catch (Exception ex) {
            log.error("Exception in activateImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult deactivateImpl(long cardNumber) throws BGException {
        Object loginfo = "Info:\n";
        String line = "Deactivate card: " + cardNumber;
        log.info(line);
        loginfo = (String)loginfo + line + "\n";
        Con con = null;
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            loginfo = (String)loginfo + "Connection...\n";
            con = this.getConnection(0, userCard);
            loginfo = (String)loginfo + String.format("call entitlement.deleteAllEntitlements(operatorTag=%s, serialNumber=%d)\n", con.operatorTag, cardNumber);
            con.entitlement.deleteAllEntitlements(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber));
            loginfo = (String)loginfo + String.format("call sector.deleteSector(operatorTag=%s, serialNumber=%d)\n", con.operatorTag, cardNumber);
            return Pisys2ServiceActivator.checkAnswer(con.sector.deleteSector(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber)), (String)loginfo);
        }
        catch (Exception ex) {
            log.error("Exception in deactivateImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        Object loginfo = "Info:\n";
        String line = "Modify card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size();
        log.info(line);
        loginfo = (String)loginfo + line + "\n";
        Con con = null;
        try {
            loginfo = (String)loginfo + "Connection...\n";
            con = this.getConnection(0, card);
            List<DigitalTVServiceActivator.CardPacketCodePair> cpcl = this.getCardPacketCodePairList(cardPacketList, false, true);
            ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.entitlement.ArrayOfString productTagList = new ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.pisys2.ws.entitlement.ArrayOfString();
            for (DigitalTVServiceActivator.CardPacketCodePair pairCardPacketPacketCode : cpcl) {
                productTagList.getString().add(pairCardPacketPacketCode.packetCode);
            }
            loginfo = (String)loginfo + String.format("call entitlement.overwriteEntitlements(operatorTag=%s, serialNumber=%d, productTagList=%s)\n", con.operatorTag, card.getNumber(), productTagList.getString());
            return Pisys2ServiceActivator.checkAnswer(con.entitlement.overwriteEntitlements(con.operatorTag, Pisys2ServiceActivator._cn(card.getNumber()), productTagList), (String)loginfo);
        }
        catch (Exception ex) {
            log.error("Exception in modifyImpl", (Throwable)ex);
            Pisys2ServiceActivator.sendErrorAlarm(con, ex.getMessage(), "modifyImpl");
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardNumber) throws BGException {
        Object loginfo = "Info:\n";
        String line = "Closing card " + cardNumber;
        log.info(line);
        loginfo = (String)loginfo + line + "\n";
        Con con = null;
        try {
            loginfo = (String)loginfo + "Connection...\n";
            con = this.getConnection(0, null);
            loginfo = (String)loginfo + String.format("call entitlement.deleteAllEntitlements(operatorTag=%s, serialNumber=%d)\n", con.operatorTag, cardNumber);
            return Pisys2ServiceActivator.checkAnswer(con.entitlement.deleteAllEntitlements(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber)), (String)loginfo);
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl", (Throwable)ex);
            Pisys2ServiceActivator.sendErrorAlarm(con, ex.getMessage(), "cancelImpl");
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        Object loginfo = "Info:\n";
        String line = "Closing card: " + card.getNumber() + ", cardPackets count: " + cardPacketList.size();
        log.info(line);
        loginfo = (String)loginfo + line + "\n";
        Con con = null;
        try {
            loginfo = (String)loginfo + "Connection...\n";
            con = this.getConnection(0, card);
            loginfo = (String)loginfo + String.format("call entitlement.deleteAllEntitlements(operatorTag=%s, serialNumber=%d)\n", con.operatorTag, card.getNumber());
            return Pisys2ServiceActivator.checkAnswer(con.entitlement.deleteAllEntitlements(con.operatorTag, Pisys2ServiceActivator._cn(card.getNumber())), (String)loginfo);
        }
        catch (Exception ex) {
            log.error("Exception in cancelImpl [" + (con != null ? con.operatorTag : "") + " : " + card.getNumber(), (Throwable)ex);
            Pisys2ServiceActivator.sendErrorAlarm(con, ex.getMessage(), "cancelImpl");
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult sendMessagesImpl(List<Long> cardNumbers, String title, String message, boolean ismail) {
        Object loginfo = "Info:\n";
        try {
            if (cardNumbers == null) {
                loginfo = (String)loginfo + "Connection...\n";
                Con con = this.getConnection(0, null);
                if (ismail) {
                    log.info("send mail message global");
                    loginfo = (String)loginfo + String.format("call messaging.sendMailGlobal(operatorTag=%s, messageBody=%s, textMode=%s, ...)\n", con.operatorTag, message, con.textMode.value());
                    return Pisys2ServiceActivator.checkAnswer(con.messaging.sendMailGlobal(con.operatorTag, message, con.textMode, "", "", "", "", ""), (String)loginfo);
                }
                log.info("send osd message global");
                loginfo = (String)loginfo + String.format("call messaging.sendMessageGlobal(operatorTag=%s, messageBody=%s, textMode=%s, ...)\n", con.operatorTag, message, con.textMode.value());
                return Pisys2ServiceActivator.checkAnswer(con.messaging.sendMessageGlobal(con.operatorTag, message, con.textMode, "", "", "", "", ""), (String)loginfo);
            }
            for (Long cardNumber : cardNumbers) {
                UserCard userCard = this.userCardManager.getUserCard((long)cardNumber, new Date());
                loginfo = (String)loginfo + "Connection...\n";
                Con con = this.getConnection(0, userCard);
                DigitalTVServiceActivator.ServiceActivationResult result = null;
                if (ismail) {
                    log.info("send mail message to card: " + cardNumber);
                    loginfo = (String)loginfo + String.format("call messaging.sendMail(operatorTag=%s, serialNumber=%d, messageBody=%s, textMode=%s)\n", con.operatorTag, cardNumber, message, con.textMode.value());
                    result = Pisys2ServiceActivator.checkAnswer(con.messaging.sendMail(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber), message, con.textMode), (String)loginfo);
                } else {
                    log.info("send osd message to card: " + cardNumber);
                    loginfo = (String)loginfo + String.format("call messaging.sendMessage(operatorTag=%s, serialNumber=%d, messageBody=%s, textMode=%s)\n", con.operatorTag, cardNumber, message, con.textMode.value());
                    result = Pisys2ServiceActivator.checkAnswer(con.messaging.sendMessage(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber), message, con.textMode), (String)loginfo);
                }
                if (result == DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK) continue;
                return result;
            }
            return DigitalTVServiceActivator.ServiceActivationResult.RESULT_OK;
        }
        catch (Exception ex) {
            log.error("Exception sendMessagesImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult parentalPinCodeImpl(long cardNumber, String pinCode) {
        Object loginfo = "Info:\n";
        String line = "pin code card: " + cardNumber;
        log.info(line);
        loginfo = (String)loginfo + line + "\n";
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            loginfo = (String)loginfo + "Connection...\n";
            Con con = this.getConnection(0, userCard);
            if (Utils.notBlankString((String)pinCode)) {
                loginfo = (String)loginfo + String.format("call parentalControl.createParentalPinCode(operatorTag=%s, serialNumber=%d, PINCode=***)\n", con.operatorTag, cardNumber);
                return Pisys2ServiceActivator.checkAnswer(con.parentalControl.createParentalPinCode(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber), pinCode), (String)loginfo);
            }
            loginfo = (String)loginfo + String.format("call parentalControl.overwriteParentalPinCode(operatorTag=%s, serialNumber=%d)\n", con.operatorTag, cardNumber);
            return Pisys2ServiceActivator.checkAnswer(con.parentalControl.overwriteParentalPinCode(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber)), (String)loginfo);
        }
        catch (Exception ex) {
            log.error("Exception parentalPinCodeImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    @Override
    public DigitalTVServiceActivator.ServiceActivationResult customCommandImpl(long cardNumber, String action, String[] params) throws BGException {
        switch (action) {
            case "downloadCode": {
                return this.downloadCodeImpl(cardNumber);
            }
            case "patchSmartCard": {
                return this.patchSmartCardImpl(cardNumber);
            }
            case "marrySmartcard_on": {
                return this.marrySmartcardImpl(cardNumber, true);
            }
            case "marrySmartcard_off": {
                return this.marrySmartcardImpl(cardNumber, false);
            }
            case "tune": {
                return this.tuneImpl(cardNumber, false, "");
            }
            case "recoverSectorDatecode": {
                short years = (short)this.getModuleSetup(null).getInt("sa.recover.years", 5);
                return this.recoverSectorDatecodeImpl(cardNumber, years);
            }
        }
        throw new UnsupportedOperationException();
    }

    private DigitalTVServiceActivator.ServiceActivationResult downloadCodeImpl(long cardNumber) {
        Object loginfo = "Info:\n";
        String line = "download code card: " + cardNumber;
        log.info(line);
        loginfo = (String)loginfo + line + "\n";
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            loginfo = (String)loginfo + "Connection...\n";
            Con con = this.getConnection(0, userCard);
            loginfo = (String)loginfo + String.format("call download.downloadCode(operatorTag=%s, serialNumber=%d)\n", con.operatorTag, cardNumber);
            return Pisys2ServiceActivator.checkAnswer(con.download.downloadCode(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber)), (String)loginfo);
        }
        catch (Exception ex) {
            log.error("Exception downloadCodeImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    private DigitalTVServiceActivator.ServiceActivationResult marrySmartcardImpl(long cardNumber, boolean marry) {
        Object loginfo = "Info:\n";
        String line = "marry " + marry + " smartcard: " + cardNumber;
        log.info(line);
        loginfo = (String)loginfo + line + "\n";
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            loginfo = (String)loginfo + "Connection...\n";
            Con con = this.getConnection(0, userCard);
            if (marry) {
                loginfo = (String)loginfo + String.format("call marriage.marrySmartcard(operatorTag=%s, serialNumber=%d, marryTag=MARRY)\n", con.operatorTag, cardNumber);
                return Pisys2ServiceActivator.checkAnswer(con.marriage.marrySmartcard(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber), MarriageTag.MARRY), (String)loginfo);
            }
            loginfo = (String)loginfo + String.format("call marriage.divorceSmartcard(operatorTag=%s, serialNumber=%d)\n", con.operatorTag, cardNumber);
            return Pisys2ServiceActivator.checkAnswer(con.marriage.divorceSmartcard(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber)), (String)loginfo);
        }
        catch (Exception ex) {
            log.error("Exception marrySmartcardImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    private DigitalTVServiceActivator.ServiceActivationResult tuneImpl(long cardNumber, boolean emergency, String message) {
        Object loginfo = "Info:\n";
        String line = "tune card: " + cardNumber + ", emergency: " + emergency;
        log.info(line);
        loginfo = (String)loginfo + line + "\n";
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            loginfo = (String)loginfo + "Connection...\n";
            Con con = this.getConnection(0, userCard);
            if (emergency) {
                if (cardNumber == -1L) {
                    loginfo = (String)loginfo + String.format("call tuning.tuneToTargetedEmergencyServiceGlobal(operatorTag=%s, tmsExpression=\"\", networkId=%d, transportId=%d, serviceId=%d)\n", con.operatorTag, con.emergency_networkId, con.emergency_transportId, con.emergency_serviceId);
                    return Pisys2ServiceActivator.checkAnswer(con.tuning.tuneToTargetedEmergencyServiceGlobal(con.operatorTag, "", con.emergency_networkId, con.emergency_transportId, con.emergency_serviceId), (String)loginfo);
                }
                loginfo = (String)loginfo + String.format("call tuning.tuneToEmergencyService(operatorTag=%s, serialNumber=%d, networkId=%d, transportId=%d, serviceId=%d)\n", con.operatorTag, cardNumber, con.emergency_networkId, con.emergency_transportId, con.emergency_serviceId);
                return Pisys2ServiceActivator.checkAnswer(con.tuning.tuneToEmergencyService(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber), con.emergency_networkId, con.emergency_transportId, con.emergency_serviceId), (String)loginfo);
            }
            if (cardNumber == -1L) {
                loginfo = (String)loginfo + String.format("call recovery.rescanAllNetworksGlobal(operatorTag=%s, tmsExpression=\"\")\n", con.operatorTag);
                return Pisys2ServiceActivator.checkAnswer(con.recovery.rescanAllNetworksGlobal(con.operatorTag, ""), (String)loginfo);
            }
            loginfo = (String)loginfo + String.format("call recovery.rescanAllNetworks(operatorTag=%s, serialNumber=%d)\n", con.operatorTag, cardNumber);
            return Pisys2ServiceActivator.checkAnswer(con.recovery.rescanAllNetworks(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber)), (String)loginfo);
        }
        catch (Exception ex) {
            log.error("Exception tuneImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    private DigitalTVServiceActivator.ServiceActivationResult patchSmartCardImpl(long cardNumber) throws BGException {
        Object loginfo = "Info:\n";
        String line = "patch smartcard: " + cardNumber;
        log.info(line);
        loginfo = (String)loginfo + line + "\n";
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            loginfo = (String)loginfo + "Connection...\n";
            Con con = this.getConnection(0, userCard);
            loginfo = (String)loginfo + String.format("call smartcard.patchSmartcard(operatorTag=%s, serialNumber=%d)\n", con.operatorTag, cardNumber);
            return Pisys2ServiceActivator.checkAnswer(con.smartcard.patchSmartcard(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber)), (String)loginfo);
        }
        catch (Exception ex) {
            log.error("Exception patchSmartCardImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    private DigitalTVServiceActivator.ServiceActivationResult recoverSectorDatecodeImpl(long cardNumber, short years) throws BGException {
        Object loginfo = "Info:\n";
        String line = "recover sector datecode: " + cardNumber + ", years: " + years;
        log.info(line);
        loginfo = (String)loginfo + line + "\n";
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            loginfo = (String)loginfo + "Connection...\n";
            Con con = this.getConnection(0, userCard);
            loginfo = (String)loginfo + String.format("call sector.recoverSectorDatecode(operatorTag=%s, serialNumber=%d, years=%d)\n", con.operatorTag, cardNumber, years);
            return Pisys2ServiceActivator.checkAnswer(con.sector.recoverSectorDatecode(con.operatorTag, Pisys2ServiceActivator._cn(cardNumber), years), (String)loginfo);
        }
        catch (Exception ex) {
            log.error("Exception recoverSectorDatecodeImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", (String)loginfo, ex);
        }
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult getSubscribeInfoImpl(long cardNumber) throws BGException {
        StringBuilder infotext = new StringBuilder(64);
        String logline1 = "get subscribe card: " + cardNumber;
        log.info(logline1);
        infotext.append(logline1).append("\n");
        try {
            UserCard userCard = this.userCardManager.getUserCard(cardNumber, new Date());
            Con con = this.getConnection(0, userCard);
            infotext.append("server #0:\n");
            Property p1 = new Property();
            p1.setName("pairingInfo");
            p1.setValue("1");
            Property p2 = new Property();
            p1.setName("entitlementsInfo");
            p1.setValue("1");
            Property p3 = new Property();
            p1.setName("basicInfo");
            p1.setValue("1");
            Property p4 = new Property();
            p1.setName("securityInfo");
            p1.setValue("1");
            Property p5 = new Property();
            p1.setName("anchoringInfo");
            p1.setValue("1");
            Property p6 = new Property();
            p1.setName("tmsAttributeInfo");
            p1.setValue("1");
            Property p7 = new Property();
            p1.setName("sectorInfo");
            p1.setValue("1");
            Property p8 = new Property();
            p1.setName("ppvInfo");
            p1.setValue("1");
            Property p9 = new Property();
            p1.setName("deviceDomainInfo");
            p1.setValue("1");
            ArrayOfProperty secureClientProperties = new ArrayOfProperty();
            secureClientProperties.getSecureClientProperty().add(p1);
            secureClientProperties.getSecureClientProperty().add(p2);
            secureClientProperties.getSecureClientProperty().add(p3);
            secureClientProperties.getSecureClientProperty().add(p4);
            secureClientProperties.getSecureClientProperty().add(p5);
            secureClientProperties.getSecureClientProperty().add(p6);
            secureClientProperties.getSecureClientProperty().add(p7);
            secureClientProperties.getSecureClientProperty().add(p8);
            secureClientProperties.getSecureClientProperty().add(p9);
            SecureClientProfile secureClientProfile = new SecureClientProfile();
            secureClientProfile.setSerialNumber(Pisys2ServiceActivator._cn(cardNumber));
            secureClientProfile.setSecureClientProperties(secureClientProperties);
            ArrayOfSecureClientProfile secureClientProfiles = new ArrayOfSecureClientProfile();
            secureClientProfiles.getSecureClientProfile().add(secureClientProfile);
            SecureClientProfileCommandResult scpcr = con.query.querySecureClient(con.operatorTag, secureClientProfiles);
            List<SecureClientInfo> scil = scpcr.getSecureClients().getSecureClient();
            for (SecureClientInfo sci : scil) {
                infotext.append("sn=").append(sci.getSerialNumber()).append(", locationTag=").append(sci.getLocationTag()).append("\n");
            }
        }
        catch (Exception ex) {
            log.error("Exception in getSubscribeInfoImpl", (Throwable)ex);
            return new DigitalTVServiceActivator.ServiceActivationResult(false, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", ex);
        }
        return new DigitalTVServiceActivator.ServiceActivationResult(true, infotext.toString(), null, null);
    }

    private static BigInteger _cn(long cardNumber) {
        return BigInteger.valueOf(cardNumber);
    }

    private class Con {
        protected String operatorTag;
        protected String portalUsername;
        protected String portalPassword;
        protected Smarty portal;
        protected String sessionKey;
        protected TextMode textMode;
        protected EntitlementSoap entitlement;
        protected MessagingSoap messaging;
        protected ParentalControlSoap parentalControl;
        protected DownloadSoap download;
        protected SmartcardMarriageSoap marriage;
        protected TuningSoap tuning;
        protected SectorSoap sector;
        protected RecoverySoap recovery;
        protected SmartcardSoap smartcard;
        protected QuerySoap query;
        protected String nationality;
        protected String regionTag;
        protected String refreshSectorCreate;
        protected String locationTag;
        protected int emergency_networkId;
        protected int emergency_transportId;
        protected int emergency_serviceId;

        private Con() {
        }
    }
}

