/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.DealerDao;
import ru.bitel.common.TimeUtils;

public class ActionDealerUpdate
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        int mid = this.getIntParameter("mid", -1);
        String title = this.getParameter("title");
        float cardPercent = this.getFloatParameter("card_percent", 0.0f);
        float payPercent = this.getFloatParameter("pay_percent", 0.0f);
        if (id < -1 || mid < 0 || title == null) {
            throw new BGIllegalArgumentException();
        }
        TimeUtils.checkPeriod((Date)this.getDateParameter("date1"), (Date)this.getDateParameter("date2"));
        Dealer dealer = new Dealer();
        dealer.setId(id);
        dealer.setType(this.getIntParameter("type", 0));
        dealer.setTitle(title);
        dealer.setDate1(TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1")));
        dealer.setDate2(TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2")));
        dealer.setLogin(this.getParameter("dlogin", ""));
        dealer.setPassword(this.getParameter("password"));
        dealer.setPt(this.getParameter("pt", ""));
        dealer.setComment(this.getParameter("comment"));
        dealer.setParams(this.getIntParameter("params", 0));
        dealer.setFindmodes(this.getLongParameter("findmodes", 0L));
        dealer.setAllowcontracts(this.getLongParameter("allowcontracts", 0L));
        dealer.setAllowcontractsMode(this.getIntParameter("allowcontracts_mode", 0));
        dealer.setCardPercent(cardPercent);
        dealer.setPayPercent(payPercent);
        dealer.setCardContract(this.getParameter("card_contract", ""));
        dealer.setPayComissionType(this.getIntParameter("pay_comission_type", 0));
        dealer.setContractId(this.getIntParameter("contract_id", this.getIntParameter("contract_id", 0)));
        dealer.setCanselTime(this.getIntParameter("cansel_time", 0));
        if (this.getParameter("reset_error", "").equals("1")) {
            dealer.setError(-1);
        }
        if (this.getParameter("reset_statistics", "").equals("1")) {
            dealer.setStatRequest(-1);
        }
        DealerDao dealerDao = new DealerDao(this.con, mid);
        dealerDao.update(dealer);
        dealerDao.close();
    }
}

