/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.AccessCodes;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAuthError;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.sql.ConnectionSet;

public class VoiceAuthErrorDao
extends AbstractIdDao<VoiceAuthError> {
    private ConnectionSet connectionSet;

    public VoiceAuthErrorDao(ConnectionSet connectionSet, int moduleId, Date date) {
        super(connectionSet.getConnection(), moduleId, "voice_auth_error", date);
        this.connectionSet = connectionSet;
    }

    protected VoiceAuthError getFromRS(ResultSet rs) throws SQLException, BGException {
        return VoiceAuthError.builder().setId(rs.getInt("id")).setDeviceId(rs.getInt("deviceId")).setDeviceTitle(rs.getString("deviceTitle")).setContractId(rs.getInt("contractId")).setContractTitle(rs.getString("contractTitle")).setAccountId(rs.getInt("accountId")).setAccountTitle(rs.getString("accountTitle")).setErrorCode(rs.getInt("code")).setErrorText(AccessCodes.toString((ParameterMap)Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)), (int)rs.getInt("code"))).setLastErrorTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("lastTime"))).setLogCoordinateRecordId(rs.getInt("logCoordinateRecordId")).build();
    }

    protected void updateImpl(VoiceAuthError b) throws BGException, SQLException {
    }

    public void update(VoiceAuthError b) throws BGException {
        super.update((Object)b);
    }

    public void addError(VoiceAuthError error) throws Exception {
        Connection con = this.connectionSet.getTrashConnection(this.tableName, 1);
        try (Statement st = con.createStatement();){
            if (!ServerUtils.tableExists((Connection)con, (String)this.tableName)) {
                StringBuilder sb = new StringBuilder(100).append("CREATE TABLE IF NOT EXISTS " + this.tableName + "(id INT AUTO_INCREMENT NOT NULL, deviceId INT NOT NULL,deviceTitle CHAR(15) NOT NULL,contractId INT(10) UNSIGNED NULL DEFAULT NULL, contractTitle CHAR(15) NOT NULL,accountId INT(11) NULL DEFAULT NULL,accountTitle CHAR(100) NULL DEFAULT NULL,code INT NOT NULL,lastTime DATETIME NOT NULL,logCoordinateRecordId INT NOT NULL,KEY id(id),KEY deviceId(deviceId),KEY lastTime(lastTime),KEY `time_dcsc` (`lastTime`,`deviceId`,`contractId`,`accountId`,`code`),CONSTRAINT `fk_" + this.tableName + "_account` FOREIGN KEY (`accountId`) REFERENCES `voice_account_base_" + this.moduleId + "` (`id`) ON UPDATE CASCADE ON DELETE CASCADE,CONSTRAINT `fk_" + this.tableName + "_contract` FOREIGN KEY (`contractId`) REFERENCES `contract` (`id`) ON UPDATE CASCADE ON DELETE CASCADE,CONSTRAINT `fk_" + this.tableName + "_device` FOREIGN KEY (`deviceId`) REFERENCES `voice_device_" + this.moduleId + "` (`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
                st.executeUpdate(sb.toString());
            }
        }
        long millis = System.currentTimeMillis();
        Timestamp now = TimeUtils.convertDateToTimestampSeconds((Date)new Date(millis));
        String query = "INSERT INTO " + this.tableName + " SET deviceId=?, deviceTitle=?, contractId=?, contractTitle=?, accountId=?,  accountTitle=?, code=?, logCoordinateRecordId=?, lastTime=?";
        try (PreparedStatement ps = con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, error.getDeviceId());
            ps.setString(index++, error.getDeviceTitle());
            if (error.getContractId() > 0) {
                ps.setInt(index++, error.getContractId());
            } else {
                ps.setNull(index++, 4);
            }
            ps.setString(index++, Utils.maskNull((String)error.getContractTitle()));
            if (error.getAccountId() > 0) {
                ps.setInt(index++, error.getAccountId());
            } else {
                ps.setNull(index++, 4);
            }
            ps.setString(index++, error.getAccountTitle());
            ps.setInt(index++, error.getErrorCode());
            ps.setInt(index++, error.getLogCoordinateRecordId());
            ps.setTimestamp(9, now);
            ps.executeUpdate();
        }
    }

    public Result<VoiceAuthError> errorList(Date timeFrom, Date timeTo, Set<Integer> deviceIds, Set<Integer> contractIds, Set<Integer> accountIds, String contract, String login, Page page) throws BGException {
        ArrayList<VoiceAuthError> result = new ArrayList<VoiceAuthError>();
        Connection con = this.connectionSet.getTrashConnection(this.tableName, 2);
        try {
            if (ServerUtils.tableExists((Connection)con, (String)this.tableName)) {
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT SQL_CALC_FOUND_ROWS auth_error.* FROM " + this.tableName + " as auth_error");
                if (Utils.notBlankString((String)contract)) {
                    sb.append(" LEFT JOIN contract ON contract.id=auth_error.contractId");
                }
                if (Utils.notBlankString((String)login)) {
                    sb.append(" LEFT JOIN voice_account_" + this.moduleId + " as account ON account.id=auth_error.accountId");
                }
                sb.append(" WHERE auth_error.lastTime>=? AND auth_error.lastTime<?");
                if (Utils.notEmptyCollection(contractIds)) {
                    sb.append(" AND auth_error.contractId IN (" + Utils.toString(contractIds) + ")");
                }
                if (Utils.notEmptyCollection(deviceIds)) {
                    sb.append(" AND auth_error.deviceId IN (" + Utils.toString(deviceIds) + ")");
                }
                if (Utils.notEmptyCollection(accountIds)) {
                    sb.append(" AND auth_error.accountId IN (" + Utils.toString(accountIds) + ")");
                }
                if (Utils.notBlankString((String)contract)) {
                    sb.append(" AND contract.title LIKE ?");
                }
                if (Utils.notBlankString((String)login)) {
                    sb.append(" AND account.login LIKE ?");
                }
                sb.append(" ORDER BY auth_error.lastTime DESC " + page.sqlLimit());
                PreparedStatement ps = con.prepareStatement(sb.toString());
                int i = 0;
                ps.setTimestamp(++i, TimeUtils.convertDateToTimestampSeconds((Date)timeFrom));
                ps.setTimestamp(++i, TimeUtils.convertDateToTimestampSeconds((Date)timeTo));
                if (Utils.notBlankString((String)contract)) {
                    ps.setString(++i, "%" + contract.trim() + "%");
                }
                if (Utils.notBlankString((String)login)) {
                    ps.setString(++i, "%" + login.trim() + "%");
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
                rs.close();
                ps.close();
                page.setRecordCount(ServerUtils.foundRows((Connection)con));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return new Result(result, page);
    }
}

