/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.phone.common.bean.Gate;
import ru.bitel.bgbilling.modules.phone.server.bean.GateTypeManager;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class GateManager {
    private String gateTable = null;
    private String gateContractTable = null;
    protected int mid = -1;
    protected Connection con;

    public GateManager(Connection con, int mid) {
        this.mid = mid;
        this.con = con;
        this.gateTable = "phone_gate_" + mid;
        this.gateContractTable = "phone_contract_gate_" + mid;
    }

    public List<Gate> list() throws BGException {
        ArrayList<Gate> result = new ArrayList<Gate>();
        try {
            StringBuffer query = new StringBuffer();
            this.addWherePart(query);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Gate gate = this.getFromRS(rs);
                result.add(gate);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private void addWherePart(StringBuffer query) {
        query.append(" SELECT  gate.*, type.title as typeTitle from  " + this.gateTable + " as gate");
        query.append(" LEFT JOIN  " + new GateTypeManager(this.con, this.mid).getTable() + " as type ");
        query.append(" ON type.id = gate.type_id");
    }

    private Gate getFromRS(ResultSet rs) throws SQLException {
        Gate result = new Gate();
        result.setId(rs.getInt("id"));
        result.setComment(rs.getString("comment"));
        result.setHost(rs.getString("host"));
        result.setConfig(rs.getString("config"));
        result.setKeyword(rs.getString("keyword"));
        result.setPort(rs.getInt("port"));
        result.setTypeId(rs.getInt("type_id"));
        result.setTypeTitle(rs.getString("typeTitle"));
        return result;
    }

    public void update(Gate gate) throws BGException {
        try {
            StringBuffer query = new StringBuffer();
            String setPart = " SET  comment = ?, host = ?, config = ?, keyword = ?, port = ?, type_id = ? ";
            if (gate.getId() > 0) {
                query.append(" UPDATE  " + this.gateTable);
                query.append(setPart);
                query.append(" WHERE id = ?  ");
            } else {
                query.append(" INSERT INTO   " + this.gateTable);
                query.append(setPart);
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int idx = 1;
            ps.setString(idx++, gate.getComment());
            ps.setString(idx++, gate.getHost());
            ps.setString(idx++, gate.getConfig());
            ps.setString(idx++, gate.getKeyword());
            ps.setInt(idx++, gate.getPort());
            ps.setInt(idx++, gate.getTypeId());
            if (gate.getId() > 0) {
                ps.setInt(idx++, gate.getId());
            }
            ps.executeUpdate();
            ps.close();
            if (gate.getId() == 0) {
                gate.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Gate getGateById(int id) throws BGException {
        Gate result = null;
        try {
            StringBuffer query = new StringBuffer();
            this.addWherePart(query);
            query.append(" WHERE gate.id = ? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public void delete(int id) throws BGException {
        try {
            StringBuffer query = new StringBuffer();
            query.append(" DELETE FROM  " + this.gateTable);
            query.append(" WHERE id = ?  ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int idx = 1;
            ps.setInt(idx++, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean isGateTypeUsed(int gateTypeId) throws BGException {
        boolean result = false;
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT  COUNT(*) from  " + this.gateTable);
            query.append(" WHERE type_id = ? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, gateTypeId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) > 0;
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public List<Gate> getContractGates(int cid) throws BGException {
        ArrayList<Gate> result = new ArrayList<Gate>();
        try {
            StringBuffer query = new StringBuffer();
            this.addWherePart(query);
            query.append(" LEFT JOIN " + this.gateContractTable + " as gate_contract ");
            query.append(" ON gate_contract.gid = gate.id ");
            query.append(" WHERE gate_contract.cid = ?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Gate gate = this.getFromRS(rs);
                result.add(gate);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public void addContractGate(int cid, int gid) throws BGException {
        try {
            StringBuffer query = new StringBuffer();
            query.append(" INSERT INTO   " + this.gateContractTable);
            query.append(" SET  cid = ?, gid = ? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int idx = 1;
            ps.setInt(idx++, cid);
            ps.setInt(idx++, gid);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void deleteContractGate(int cid, int gid) throws BGException {
        try {
            StringBuffer query = new StringBuffer();
            query.append(" DELETE FROM " + this.gateContractTable);
            query.append(" WHERE  cid = ? AND gid = ? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int idx = 1;
            ps.setInt(idx++, cid);
            ps.setInt(idx++, gid);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean isGateUsed(int gateId) throws BGException {
        boolean result = false;
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT  COUNT(*) from  " + this.gateContractTable);
            query.append(" WHERE gid = ? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, gateId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) > 0;
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }
}

