/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action.web;

import bitel.billing.server.ActionConType;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.util.Iter;
import bitel.billing.server.util.PagedList;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.phone.server.action.ActionReportSession;
import ru.bitel.bgbilling.modules.phone.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemManager;
import ru.bitel.bgbilling.modules.phone.server.bean.Report;
import ru.bitel.bgbilling.modules.phone.server.bean.ReportManager;
import ru.bitel.bgbilling.modules.phone.server.bean.Session;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.util.FileDownload;

@ActionConType(value=2)
@Deprecated
public class ActionReportSession
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        GregorianCalendar current;
        int delta;
        int limitDay;
        List<ClientItem> itemList;
        if (this.cid <= 0 && this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Period period = this.getPeriodByYearsAndDays();
        Calendar date1 = period.getDateFromCalendar();
        Calendar date2 = period.getDateToCalendar();
        String items = this.getParameterValues("items");
        int type = this.getIntParameter("type", 1);
        Page page = this.getPage();
        List selected = Utils.toIntegerList((String)items);
        Element itemsEl = this.createElement(this.rootNode, "items");
        ClientItemManager man = new ClientItemManager(this.con, this.mid);
        Period period4select = null;
        String webItemListContentMode = this.moduleSetup.get("web.item.list.content.mode", null);
        if ("all".equals(webItemListContentMode)) {
            period4select = null;
        } else if ("currperiod".equals(webItemListContentMode)) {
            period4select = new Period(date1.getTime(), date2.getTime());
        } else {
            GregorianCalendar now = new GregorianCalendar();
            ((Calendar)now).add(2, -1);
            Date prevMonth = now.getTime();
            period4select = new Period(prevMonth, null);
        }
        List<ClientItem> pointList = man.getItemList(this.cid, 1, false, 0, period4select);
        List<ClientItem> ruleList = man.getItemList(this.cid, 2, false, 0, period4select);
        if (pointList.size() > 0) {
            this.rootNode.setAttribute("points", "1");
        }
        if (ruleList.size() > 0) {
            this.rootNode.setAttribute("rules", "1");
        }
        if (!"ActionReportDirect".equals(((Object)((Object)this)).getClass().getSimpleName())) {
            if (type == 1) {
                if (pointList.size() <= 0 && ruleList.size() > 0) {
                    type = 2;
                    itemList = ruleList;
                } else {
                    itemList = pointList;
                }
            } else if (ruleList.size() <= 0 && pointList.size() > 0) {
                type = 1;
                itemList = pointList;
            } else {
                itemList = ruleList;
            }
        } else {
            itemList = pointList;
        }
        this.rootNode.setAttribute("type", String.valueOf(type));
        block0: for (ClientItem item : itemList) {
            Element itemEl = this.addListItem(itemsEl, item.getId(), item.toStringWithoutSource() + item.getPeriod());
            for (Integer id : selected) {
                if (id.intValue() != item.getId()) continue;
                itemEl.setAttribute("selected", "1");
                selected.remove(id);
                continue block0;
            }
        }
        if (Utils.notBlankString((String)items) && (limitDay = this.moduleSetup.getInt("stat.limit.day", 0)) > 0 && ((delta = TimeUtils.monthsDelta((Calendar)date1, (Calendar)(current = new GregorianCalendar()))) == 0 || delta == 1 && current.get(5) < limitDay)) {
            throw new BGMessageException("\u0418\u0437\u0432\u0438\u043d\u0438\u0442\u0435, \u043d\u043e \u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0440\u043e\u0441\u043c\u0430\u0442\u0440\u0438\u0432\u0430\u0442\u044c \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u0437\u0430 \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043c\u0435\u0441\u044f\u0446 \u0434\u043e " + limitDay + " \u0447\u0438\u0441\u043b\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u043c\u0435\u0441\u044f\u0446\u0430.");
        }
        boolean noFree = this.getIntParameter("nofree", -1) > 0;
        itemsEl.setAttribute("nofree", noFree ? "1" : "0");
        this.doAction(items, type, date1, date2, page, noFree);
    }

    protected void doAction(String items, int type, Calendar date1, Calendar date2, Page page, boolean noFree) throws BGException {
        if (items != null) {
            int dest = this.getIntParameter("dest", -1);
            int sid = this.getIntParameter("sid", -1);
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            boolean file = "1".equals(this.getParameter("file", null));
            String output = this.getParameter("output", "csv");
            boolean zip = "1".equals(this.getParameter("zip", null));
            if (file || this.getParameter("showAll") != null) {
                page.setPageSize(-1);
            }
            PagedList<Session> sessionList = new ReportManager(this.con, this.mid).getSessionList(this.cid, items, date1, date2, type, noFree, page, dest, sid, false);
            if (file) {
                String contentType;
                String ext;
                String xsl;
                Element table = this.createElement(this.rootNode, "table");
                this.createElement(table, "data");
                this.setPageAttribute(table, sessionList.page);
                table.setAttribute("count", String.valueOf(sessionList.records));
                table.setAttribute("total_number", String.valueOf(sessionList.records));
                table.setAttribute("total_cost", Utils.formatCost((BigDecimal)((Session)((Object)sessionList.total)).getSessionCost()));
                float time = ((Session)((Object)sessionList.total)).getSessionTime();
                table.setAttribute("total_time", Utils.formatSessionTime((int)((Session)((Object)sessionList.total)).getSessionTime()) + " [" + Math.round(time / 60.0f) + "]");
                time = ((Session)((Object)sessionList.total)).getSessionTimeRound();
                table.setAttribute("total_time_round", Utils.formatSessionTime((int)((Session)((Object)sessionList.total)).getSessionTimeRound()) + " [" + Math.round(time / 60.0f) + "]");
                Thread.currentThread().setPriority(1);
                this.request.setAttribute("contentType", (Object)"binary");
                HashMap<String, Object> params = new HashMap<String, Object>(4);
                Iterator<Session> iter = sessionList.list.iterator();
                params.put("beans", new Iter.PublicIter(iter));
                params.put("lines", new ActionReportSession.CSVLine(iter, format));
                params.put("size", new Iter.BeanNodeList(sessionList.list.size()));
                params.put("format", format);
                if ("html".equals(output)) {
                    xsl = "phone_login_sessions.xsl";
                    ext = ".html";
                    contentType = "text/html";
                } else {
                    xsl = "phone_login_sessions_csv.xsl";
                    ext = ".csv";
                    contentType = "application/csv";
                }
                ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());
                Contract contract = (Contract)contractDao.get(this.cid);
                contractDao.close();
                String fileName = FileDownload.transliterationFileName((String)((String)(contract != null ? contract.getTitle() + "_" : "") + "sessions_" + date1.get(1) + "_" + (date1.get(2) + 1)));
                table.setAttribute("contractTitle", contract.getTitle());
                table.setAttribute("comment", contract.getComment());
                table.setAttribute("date1", TimeUtils.formatDate((Calendar)date1));
                table.setAttribute("date2", TimeUtils.formatDate((Calendar)date2));
                table.setAttribute("type", String.valueOf(type));
                XSLManager.getInstance().transformToResponse(this.response, xsl, (Source)new DOMSource(this.rootNode.getOwnerDocument()), params, contentType, fileName + ext, zip);
            } else {
                boolean msg = false;
                int max = this.moduleSetup.getInt("show.on.page.web.max", 1000);
                List list = sessionList.list;
                if (sessionList.list.size() > max) {
                    list = sessionList.list.subList(0, max - 1);
                    msg = true;
                }
                Element sessions = this.createElement(this.rootNode, "sessions");
                if (dest > 0) {
                    this.rootNode.setAttribute("dest", String.valueOf(dest));
                }
                if (sid > 0) {
                    this.rootNode.setAttribute("sid", String.valueOf(sid));
                }
                for (Session session : list) {
                    Element sess = this.createElement(sessions, "session");
                    sess.setAttribute("id", String.valueOf(session.getId()));
                    sess.setAttribute("item_id", String.valueOf(session.getClientItemId()));
                    sess.setAttribute("item", session.getClientItem());
                    sess.setAttribute("dest", session.getDestination());
                    sess.setAttribute("dest_id", String.valueOf(session.getDestCode()));
                    sess.setAttribute("session_start", format.format((Object)session.getSessionStart()));
                    sess.setAttribute("session_time", String.valueOf(session.getSessionTime()));
                    sess.setAttribute("session_time_round", String.valueOf(session.getSessionTimeRound()));
                    sess.setAttribute("session_cost", session.getSessionCost().toPlainString());
                    sess.setAttribute("from164", session.getFromNumber164());
                    sess.setAttribute("to164", session.getToNumber164());
                    sess.setAttribute("from", session.getFromNumber());
                    sess.setAttribute("to", session.getToNumber());
                    sess.setAttribute("service", session.getService());
                }
                this.setPageAttribute(sessions, sessionList.page);
                sessions.setAttribute("count", String.valueOf(sessionList.records));
                sessions.setAttribute("total_number", String.valueOf(sessionList.records));
                sessions.setAttribute("total_cost", Utils.formatCost((BigDecimal)((Session)((Object)sessionList.total)).getSessionCost()));
                sessions.setAttribute("total_time", String.valueOf(((Session)((Object)sessionList.total)).getSessionTime()));
                sessions.setAttribute("total_time_round", String.valueOf(((Session)((Object)sessionList.total)).getSessionTimeRound()));
                if (msg) {
                    this.setWebErrorMessage("\u041f\u043e\u043a\u0430\u0437\u0430\u043d\u044b \u043f\u0435\u0440\u0432\u044b\u0435 " + max + " \u0441\u0435\u0441\u0441\u0438\u0439. \u0414\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u043d\u043e\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430 \u0432\u043e\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435\u043c \u0432 CSV/HTML");
                }
            }
        }
    }

    protected void addPortsAndNums(Report report, Element rep) {
        for (String port : report.getPortList()) {
            Element portEl = this.createElement(rep, "port");
            XMLUtils.createTextNode((Node)portEl, (String)port);
        }
        for (String number : report.getNumberList()) {
            Element numberEl = this.createElement(rep, "number");
            XMLUtils.createTextNode((Node)numberEl, (String)number);
        }
    }

    protected void createDocument(int type, Calendar date1, Calendar date2, PagedList<Report> pointList, Object lines, Iterator<Report> iter, String name, String reportTitle) throws BGException {
        String output = this.getParameter("output", "csv");
        boolean file = "1".equals(this.getParameter("file", null));
        boolean zip = "1".equals(this.getParameter("zip", null));
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (Report report : pointList.list) {
            Element rep = this.createElement(data, "row");
            rep.setAttribute("item_id", String.valueOf(report.getClientItemId()));
            rep.setAttribute("item", report.getClientItem());
            rep.setAttribute("dest_id", String.valueOf(report.getDestCode()));
            rep.setAttribute("dest", report.getDestination());
            rep.setAttribute("number", String.valueOf(report.getNumber()));
            rep.setAttribute("time", String.valueOf(report.getTime()));
            rep.setAttribute("time_round", String.valueOf(report.getTimeRound()));
            rep.setAttribute("cost", report.getCost().toPlainString());
            this.addPortsAndNums(report, rep);
        }
        this.setPageAttribute(table, pointList.page);
        table.setAttribute("count", String.valueOf(pointList.records));
        table.setAttribute("total_number", String.valueOf(((Report)pointList.total).getNumber()));
        String formatCost = Utils.formatCost((BigDecimal)((Report)pointList.total).getCost());
        table.setAttribute("total_cost", formatCost == null ? "0" : formatCost);
        table.setAttribute("total_time", String.valueOf(((Report)pointList.total).getTime()));
        table.setAttribute("total_time_round", String.valueOf(((Report)pointList.total).getTimeRound()));
        if (file) {
            String contentType;
            String ext;
            String xsl;
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("beans", new Iter.PublicIter(iter));
            params.put("lines", lines);
            params.put("size", new Iter.BeanNodeList(pointList.list.size()));
            params.put("format", format);
            if ("html".equals(output)) {
                xsl = "phone_login_" + name + ".xsl";
                ext = ".html";
                contentType = "text/html";
            } else {
                xsl = "phone_login_" + name + "_csv.xsl";
                ext = ".csv";
                contentType = "application/csv";
            }
            ContractUtils cu = new ContractUtils(this.con);
            table.setAttribute("contractTitle", cu.getContractTitle(this.cid));
            table.setAttribute("date1", TimeUtils.formatDate((Calendar)date1));
            table.setAttribute("date2", TimeUtils.formatDate((Calendar)date2));
            table.setAttribute("reportTitle", reportTitle);
            table.setAttribute("type", String.valueOf(type));
            String fileName = FileDownload.transliterationFileName((String)(cu.getContractTitle(this.cid) + name + "_" + date1.get(1) + "_" + (date1.get(2) + 1)));
            XSLManager.getInstance().transformToResponse(this.response, xsl, (Source)new DOMSource(this.rootNode.getOwnerDocument()), params, contentType, fileName + ext, zip);
        }
    }
}

