/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server;

import bitel.billing.server.MaxTrafficCalculator;
import bitel.billing.server.ModuleBase;
import bitel.billing.server.admin.resource.bean.NumberResource;
import bitel.billing.server.admin.resource.bean.NumberResourceUseManager;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.util.db.TableCopier;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ModuleEntity;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.system.CommonEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.system.GetErrorLogModulesEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.phone.common.bean.PhoneContractStatus;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemManager;
import ru.bitel.bgbilling.modules.phone.server.bean.PhoneContractStatusManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"bitel.billing.server.phone"};

    public void start(Connection con, BGModule module) throws BGException {
        super.start(con, module);
        GetErrorLogModulesEvent.addListener((BGModule)module);
    }

    public String[] getServerPackages() {
        return PACKAGES;
    }

    /*
     * WARNING - void declaration
     */
    public void moduleAction(ServerContext ctx, int mid, Event event) throws Exception {
        super.moduleAction(ctx, mid, event);
        if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
            Connection con = ctx.getConnection();
            if (!cdEvent.isCheck()) {
                String cidStr = String.valueOf(event.getContractId());
                List items = ServerUtils.deleteRowsFromTable((Connection)con, (String)("phone_client_item_" + mid), (String)"cid", (String)cidStr, (String)"id");
                for (String itemId : items) {
                    ServerUtils.deleteRowsFromTable((Connection)con, (String)("phone_item_number_" + mid), (String)"item_id", (String)itemId, null);
                    ServerUtils.deleteRowsFromTable((Connection)con, (String)("phone_item_port_" + mid), (String)"item_id", (String)itemId, null);
                    ServerUtils.deleteRowsFromTable((Connection)con, (String)("phone_item_rule_data_" + mid), (String)"item_id", (String)itemId, null);
                }
                new NumberResourceUseManager(con, mid).freeResources(event.getContractId());
            }
        } else if (event instanceof ContractCloseEvent) {
            ContractCloseEvent ccEvent = (ContractCloseEvent)event;
            Connection con = ctx.getConnection();
            if (ccEvent.isCheck()) {
                ClientItemManager itemManager = new ClientItemManager(con, mid);
                for (ClientItem item : itemManager.getItemList(ccEvent.getContractId())) {
                    if (item.getDate2() == null || !TimeUtils.dateBefore((Date)ccEvent.getDate(), (Date)TimeUtils.convertCalendarToDate((Calendar)item.getDate2()))) continue;
                    Object error = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 ";
                    error = item.getType() == 1 ? (String)error + "\u043f\u043e\u0438\u043d\u0442 " + item.toString() : (String)error + "\u043f\u0440\u0430\u0432\u0438\u043b\u043e " + item.toString();
                    error = (String)error + "\n\u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u0443 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.";
                    ccEvent.setError((String)error);
                    return;
                }
            } else {
                new NumberResourceUseManager(con, mid).closeResourceUse(ccEvent.getContractId(), ccEvent.getDate());
                String itemTable = "phone_client_item_" + mid;
                TableCopier tableCopier = new TableCopier(con);
                tableCopier.updateColumn(itemTable, "date2", TimeUtils.formatSQLDate((Date)ccEvent.getDate()), "cid=" + ccEvent.getContractId() + " AND date2 IS NULL");
            }
        } else if (event instanceof ContractWrapEvent) {
            ContractWrapEvent cwEvent = (ContractWrapEvent)event;
            Connection con = ctx.getConnection();
            if (cwEvent.isCheck()) {
                ClientItemManager itemManager = new ClientItemManager(con, mid);
                for (ClientItem item : itemManager.getItemList(cwEvent.getContractId())) {
                    if (item.getDate1() != null) continue;
                    Object error = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 ";
                    error = item.getType() == 1 ? (String)error + "\u043f\u043e\u0438\u043d\u0442 " + item.toString() : (String)error + "\u043f\u0440\u0430\u0432\u0438\u043b\u043e " + item.toString();
                    error = (String)error + "\n\u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f.";
                    cwEvent.setError((String)error);
                    return;
                }
            } else {
                int cid = cwEvent.getContractId();
                TreeSet<GregorianCalendar> monthForBalanceSet = new TreeSet<GregorianCalendar>();
                boolean strictCheck = new ModuleSetup(con, mid).getInt("point.resource.strict.check", 1) > 0;
                ClientItemManager itemManager = new ClientItemManager(con, mid);
                for (ClientItem item : itemManager.getItemList(cid)) {
                    void var15_50;
                    item = itemManager.getItem(item.getId());
                    int itemId = item.getId();
                    Calendar date2 = item.getDate2();
                    Calendar date1 = item.getDate1();
                    Integer n = (Integer)cwEvent.getObjectMap().get(item.getObjectId());
                    if (n == null) {
                        Integer n2 = 0;
                    }
                    if (TimeUtils.dateBefore((Calendar)TimeUtils.convertDateToCalendar((Date)cwEvent.getDateClose()), (Calendar)date1)) {
                        item.setContractId(cwEvent.getToContractId());
                        item.setObjectId(var15_50.intValue());
                        itemManager.realUpdate(0, item, strictCheck, ctx, false);
                        Set<NumberResource> resources = itemManager.preDelete(item);
                        itemManager.postDelete(resources);
                        this.wrapNPayService(Utils.toIntegerList((String)new ModuleSetup(con, mid).get("npay.mid", "0")), mid, cwEvent, itemId, itemId);
                        if (date2 == null) {
                            date2 = new GregorianCalendar();
                        }
                        Object dateMonth = date1;
                        while (TimeUtils.monthsDelta((Calendar)dateMonth, (Calendar)date2) >= 0) {
                            String sessionTable = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)((Calendar)dateMonth).getTime(), (int)mid);
                            if (ServerUtils.tableExists((Connection)con, (String)sessionTable)) {
                                String query = "UPDATE " + sessionTable + " SET cid=? WHERE item_id=?";
                                PreparedStatement psUpdate = con.prepareStatement(query);
                                psUpdate.setInt(1, cwEvent.getToContractId());
                                psUpdate.setInt(2, itemId);
                                psUpdate.executeUpdate();
                                psUpdate.close();
                            }
                            ((Calendar)dateMonth).add(2, 1);
                        }
                        continue;
                    }
                    if (!cwEvent.checkNeedWrap(TimeUtils.convertCalendarToDate((Calendar)date2))) continue;
                    Calendar oldDate2 = item.getDate2();
                    item.setDate2(TimeUtils.convertDateToCalendar((Date)cwEvent.getDateClose()));
                    itemManager.realUpdate(0, item, strictCheck, ctx, false);
                    item.setDate1(TimeUtils.convertDateToCalendar((Date)cwEvent.getDateOpen()));
                    item.setDate2(oldDate2);
                    item.setContractId(cwEvent.getToContractId());
                    item.setObjectId(var15_50.intValue());
                    item.setId(-1);
                    itemManager.realUpdate(0, item, strictCheck, ctx, false);
                    int newItemId = item.getId();
                    cwEvent.relinkEntry(con, "contract_tariff", mid, itemId, newItemId);
                    cwEvent.relinkEntry(con, "contract_service", mid, itemId, newItemId);
                    this.wrapNPayService(Utils.toIntegerList((String)new ModuleSetup(con, mid).get("npay.mid", "0")), mid, cwEvent, itemId, newItemId);
                    if (date2 == null) {
                        date2 = new GregorianCalendar();
                    }
                    Calendar dateMonth = TimeUtils.convertDateToCalendar((Date)cwEvent.getDateOpen());
                    while (TimeUtils.monthsDelta((Calendar)dateMonth, (Calendar)date2) >= 0) {
                        String sessionTable = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)dateMonth.getTime(), (int)mid);
                        if (ServerUtils.tableExists((Connection)con, (String)sessionTable)) {
                            String query = "UPDATE " + sessionTable + " SET cid=?, item_id=? WHERE item_id=? AND ?<=session_start";
                            PreparedStatement psUpdateSession = con.prepareStatement(query);
                            psUpdateSession.setInt(1, cwEvent.getToContractId());
                            psUpdateSession.setInt(2, newItemId);
                            psUpdateSession.setInt(3, itemId);
                            psUpdateSession.setDate(4, TimeUtils.convertDateToSqlDate((Date)cwEvent.getDateOpen()));
                            psUpdateSession.executeUpdate();
                            psUpdateSession.close();
                            monthForBalanceSet.add(new GregorianCalendar(dateMonth.get(1), dateMonth.get(2), 1));
                        }
                        dateMonth.add(2, 1);
                    }
                    cwEvent.addToEntityMap(mid, itemId, newItemId);
                }
                String sids = MaxTrafficCalculator.getModuleServicesWithoutMaxTraf((Connection)con, (int)mid, (Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(mid)));
                String query = "DELETE FROM contract_account WHERE cid IN (" + cwEvent.getContractId() + ", " + cwEvent.getToContractId() + ") AND yy=? AND mm=? AND sid IN ( " + sids + ")";
                PreparedStatement psDeleteAccount = con.prepareStatement(query);
                BalanceUtils bu = new BalanceUtils(con);
                for (Calendar calendar : monthForBalanceSet) {
                    psDeleteAccount.setInt(1, calendar.get(1));
                    psDeleteAccount.setInt(2, calendar.get(2) + 1);
                    psDeleteAccount.executeUpdate();
                    String sessionTable = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)calendar.getTime(), (int)mid);
                    if (!ServerUtils.tableExists((Connection)con, (String)sessionTable)) continue;
                    query = "SELECT cid, sid, SUM(cost) FROM " + sessionTable + " WHERE cid IN (" + cwEvent.getContractId() + "," + cwEvent.getToContractId() + ") GROUP BY cid, sid";
                    try (PreparedStatement psSelectAccount = con.prepareStatement(query);
                         ResultSet rs = psSelectAccount.executeQuery();){
                        while (rs.next()) {
                            bu.setContractAccount(rs.getInt(1), TimeUtils.convertDateToLocalDate((Date)calendar.getTime()), rs.getInt(2), rs.getBigDecimal(3));
                        }
                    }
                    bu.setBalanceFromAccount(cwEvent.getContractId(), calendar);
                    bu.setBalanceFromAccount(cwEvent.getToContractId(), calendar);
                }
                bu.close();
                psDeleteAccount.close();
            }
        } else if (event instanceof ObjectMoveEvent) {
            Connection con = ctx.getConnection();
            String itemTable = "phone_client_item_" + mid;
            String query = "UPDATE " + itemTable + " SET object_id=0 WHERE object_id=?";
            PreparedStatement psUpdate = con.prepareStatement(query);
            psUpdate.setInt(1, ((ObjectMoveEvent)event).getObjectId());
            psUpdate.executeUpdate();
            psUpdate.close();
        } else if (event instanceof CommonEvent) {
            CommonEvent commonEvent = (CommonEvent)event;
            Connection con = ctx.getConnection();
            int cid = commonEvent.getContractId();
            Integer cmid = (Integer)commonEvent.getParameter("mid");
            boolean rangeDeleted = commonEvent.getParameter("rangeDeleted") != null;
            boolean rangeUpdated = commonEvent.getParameter("rangeUpdated") != null;
            Date dateFrom = (Date)commonEvent.getParameter("dateFrom");
            Date dateTo = (Date)commonEvent.getParameter("dateTo");
            Integer rangeId = (Integer)commonEvent.getParameter("rangeId");
            int ipnMid = Setup.getSetup().getModuleSetup(Integer.valueOf(mid)).getInt("ipn.mid", 0);
            if (cmid != null && ipnMid > 0 && cmid == ipnMid && rangeId != null) {
                if (rangeDeleted) {
                    ClientItemManager man = new ClientItemManager(con, mid);
                    if (!man.checkPoints(cid, rangeId)) {
                        commonEvent.setParameter("deleteRejected", (Object)true);
                    }
                } else if (rangeUpdated) {
                    ClientItemManager itemMan = new ClientItemManager(con, mid);
                    List<ClientItem> list = itemMan.getPointsForIpRange(cid, rangeId);
                    boolean flag = true;
                    for (ClientItem item : list) {
                        if (TimeUtils.periodInRange((Date)TimeUtils.convertCalendarToDate((Calendar)item.getDate1()), (Date)TimeUtils.convertCalendarToDate((Calendar)item.getDate2()), (Date)dateFrom, (Date)dateTo)) continue;
                        flag = false;
                        break;
                    }
                    if (!flag) {
                        commonEvent.setParameter("updateRejected", (Object)true);
                    }
                }
            }
        }
    }

    private void wrapNPayService(List<Integer> npayModuleIds, int moduleId, ContractWrapEvent event, int accountId, int newAccountId) throws BGException {
        for (Integer nPayModuleId : npayModuleIds) {
            CommonEvent commonEvent = new CommonEvent(event.getContractId(), nPayModuleId.intValue());
            commonEvent.setParameter("phone_abon", (Object)"true");
            commonEvent.setParameter("cidNew", (Object)event.getToContractId());
            commonEvent.setParameter("entityMid", (Object)moduleId);
            commonEvent.setParameter("entityIdOld", (Object)accountId);
            commonEvent.setParameter("entityIdNew", (Object)newAccountId);
            commonEvent.setParameter("dateOpen", (Object)event.getDateOpen());
            commonEvent.setParameter("dateClose", (Object)event.getDateClose());
            EventProcessor.getInstance().request((QueueEvent)commonEvent);
        }
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter module, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String cidStr = String.valueOf(cid);
        List items = ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)module, (String)("phone_client_item_" + mid), (String)"cid", (String)cidStr, (String)"id", (boolean)onlyCurrent, (String)"date1", (String)"date2");
        for (String itemId : items) {
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)module, (String)("phone_item_number_" + mid), (String)"item_id", (String)itemId, null, (boolean)false, null, null);
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)module, (String)("phone_item_port_" + mid), (String)"item_id", (String)itemId, null, (boolean)false, null, null);
        }
    }

    public List<ModuleEntity> getObjectEntities(Connection con, int mid, int objectId) throws BGException {
        ArrayList<ModuleEntity> result = new ArrayList<ModuleEntity>();
        List<ClientItem> items = new ClientItemManager(con, mid).getObjectItemList(objectId);
        for (ClientItem item : items) {
            ModuleEntity me = new ModuleEntity();
            result.add(me);
            if (item.getType() == 1) {
                if (item.getClientNumbers().size() > 0) {
                    me.setName("\u041d\u043e\u043c\u0435\u0440\u0430");
                    me.setData(Utils.toString(item.getClientNumbers()));
                } else {
                    me.setName("\u041f\u043e\u0440\u0442\u044b");
                    me.setData(Utils.toString(item.getClientPorts()));
                }
            } else {
                me.setName("\u041f\u0440\u0430\u0432\u0438\u043b\u043e");
                me.setData(item.toString());
            }
            me.setPeriod(TimeUtils.formatPeriod((Calendar)item.getDate1(), (Calendar)item.getDate2()));
            me.setComment(item.getComment());
        }
        return result;
    }

    public String getStatus(Connection con, int moduleId, int contractId) throws BGException {
        return PhoneContractStatus.statusToString((int)new PhoneContractStatusManager(con, moduleId).getContractStatus(contractId));
    }

    public void unlockService(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        PhoneContractStatusManager csm = new PhoneContractStatusManager(con, mid);
        if (csm.getContractStatus(contractRuntime.contractId) == 1) {
            csm.changeContractStatus(contractRuntime.contractId, 0, 0);
        }
    }

    public void lockService(Connection con, int mid, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        PhoneContractStatusManager csm = new PhoneContractStatusManager(con, mid);
        if (csm.getContractStatus(contractRuntime.contractId) == 0) {
            csm.changeContractStatus(contractRuntime.contractId, 1, 0);
        }
    }

    public List<MenuItem> getContractWebMenuItems(Connection con, String module, int moduleId, int contractId) throws BGException {
        HashSet<Integer> disableIds = new HashSet<Integer>();
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        if (!this.showIncommingCall(con, moduleSetup, contractId)) {
            disableIds.add(6);
        }
        if (!moduleSetup.getBoolean("web.menuItem.blackwhitelist.enable", false)) {
            disableIds.add(7);
        }
        return this.disableContractWebMenuItems(this.getWebMenuItems(con, module, moduleId), disableIds);
    }

    private boolean showIncommingCall(Connection con, ModuleSetup moduleSetup, int contractId) {
        String exception = moduleSetup.get("web.incommingCall.exception", null);
        boolean flagIncommingCall = moduleSetup.getBoolean("web.incommingCall", false);
        try (ContractManager contractManager = new ContractManager(con);){
            Contract contract = contractManager.getContractById(contractId);
            long lex = Utils.enumToMask((String)exception);
            boolean bl = flagIncommingCall ? (lex & contract.getGroups()) == 0L : (lex & contract.getGroups()) > 0L;
            return bl;
        }
    }
}

