/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.modules.megogo.client.MegogoSetupTab;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoTryAndBuy;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class MegogoTryAndBuySetupTab
extends MegogoSetupTab {
    private MegogoTryAndBuyTableModel model;
    private BGUTable table = null;
    private JPanel editor = new JPanel(new GridBagLayout());
    private BGTextField titleTextField = new BGTextField();
    private BGUComboBox<Service> subscriptionComboBox = new BGUComboBox();
    private BGComboBox<IdTitle> typeComboBox = new BGComboBox();
    private JCheckBox isUsed = new JCheckBox("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
    private IntTextField countDayTextField = new IntTextField();

    @Override
    protected void jbInit() throws Exception {
        this.model = new MegogoTryAndBuyTableModel(MegogoTryAndBuyTableModel.class.getName());
        this.table = new BGUTable((TableModel)((Object)this.model));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MegogoTryAndBuySetupTab.this.startEdit(false);
                }
            }
        });
        this.editor.setVisible(false);
        this.countDayTextField.setMaxValue(100L);
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        JPanel editorPanel = new JPanel(new GridBagLayout());
        editorPanel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        editorPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        editorPanel.add((Component)this.titleTextField, new GridBagConstraints(1, 0, 6, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        editorPanel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        editorPanel.add((Component)this.subscriptionComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        editorPanel.add((Component)new JLabel("\u0422\u0438\u043f: "), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        editorPanel.add((Component)this.typeComboBox, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        editorPanel.add((Component)new JLabel("\u041a\u043e\u043b-\u0432\u043e \u0434\u043d\u0435\u0439: "), new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        editorPanel.add((Component)this.countDayTextField, new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        editorPanel.add((Component)this.isUsed, new GridBagConstraints(6, 1, 1, 1, 1.0, 0.0, 10, 10, new Insets(5, 0, 5, 5), 0, 0));
        this.editor.add((Component)editorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void startEdit(boolean newTB) {
        try {
            MegogoTryAndBuy tryAndBuy = null;
            if (!newTB) {
                tryAndBuy = (MegogoTryAndBuy)this.model.getSelectedRow();
            } else {
                this.model.setSelectedRow(-1);
            }
            if (!newTB && tryAndBuy == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
                return;
            }
            if (this.typeComboBox.getModel() == null || this.typeComboBox.getModel().getSize() == 0) {
                IdTitle[] data = new IdTitle[]{new IdTitle(1, "\u041f\u0435\u0440\u0432\u0430\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435"), new IdTitle(2, "\u041f\u0435\u0440\u0432\u0430\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u0443\u0441\u043b\u0443\u0433\u0438")};
                this.typeComboBox.setModel(new DefaultComboBoxModel<IdTitle>(data));
                ArrayList<Service> serList = new ArrayList<Service>();
                for (Service service : this.getServiceDirectory().list()) {
                    if (!service.isUsing() || service.getModuleId() != ((ClientContext)this.getContext()).getModuleId()) continue;
                    serList.add(service);
                }
                this.subscriptionComboBox.setData(serList);
            }
            if (tryAndBuy != null) {
                this.titleTextField.setText(tryAndBuy.getTitle());
                this.subscriptionComboBox.setSelectedItem((Object)this.getServiceDirectory().get(tryAndBuy.getSid()));
                this.typeComboBox.setSelectedId((String)(tryAndBuy.getSid() > 0 ? "" + tryAndBuy.getSid() : "1"));
                String count = (String)tryAndBuy.getParams().get("countDay");
                if (count != null) {
                    this.countDayTextField.setText(count);
                }
                this.isUsed.setSelected(tryAndBuy.isUsed());
            } else {
                this.titleTextField.setText("");
                this.countDayTextField.setText("30");
                this.isUsed.setSelected(true);
            }
            this.table.setEnabled(false);
            this.editor.setVisible(true);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void stopEdit(boolean save) {
        if (save) {
            MegogoTryAndBuy tryAndBuy = (MegogoTryAndBuy)this.model.getSelectedRow();
            if (tryAndBuy == null) {
                tryAndBuy = new MegogoTryAndBuy();
            }
            try {
                if (Utils.isBlankString((String)this.titleTextField.getText())) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
                    return;
                }
                if (Utils.parseInt((String)this.countDayTextField.getText(), (int)-1) < 1) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043a\u043e\u043b-\u0432\u043e \u0434\u043d\u0435\u0439 \u0434\u043b\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0430 try&buy!");
                    return;
                }
                tryAndBuy.setTitle(this.titleTextField.getText());
                tryAndBuy.setSid(((Service)this.subscriptionComboBox.getSelectedItem()).getId());
                tryAndBuy.setType(((IdTitle)this.typeComboBox.getSelectedItem()).getId());
                tryAndBuy.setUsed(this.isUsed.isSelected());
                tryAndBuy.getParams().put("countDay", this.countDayTextField.getText());
                this.getMegogoService().updateTryAndBuy(tryAndBuy);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        this.table.setEnabled(true);
        this.editor.setVisible(false);
        this.performAction("refresh");
    }

    private void setTableData() throws BGException {
        this.model.setData(this.getMegogoService().getTryAndBuyList(false));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionInit((AbstractBGUPanel)this, e -> this.setTableData());
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.setTableData());
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.startEdit(true));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.startEdit(false));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            MegogoTryAndBuy tryAndBuy = (MegogoTryAndBuy)this.model.getSelectedRow();
            if (tryAndBuy == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
                return;
            }
            if (ClientUtils.confirmDelete((Object)tryAndBuy.getTitle())) {
                try {
                    this.getMegogoService().deleteTryAndBuy(tryAndBuy.getId());
                    this.performAction("refresh");
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
    }

    class MegogoTryAndBuyTableModel
    extends BGTableModel<MegogoTryAndBuy> {
        public MegogoTryAndBuyTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", -1, 250, 600, "sid", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", 150, 250, 300, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f", 120, 120, 120, "used", true);
        }

        public Object getValueAt(MegogoTryAndBuy val, int column) throws BGException {
            switch (column) {
                case 2: {
                    Service service = (Service)MegogoTryAndBuySetupTab.this.getServiceDirectory().get(val.getSid());
                    return service == null ? "<\u0423\u0441\u043b\u0443\u0433\u0430 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430>" : service.getTitle();
                }
                case 3: {
                    return val.getTypeTitle();
                }
            }
            return super.getValue((Object)val, column);
        }
    }
}

