/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;

public class UserSession {
    private static UserSession INSTANCE = new UserSession();
    private Map<Integer, Map<String, Object>> map = new HashMap<Integer, Map<String, Object>>();

    private UserSession() {
    }

    public static UserSession getInstance() {
        return INSTANCE;
    }

    private Map<String, Object> getUserMap() {
        ServerContext ctx = (ServerContext)ServerContext.get();
        if (ctx == null) {
            throw new IllegalStateException("not context");
        }
        int userID = ctx.getUserId();
        if (userID <= 0) {
            throw new IllegalStateException("not userID");
        }
        Map<String, Object> userMap = this.map.get(userID);
        if (userMap == null) {
            userMap = new HashMap<String, Object>();
            this.map.put(userID, userMap);
        }
        return userMap;
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.getUserMap().put(name, value);
        }
    }

    public Object getAttribute(String name) {
        return this.getUserMap().get(name);
    }

    public void removeAttribute(String name) {
        this.getUserMap().remove(name);
    }
}

