/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractTariffGroupDao
extends AbstractIdDao<ContractTariffGroup> {
    public ContractTariffGroupDao(Connection con) {
        super(con, 0, "contract_tariff_group");
    }

    public List<ContractTariffGroup> list(int contractId, Date date) throws BGException {
        if (date == null) {
            return super.list("cid=?", "date1", new Object[]{contractId});
        }
        java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
        return super.list("cid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)", "date1", new Object[]{contractId, sqlDate, sqlDate});
    }

    protected ContractTariffGroup getFromRS(ResultSet rs) throws SQLException, BGException {
        return ContractTariffGroup.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setTariffGroupId(rs.getInt("gid")).build();
    }

    protected void updateImpl(ContractTariffGroup contractTariffGroup) throws BGException, SQLException {
        if (contractTariffGroup != null) {
            this.deleteImpl(contractTariffGroup.getContractId());
            if (contractTariffGroup.getTariffGroupId() > 0) {
                try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET gid=?, cid=?");){
                    psInsert.setInt(1, contractTariffGroup.getTariffGroupId());
                    psInsert.setInt(2, contractTariffGroup.getContractId());
                    psInsert.executeUpdate();
                }
            }
        }
    }

    protected int deleteImpl(int contractId) throws BGException, SQLException {
        try (PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE cid=?");){
            psDelete.setInt(1, contractId);
            int n = psDelete.executeUpdate();
            return n;
        }
    }

    protected ContractTariffGroup getImpl(int contractId) throws BGException, SQLException {
        ContractTariffGroup result = null;
        PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE cid=? AND ( date1 is null OR date1 <= curdate() ) AND ( date2 is null OR date2 >= curdate() )");
        ps.setInt(1, contractId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = this.getFromRS(rs);
        }
        rs.close();
        ps.close();
        return result;
    }
}

