/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractParameterGroupName;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractParameterGroupNameDao
extends AbstractIdDao<ContractParameterGroupName> {
    private static long time = 0L;
    private static List<ContractParameterGroupName> list = null;
    private static Map<Integer, ContractParameterGroupName> map = null;

    public ContractParameterGroupNameDao(Connection con) {
        super(con, 0, "contract_parameter_group_name");
    }

    private void init() throws BGException {
        if (list == null || map == null || System.currentTimeMillis() - time > 300000L) {
            map = new HashMap<Integer, ContractParameterGroupName>();
            list = super.list(null, "title", new Object[0]);
            for (ContractParameterGroupName groupName : list) {
                map.put(groupName.getId(), groupName);
            }
            time = System.currentTimeMillis();
        }
    }

    public void reset() {
        time = 0L;
        list = null;
        map = null;
    }

    protected ContractParameterGroupName getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractParameterGroupName contractParameterGroupName = new ContractParameterGroupName();
        contractParameterGroupName.setId(rs.getInt(1));
        contractParameterGroupName.setTitle(rs.getString(2));
        return contractParameterGroupName;
    }

    protected void updateImpl(ContractParameterGroupName contractParameterGroupName) throws BGException, SQLException {
        if (contractParameterGroupName == null) {
            throw new BGIllegalArgumentException();
        }
        if (contractParameterGroupName.getId() < 1) {
            String query = "INSERT INTO " + this.tableName + " SET title=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, contractParameterGroupName.getTitle());
            ps.executeUpdate();
            ps.close();
            contractParameterGroupName.setId(ServerUtils.lastInsertId(this.con));
        } else {
            String query = "UPDATE " + this.tableName + " SET title=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, contractParameterGroupName.getTitle());
            ps.setInt(2, contractParameterGroupName.getId());
            ps.executeUpdate();
        }
        this.reset();
    }

    public ContractParameterGroupName get(int id) throws BGException {
        this.init();
        return map.get(id);
    }

    public List<ContractParameterGroupName> list() throws BGException {
        this.init();
        return list;
    }

    public int delete(int id) throws BGException {
        int result = super.delete(id);
        this.reset();
        return result;
    }
}

