/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.updater.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import ru.bitel.bgbilling.kernel.updater.common.bean.UpdaterTask;
import ru.bitel.common.TimeUtils;

public class UpdaterTaskListRenderer
implements ListCellRenderer<UpdaterTask> {
    private JPanel rendererComponent = null;
    private JLabel idLabel = new JLabel();
    private JLabel dateLabel = new JLabel();
    private JLabel titleLabel = new JLabel();
    private JLabel commentLabel = new JLabel();

    @Override
    public Component getListCellRendererComponent(JList<? extends UpdaterTask> list, UpdaterTask value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel panel = this.getRendererComponent(isSelected);
        this.setPanelData(value);
        Color bgColor = null;
        Color fgColor = null;
        if (isSelected) {
            panel.setBackground(bgColor == null ? list.getSelectionBackground() : bgColor);
            panel.setForeground(fgColor == null ? list.getSelectionForeground() : fgColor);
            this.commentLabel.setBackground(bgColor == null ? list.getSelectionBackground() : bgColor);
        } else {
            panel.setBackground(list.getBackground());
            panel.setForeground(list.getForeground());
            this.commentLabel.setBackground(list.getBackground());
        }
        return panel;
    }

    private JPanel getRendererComponent(boolean isSelected) {
        this.commentLabel.setText("");
        this.commentLabel.setFont(new Font("SansSerif", 2, 11));
        this.commentLabel.setForeground(new Color(150, 150, 150));
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.setOpaque(false);
        titlePanel.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        titlePanel.add((Component)this.dateLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        titlePanel.add((Component)this.idLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 20, 3, 3), 0, 0));
        this.rendererComponent = new JPanel(new GridBagLayout());
        this.rendererComponent.setPreferredSize(new Dimension(500, 100));
        this.rendererComponent.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.rendererComponent.add((Component)this.commentLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 30, 3, 3), 0, 0));
        return this.rendererComponent;
    }

    private void setPanelData(UpdaterTask value) {
        this.titleLabel.setText(value.getTitle());
        this.idLabel.setText((String)(value.getId() > 0 ? " [#" + value.getId() + "]" : ""));
        this.dateLabel.setText("\u0417\u0430\u043f\u0443\u0441\u043a: " + TimeUtils.formatFullDate(value.getRunDate()));
        this.commentLabel.setText("<html>" + value.getComment() + "</html>");
        this.commentLabel.setPreferredSize(new Dimension(550, 50));
    }
}

