/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.FloatTextField;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.common.Utils;

public class ServiceIntervalTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon("bank");
    private JLabel _view = new JLabel();
    private JPanel _editor = new JPanel();
    private FloatTextField _from = new FloatTextField();
    private FloatTextField _to = new FloatTextField();
    private BGComboBox<ComboBoxItem> _limitType = new BGComboBox();

    public ServiceIntervalTariffTreeNode() {
        this._view.setIcon(icon);
        this._from.setColumns(10);
        this._to.setColumns(10);
        this._editor.add(new JLabel("\u043e\u0442: "));
        this._editor.add(this._from);
        this._editor.add(new JLabel(" \u0434\u043e: "));
        this._editor.add(this._to);
        this._editor.add(new JLabel(" "));
        this._editor.add(this._limitType);
        this.initLimitTypeCombo();
    }

    private void initLimitTypeCombo() {
        this._limitType.addItem(new ComboBoxItem("", "KB"));
        this._limitType.addItem(new ComboBoxItem("", "MB"));
        this._limitType.addItem(new ComboBoxItem("", "GB"));
        this._limitType.addItem(new ComboBoxItem("", "\u043c\u0438\u043d\u0443\u0442"));
        this._limitType.addItem(new ComboBoxItem("", "\u0447\u0430\u0441\u043e\u0432"));
    }

    @Override
    protected JPanel getEditorPanel() {
        return this._editor;
    }

    @Override
    public Component getView() {
        return this._view;
    }

    @Override
    protected void loadData() {
        Map<String, String> data = this.getDataInHash();
        String from = data.get("from");
        String to = data.get("to");
        int pos = Utils.parseInt(data.get("type"), 0);
        this._limitType.setSelectedIndex(pos);
        this._from.setText(from);
        this._to.setText(to);
    }

    private void updateView() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._from.getText());
        sb.append(" - ");
        sb.append(this._to.getText());
        ComboBoxItem item = this._limitType.getSelectedItem();
        if (item != null) {
            sb.append(item.toString());
        }
        this._view.setText(sb.toString());
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("type", String.valueOf(this._limitType.getSelectedIndex()));
        data.put("from", this._from.getText());
        data.put("to", this._to.getText());
        this.setDataInHash(data);
        this.updateView();
    }

    @Override
    public void setData(String data) {
        super.setData(data);
        this.loadData();
        this.updateView();
    }
}

