/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.nas;

import java.net.InetAddress;
import java.sql.Connection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionListener;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasDialup;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasManager;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public abstract class NasList<C extends NasConnection<?>, N extends Nas<C, ?, ?>> {
    private static final Logger logger = LogManager.getLogger();
    private final ConcurrentMap<Integer, N> nasID = new ConcurrentHashMap<Integer, N>();
    private final ConcurrentMap<InetAddress, N> nasIP = new ConcurrentHashMap<InetAddress, N>();
    private final ConcurrentMap<String, N> nasIdentifier = new ConcurrentHashMap<String, N>();

    protected abstract N newNas(DefaultServerSetup var1, int var2, RadiusProcessor<C, N, ?> var3, int var4, N var5, InetAddress var6, String var7, int var8, ParameterMap var9, byte[] var10, ConcurrentMap<Object, C> var11, String var12, NasConnectionInspector var13, Object ... var14);

    public synchronized void load(DefaultServerSetup setup, RadiusProcessor<C, N, ?> processor, Connection con, int moduleId) {
        logger.info("Loading NAS list...");
        long start = System.currentTimeMillis();
        try {
            NasManager nasManager = new NasManager(con, moduleId);
            for (NasDialup nas : nasManager.getNasList(new GregorianCalendar())) {
                try {
                    logger.info("Load NAS: " + nas.toString());
                    nasManager.setNasConfig(nas);
                    int id = nas.getId();
                    long nasIPLong = nas.getIpAddress();
                    byte[] nasIP = new byte[]{(byte)(nasIPLong >> 24 & 0xFFL), (byte)(nasIPLong >> 16 & 0xFFL), (byte)(nasIPLong >> 8 & 0xFFL), (byte)(nasIPLong & 0xFFL)};
                    String nasIdentifier = nas.getIdentifier();
                    byte[] secret = nas.getSecret().getBytes();
                    int vendor = nas.getVendor();
                    String script = nas.getScript();
                    InetAddress nasIPAddress = InetAddress.getByAddress(nasIP);
                    this.setNas(setup, moduleId, processor, id, nasIPAddress, nasIdentifier, secret, vendor, nas.getConfigString(), script, new Object[0]);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("NAS list loading completed for " + (System.currentTimeMillis() - start) + " ms");
    }

    public synchronized void setNas(DefaultServerSetup setup, int moduleId, RadiusProcessor<C, N, ?> processor, int id, InetAddress nasIPAddress, String nasIdentifier, byte[] secret, int vendor, String configString, String script, Object ... params) {
        this.setNas(setup, moduleId, processor, id, nasIPAddress, nasIdentifier, secret, vendor, new Preferences(configString, "\r\n"), script, params);
    }

    public synchronized void setNas(DefaultServerSetup setup, int moduleId, RadiusProcessor<C, N, ?> processor, int id, InetAddress nasIPAddress, String nasIdentifier, byte[] secret, int vendor, ParameterMap _config, String script, Object ... params) {
        NasConnectionInspector inspector;
        ParameterMap config = setup.inherit(_config);
        Nas oldNas = (Nas)this.nasID.get(id);
        if (oldNas == null) {
            oldNas = (Nas)this.nasIdentifier.get(nasIdentifier);
        }
        NasConnectionInspector oldInspector = oldNas != null ? oldNas.inspector : null;
        ConcurrentHashMap connections = oldNas != null ? oldNas.connections : new ConcurrentHashMap(256);
        String inspectorClassName = config.get("nas.inspector.class", null);
        if (Utils.notBlankString(inspectorClassName)) {
            NasConnectionInspector insp;
            try {
                insp = NasConnectionInspector.newInstance(inspectorClassName, setup, nasIPAddress, secret, Collections.unmodifiableMap(connections), config, oldInspector);
            }
            catch (Throwable e) {
                insp = null;
                logger.error(e.getMessage(), e);
            }
            inspector = insp;
        } else {
            inspector = null;
        }
        Nas nas = this.newNas(setup, moduleId, processor, id, oldNas, nasIPAddress, nasIdentifier, vendor, config, secret, connections, script, inspector, params);
        this.nasID.put(nas.getId(), nas);
        this.nasIdentifier.put(nas.getNasIdentifier(), nas);
        if (nas.getNasIPAddress() != null) {
            this.nasIP.put(nas.getNasIPAddress(), nas);
        }
        if (oldInspector != null) {
            if (inspector != null) {
                oldInspector.addListener(new NasConnectionListener(){

                    @Override
                    public void notKilled(NasConnection<?> con) {
                        inspector.kill(con);
                    }

                    @Override
                    public void notModified(NasConnection<?> con) {
                        inspector.modify(con);
                    }
                });
            }
            oldInspector.destroy();
        }
        if (inspector != null) {
            inspector.init(nas);
        }
        if (oldNas != null) {
            oldNas.destroy();
        }
        logger.info("LOADED NAS: " + nas.toString() + "\nCONFIG:\n" + _config);
    }

    public N get(String nasIdentifier) {
        return (N)((Nas)this.nasIdentifier.get(nasIdentifier));
    }

    public N get(InetAddress ip) {
        return (N)((Nas)this.nasIP.get(ip));
    }

    public N get(int id) {
        return (N)((Nas)this.nasID.get(id));
    }

    public Iterable<N> nases() {
        return this.nasID.values();
    }

    public Iterable<C> connections() {
        return new Iterable<C>(){

            @Override
            public Iterator<C> iterator() {
                class Iter
                implements Iterator<C> {
                    private final Iterator<N> nasIterator;
                    private Iterator<C> nasConnections;
                    private C next;

                    Iter() {
                        this.nasIterator = NasList.this.nasID.values().iterator();
                        this.nasConnections = this.nasIterator.hasNext() ? ((Nas)this.nasIterator.next()).connections.values().iterator() : null;
                        this.advance();
                    }

                    private void advance() {
                        while (this.nasConnections != null) {
                            if (this.nasConnections.hasNext()) {
                                this.next = (NasConnection)this.nasConnections.next();
                                break;
                            }
                            this.next = null;
                            this.nasConnections = this.nasIterator.hasNext() ? ((Nas)this.nasIterator.next()).connections.values().iterator() : null;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public C next() {
                        Object next = this.next;
                        this.advance();
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new Iter();
            }
        };
    }
}

