/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.tariff.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.AbstractPhoneServiceCost;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.AbstractPhoneTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.common.ParameterMap;

public class PrefixPartTariffTreeNode
extends DefaultTariffTreeNode<AbstractPhoneTariffRequest<AbstractPhoneServiceCost>, TariffContext> {
    private final Pattern pattern;
    private final int dest;
    private final int zone;

    public PrefixPartTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        Pattern pattern = null;
        String prefix = parameterMap.get("prefix", null);
        if (prefix != null) {
            try {
                pattern = Pattern.compile("^(" + prefix + ")");
            }
            catch (Exception ex) {
                System.err.println("Error prefix compile: " + prefix);
            }
        }
        this.pattern = pattern;
        this.dest = parameterMap.getInt("dest", 0);
        this.zone = parameterMap.getInt("zone", 0);
    }

    @Override
    protected int executeImpl(Long treeNodeId, AbstractPhoneTariffRequest<AbstractPhoneServiceCost> req, TariffContext context) {
        if (req.phoneTo != null && this.pattern != null && !req.isAccepted()) {
            Matcher m;
            String phoneRest = req.phoneToRest;
            if (phoneRest == null) {
                phoneRest = req.phoneTo;
            }
            if ((m = this.pattern.matcher(phoneRest)).find()) {
                String eqPart = m.group(0);
                req.phoneToRest = phoneRest = phoneRest.substring(eqPart.length());
                if (this.dest > 0) {
                    req.dest = this.dest;
                }
                if (this.zone > 0) {
                    req.zone = this.zone;
                }
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected int postExecuteImpl(Long treeNodeId, AbstractPhoneTariffRequest<AbstractPhoneServiceCost> req, TariffContext ctx, int executeResult) {
        if (executeResult == 1) {
            req.setAccepted(true);
        }
        return executeResult;
    }
}

