/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client;

import jakarta.xml.ws.soap.SOAPFaultException;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.common.client.LookAndFeelUtils;
import ru.bitel.common.localize.Localizer;

public class BGClientInit {
    private static boolean isMacOs;
    private static boolean isLinux;
    private static String clientVersion;

    public static final boolean isMacOs() {
        return isMacOs;
    }

    public static final boolean isLinux() {
        return isLinux;
    }

    public static String getClientVersion() {
        return clientVersion;
    }

    public static void setClientVersion(String clientVersion) {
        BGClientInit.clientVersion = clientVersion;
    }

    public static final void mainInit(String[] args) {
        String bundleName = "client";
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if (arg.toLowerCase().startsWith("clientversion=")) {
                    clientVersion = arg.substring(14);
                    continue;
                }
                bundleName = arg;
            }
        }
        ClientSetup.initSetup(BGClientBase.class.getResource("/" + bundleName + ".properties"));
        ClientSetup setup = ClientSetup.getInstance();
        Localizer.initLocales(setup);
        try {
            String laf = setup.get(LookAndFeelUtils.class.getName() + ".laf", setup.get("look.and.feel.default", System.getProperty("look.and.feel.default", "javax.swing.plaf.metal.MetalLookAndFeel")));
            String lafTheme = setup.get(LookAndFeelUtils.class.getName() + ".lafTheme", setup.get("look.and.feel.default.theme", System.getProperty("look.and.feel.default.theme", "")));
            LookAndFeelUtils.setTheme(laf, lafTheme);
            if (BGClientInit.isMacOs() && LookAndFeelUtils.getCurrent().getLafClass().getName().equals("com.apple.laf.AquaLookAndFeel")) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int fontSize = setup.getInt(LookAndFeelUtils.class.getName() + ".minfont", setup.getInt("look.and.feel.minfont", 0));
        LookAndFeelUtils.minFontSize(-fontSize);
    }

    public static void init_UncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof SOAPFaultException) {
                    SOAPFaultException exception = (SOAPFaultException)e;
                    String message = exception.getFault().getFaultString();
                    if (Utils.isEmptyString(message)) {
                        message = e.getCause().getLocalizedMessage();
                    }
                    if (Utils.isEmptyString(message)) {
                        message = e.getCause().getClass().getName();
                    }
                    ClientUtils.showErrorMessageDialog(message);
                    return;
                }
                if (e instanceof BGException) {
                    ClientUtils.showErrorMessageDialog(e.getLocalizedMessage());
                    return;
                }
                if (e instanceof Error) {
                    ClientUtils.showErrorMessageDialog(e.getLocalizedMessage());
                }
                System.err.print("Exception in thread \"" + t.getName() + "\" ");
                e.printStackTrace(System.err);
            }
        });
    }

    static {
        clientVersion = "";
        String osName = System.getProperty("os.name");
        isMacOs = "Mac OS X".equalsIgnoreCase(osName);
        isLinux = "Linux".equalsIgnoreCase(osName);
    }
}

