/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import ru.bitel.bgbilling.client.common.AbstractTabPanel;
import ru.bitel.bgbilling.client.common.BGServiceConfig;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.common.Utils;

public class BGTabbedPane
extends JTabbedPane {
    public BGTabbedPane() {
    }

    public BGTabbedPane(int tabPlacement) {
        super(tabPlacement);
    }

    public BGTabPanel getTab(String tabId) {
        for (JPanel comp : this.getTabs()) {
            BGTabPanel panel;
            if (!(comp instanceof BGTabPanel) || !tabId.equals((panel = (BGTabPanel)comp).getTabId())) continue;
            return panel;
        }
        return null;
    }

    public final BGTabPanel addTab(BGTabPanel tabPanel) {
        if (tabPanel != null) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                Component component = this.getComponentAt(i);
                if (!(component instanceof BGTabPanel)) continue;
                BGTabPanel pan = (BGTabPanel)component;
                if (!tabPanel.getTabId().equals(pan.getTabId())) continue;
                this.setSelectedIndex(i);
                return pan;
            }
            super.addTab(tabPanel.getTabTitle(), tabPanel);
            this.setSelectedIndex(this.getTabCount() - 1);
            tabPanel.init(tabPanel.getModule(), tabPanel.getModuleId());
            tabPanel.onOpening();
        }
        return tabPanel;
    }

    public final <T extends AbstractTabPanel> T addTab(String tabId, Class<T> clazz) {
        AbstractTabPanel tabPanel = null;
        if (tabId != null && clazz != null) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                Component component = this.getComponentAt(i);
                if (!(component instanceof AbstractTabPanel) || !tabId.equals(((AbstractTabPanel)((Object)component)).getTabId())) continue;
                this.setSelectedIndex(i);
                tabPanel = (AbstractTabPanel)((Object)component);
                break;
            }
            if (tabPanel == null) {
                try {
                    tabPanel = (AbstractTabPanel)Utils.newInstance(clazz.getName(), clazz);
                }
                catch (BGException e) {
                    e.printStackTrace();
                    ClientUtils.showErrorMessageDialog("\u0421\u0431\u043e\u0439! \u0421\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c!");
                }
                super.addTab(tabPanel.getTabTitle(), (Component)((Object)tabPanel));
                if (tabPanel instanceof BGTabPanel) {
                    ((BGTabPanel)tabPanel).init(((BGTabPanel)tabPanel).getModule(), 0);
                }
                this.setSelectedIndex(this.getTabCount() - 1);
            }
        }
        return (T)tabPanel;
    }

    public final ContractEditor addContractEditorTab(int contractId) {
        ContractEditor panel = null;
        String tabId = "contract_" + contractId;
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component component = this.getComponentAt(i);
            if (!(component instanceof ContractEditor) || !tabId.equals(((ContractEditor)component).getTabId())) continue;
            panel = (ContractEditor)component;
        }
        if (panel == null) {
            panel = new ContractEditor(contractId);
            this.addTab(panel.getTabTitle(), (AbstractTabPanel)panel);
            panel.onOpening();
        }
        this.setSelectedComponent(panel);
        return panel;
    }

    public final <T extends AbstractTabPanel> T addTab(String tabID, T panel) {
        if (panel != null) {
            boolean found = false;
            for (int i = 0; i < this.getTabCount(); ++i) {
                Component component = this.getComponentAt(i);
                if (!(component instanceof AbstractTabPanel) || !(found = tabID.equals(((AbstractTabPanel)((Object)component)).getTabId()))) continue;
                panel = (AbstractTabPanel)((Object)component);
                break;
            }
            if (!found) {
                super.addTab(panel.getTabTitle(), (Component)panel);
            }
            this.setSelectedComponent((Component)panel);
        }
        return panel;
    }

    public final Component getSelectedTab() {
        if (this.getTabCount() == 0) {
            return null;
        }
        return this.getSelectedComponent();
    }

    public final void setSelectedTab(BGTabPanel tab) {
        this.setSelectedComponent(tab);
    }

    public final JPanel[] getTabs() {
        int count = this.getTabCount();
        JPanel[] result = new JPanel[count];
        for (int i = 0; i < count; ++i) {
            JPanel panel = (JPanel)this.getComponentAt(i);
            if (panel == null) continue;
            result[i] = panel;
        }
        return result;
    }

    public final void removeSelectedTab() {
        if (this.getSelectedIndex() > -1) {
            this.removeTab(this.getSelectedTab());
        }
    }

    public final void removeTab(Component panel) {
        if (panel instanceof AbstractTabPanel ? !((AbstractTabPanel)((Object)panel)).onClosing() : panel instanceof BGServiceConfig && !((AbstractTabPanel)((Object)panel)).onClosing()) {
            return;
        }
        this.remove(panel);
    }

    public final void setTabTitle(JPanel panel, String title) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!panel.equals(this.getComponentAt(i))) continue;
            this.setTitleAt(i, title);
            break;
        }
    }

    public final void setTabIcon(JPanel panel, Icon icon) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!panel.equals(this.getComponentAt(i))) continue;
            this.setIconAt(i, icon);
            break;
        }
    }

    @Override
    public void removeTabAt(int index) {
        Component component = this.getComponentAt(index);
        if (component instanceof AbstractTabPanel ? !((AbstractTabPanel)((Object)component)).onClosing() : component instanceof BGServiceConfig && !((AbstractTabPanel)((Object)component)).onClosing()) {
            return;
        }
        super.removeTabAt(index);
    }

    protected void addCopyTab(JPanel newTab) {
        if (newTab instanceof BGTabPanel) {
            super.addTab(((BGTabPanel)newTab).getTabTitle(), newTab);
        } else if (newTab instanceof BGUTabPanel) {
            super.addTab(((BGUTabPanel)newTab).getTabTitle(), newTab);
        }
    }
}

