/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.ipn.server.DHCPGateWorker;
import ru.bitel.bgbilling.modules.ipn.server.PPPoEGateWorker;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateFilter;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateTypeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRule;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRuleManager;

public class ActionGateInfo
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        GateFilter filter = new GateFilter();
        filter.parseFromRequest(this.request);
        filter.setLoadParents(true);
        Set<Integer> usedGates = this.getUsedGates();
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        GateManager gm = new GateManager(this.con, this.mid);
        Gate root = gm.getGateTree(filter);
        Map<Integer, GateType> typeMap = new GateTypeManager(this.con, this.mid).getTypeMap();
        this.build(root.getChildren(), data, typeMap, usedGates);
    }

    protected Set<Integer> getUsedGates() throws SQLException {
        HashSet<Integer> usedGates = null;
        if (this.cid > 0) {
            usedGates = new HashSet<Integer>();
            UserGateRuleManager ugrm = new UserGateRuleManager(this.con, this.mid);
            for (UserGateRule ugr : ugrm.getUserGateRules(this.cid)) {
                usedGates.add(ugr.getGateId());
            }
        }
        return usedGates;
    }

    private void build(List<Gate> gateList, Element parent, Map<Integer, GateType> typeMap, Set<Integer> usedGates) {
        if (gateList != null) {
            for (Gate gate : gateList) {
                GateType type;
                Element row = this.createElement(parent, "row");
                row.setAttribute("id", String.valueOf(gate.getId()));
                row.setAttribute("host", gate.getHost());
                row.setAttribute("port", String.valueOf(gate.getPort()));
                row.setAttribute("address", gate.getAddress().getAddress());
                row.setAttribute("comment", gate.getComment());
                row.setAttribute("parent_id", String.valueOf(gate.getParentId()));
                if (usedGates != null && usedGates.contains(gate.getId())) {
                    row.setAttribute("is_used", "1");
                }
                if ((type = typeMap.get(gate.getTypeId())) != null) {
                    row.setAttribute("type", type.getTitle());
                    row.setAttribute("typeId", String.valueOf(type.getId()));
                    if (PPPoEGateWorker.class.getName().equals(type.getGateManager())) {
                        row.setAttribute("typeName", "RadiusPPPoE");
                    } else if (DHCPGateWorker.class.getName().equals(type.getGateManager())) {
                        row.setAttribute("typeName", "DHCP");
                    }
                } else if (gate.getTypeId() == 0) {
                    row.setAttribute("typeId", "0");
                } else {
                    row.setAttribute("type", "???");
                }
                this.build(gate.getChildren(), row, typeMap, usedGates);
            }
        }
    }
}

