/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean.pattern;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.AbstractDocumentProcessor;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentProcessor;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocxDocumentProcessor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class OdtDocumentProcessor
extends AbstractDocumentProcessor
implements DocumentProcessor {
    private static final Logger logger = LogManager.getLogger();
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.documents");
    private DocxDocumentProcessor docxProcessor;

    public OdtDocumentProcessor(Connection con, Document document, DocumentPattern pattern, Map<String, Object> varData, Map<String, List<Map<String, String>>> tableData) {
        this.document = document;
        this.con = con;
        this.docxProcessor = new DocxDocumentProcessor(con, document, pattern, varData, tableData);
    }

    @Override
    public File process(FileInputStream patternInputStream) throws BGException {
        File result = null;
        try {
            logger.debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 ODT-\u0448\u0430\u0431\u043b\u043e\u043d\u0430");
            String odtTmpFilePath = Setup.getSetup().getTempDirPath() + "file" + this.document.getContractId() + ".odt";
            File odtFile = new File(odtTmpFilePath);
            if (!odtFile.exists()) {
                odtFile.createNewFile();
            }
            try (FileOutputStream fos = new FileOutputStream(odtFile);){
                Utils.flush((InputStream)patternInputStream, (OutputStream)fos);
            }
            String libreExecuteFile = this.plugin.getSetup().get("libre.path", "libreoffice");
            logger.debug("\t\u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 odt->docx");
            Runtime.getRuntime().exec(libreExecuteFile + " --headless --convert-to docx " + odtFile.getAbsolutePath() + " --outdir " + Setup.getSetup().getTempDirPath());
            String docxTmpFilePath = Setup.getSetup().getTempDirPath() + "file" + this.document.getContractId() + ".docx";
            File docxFile = new File(docxTmpFilePath);
            while (!docxFile.exists()) {
            }
            FileInputStream docxInputStream = new FileInputStream(docxFile);
            File generatedDocxFile = this.docxProcessor.process(docxInputStream);
            logger.debug("\t\u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 docx->odt");
            Runtime.getRuntime().exec(libreExecuteFile + " --headless --convert-to odt " + generatedDocxFile.getAbsolutePath() + " --outdir " + Setup.getSetup().getTempDirPath());
            result = new File(Setup.getSetup().getTempDirPath() + "tmp" + this.document.getContractId() + ".odt");
            while (!result.exists()) {
            }
            logger.debug("\t\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u043d\u0443\u0436\u043d\u044b\u0445 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432");
            odtFile.delete();
            docxFile.delete();
            generatedDocxFile.delete();
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

