/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.MathContext;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvApplication;
import ru.bitel.common.sql.ConnectionSet;

public class TvTariffContext
extends TariffContext {
    private final TvTariffMode mode;
    private final int moduleId;
    private final TvAccountSpecRuntimeMap tvAccountSpecRuntimeMap;
    private final TvAccountRuntimeMap tvAccountRuntimeMap;

    public TvTariffContext(TvApplication tvApplication, ConnectionSet connectionSet, int moduleId, Date fromTime, TvTariffMode mode) throws BGException {
        super(MathContext.DECIMAL64, fromTime);
        this.mode = mode;
        this.moduleId = moduleId;
        if (tvApplication != null) {
            this.tvAccountSpecRuntimeMap = tvApplication.tvAccountSpecRuntimeMap;
            this.tvAccountRuntimeMap = tvApplication.tvAccountRuntimeMap;
        } else {
            this.tvAccountSpecRuntimeMap = TvAccountSpecRuntimeMap.getInstance(connectionSet, moduleId);
            this.tvAccountRuntimeMap = new TvAccountRuntimeMap(moduleId, ContractRuntimeMap.getInstance(), fromTime);
        }
    }

    public TvTariffContext(ConnectionSet connectionSet, int moduleId, Date fromTime, TvTariffMode mode) throws BGException {
        this(null, connectionSet, moduleId, fromTime, mode);
    }

    public TvTariffMode getTariffMode() {
        return this.mode;
    }

    public TvAccountSpecRuntimeMap getTvAccountSpecRuntimeMap() {
        return this.tvAccountSpecRuntimeMap;
    }

    public TvAccountRuntimeMap getTvAccountRuntimeMap() {
        return this.tvAccountRuntimeMap;
    }

    public boolean isProlongation() {
        return this.mode == TvTariffMode.realtime || this.mode == TvTariffMode.scheduler;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public static enum TvTariffMode {
        realtime,
        scheduler,
        recalculate,
        precalculate;

    }
}

