/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDeviceMap;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDeviceType;
import ru.bitel.bgbilling.modules.tv.common.event.access.manage.TvDeviceManageEvent;
import ru.bitel.bgbilling.modules.tv.common.service.TvDeviceService;
import ru.bitel.bgbilling.modules.tv.server.bean.TvDeviceDao;
import ru.bitel.bgbilling.modules.tv.server.bean.TvDeviceTypeDao;
import ru.bitel.bgbilling.modules.tv.server.event.TvReloadEvent;
import ru.bitel.common.Utils;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceTypeDao;
import ru.bitel.oss.systems.inventory.resource.server.service.AbstractDeviceServiceImpl;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.tv.common.service.TvDeviceService")
public class TvDeviceServiceImpl
extends AbstractDeviceServiceImpl<TvDevice, TvDeviceType>
implements TvDeviceService {
    private Directory<TvDeviceType> tvDeviceTypeDirectory;
    private TvDeviceTypeDao tvDeviceTypeDao;
    private TvDeviceDao tvDeviceDao;

    @PostConstruct
    protected void init() throws BGException {
        super.init();
    }

    protected Directory<TvDeviceType> getDeviceTypeDirectory() throws BGException {
        if (this.tvDeviceTypeDirectory == null) {
            this.tvDeviceTypeDirectory = this.context.getDirectory(TvDeviceType.class, this.moduleId);
        }
        return this.tvDeviceTypeDirectory;
    }

    protected DeviceTypeDao<TvDeviceType> getDeviceTypeDao() throws BGException {
        if (this.tvDeviceTypeDao == null) {
            this.tvDeviceTypeDao = new TvDeviceTypeDao(this.getConnection(), this.moduleId);
        }
        return this.tvDeviceTypeDao;
    }

    private TvDeviceDao getTvDeviceDao() throws BGException {
        if (this.tvDeviceDao == null) {
            this.tvDeviceDao = new TvDeviceDao(this.getConnection(), this.moduleId);
        }
        return this.tvDeviceDao;
    }

    protected DeviceDao<TvDevice, TvDeviceType> getDeviceDao() throws BGException {
        return this.getTvDeviceDao();
    }

    public TvDeviceType deviceTypeGet(int id) throws BGException {
        return (TvDeviceType)this.getDeviceTypeDirectory().get(id);
    }

    public TvDevice deviceGet(int id) throws BGException {
        return (TvDevice)this.getDeviceDao().get(id);
    }

    public int deviceUpdate(TvDevice device) throws BGException {
        if (device == null) {
            throw new BGIllegalArgumentException("device");
        }
        TvDeviceType tvDeviceType = null;
        if (device.getDeviceTypeId() > 0 && (tvDeviceType = (TvDeviceType)this.getDeviceTypeDirectory().get(device.getDeviceTypeId())) == null) {
            throw new BGIllegalArgumentException("device.deviceTypeId");
        }
        if (device.getTitle() == null) {
            device.setTitle(Device.generateTitle((Device)device, (DeviceType)tvDeviceType));
        }
        device.setIdentifier(Utils.maskNull((String)device.getIdentifier()));
        device.setHost(Utils.maskNull((String)device.getHost()));
        device.setUsername(Utils.maskNull((String)device.getUsername()));
        device.setPassword(Utils.maskNull((String)device.getPassword()));
        device.setSecret(Utils.maskNull((String)device.getSecret()));
        device.setConfig(Utils.maskNull((String)device.getConfig()));
        device.setComment(Utils.maskNull((String)device.getComment()));
        this.getDeviceDao().update((Device)device);
        return device.getId();
    }

    public void deviceReload() throws BGException {
        EventProcessor.getInstance().publish((Event)new TvReloadEvent(this.moduleId, this.userId));
    }

    public String deviceConfigPreview(int id) throws BGException {
        TvDeviceMap deviceMap = TvDeviceMap.getInstance((int)this.moduleId);
        TvDeviceMap.TvDeviceMapItem device = deviceMap.get(id);
        if (device == null) {
            return "";
        }
        return String.valueOf(device.getConfig());
    }

    public String deviceManage(int id, String operation, int servId, int connectionId, long timeout) throws BGException, BGMessageException, BGIllegalAccessException {
        timeout = timeout <= 0L ? 30000L : Math.max(Math.min(timeout, TimeUnit.MINUTES.toMillis(5L)), TimeUnit.SECONDS.toMillis(10L));
        TvDeviceManageEvent e = new TvDeviceManageEvent(this.moduleId, this.userId, id, operation, servId, connectionId);
        e = (TvDeviceManageEvent)EventProcessor.getInstance().request((Event)e, 20000L);
        if (e == null) {
            throw new BGMessageException("\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e Access \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442.");
        }
        return String.valueOf(e.getResult());
    }

    public boolean deviceTreeReorder(int srcDeviceId, int tgtDeviceId, int step) throws BGException {
        return false;
    }
}

