/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.tariff;

import java.math.MathContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.subscription.common.bean.SubscriptionType;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionDao;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionTypeDao;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class SubscriptionTariffContext
extends TariffContext {
    static final Logger logger = LogManager.getLogger();
    private final DefaultServerSetup setup;
    private List<Integer> contractIds;
    private List<Integer> contractLabelIds;
    private final Calendar monthStart;
    private Map<Integer, Set<Integer>> subscriptionTypeNoSuspend = new HashMap<Integer, Set<Integer>>();

    public SubscriptionTariffContext(DefaultServerSetup setup, Connection con, int moduleId, MathContext mc, Calendar fromTime, List<Integer> contractIds, List<Integer> contractLabelIds) throws BGException {
        super(MathContext.DECIMAL64, fromTime.getTime(), false, moduleId);
        this.setup = setup;
        this.monthStart = fromTime;
        this.contractIds = contractIds;
        this.contractLabelIds = contractLabelIds;
        try (SubscriptionDao subscriptionDao = new SubscriptionDao(con, moduleId, 0);
             SubscriptionTypeDao subscriptionTypeDao = new SubscriptionTypeDao(con, moduleId);){
            List statusList = StatusCache.getInstance().getStatusList();
            List<SubscriptionType> subscriptionTypes = subscriptionTypeDao.list();
            Boolean[][] values = subscriptionDao.getSubscriptionStatusValues(subscriptionTypes.stream().map(a -> a.getId()).collect(Collectors.toList()), statusList.stream().map(a -> a.getId()).collect(Collectors.toList()), true);
            int l2 = statusList.size();
            for (int i2 = 0; i2 < l2; ++i2) {
                HashSet<Integer> subscriptionTypeSet = new HashSet<Integer>();
                int l1 = subscriptionTypes.size();
                for (int i1 = 0; i1 < l1; ++i1) {
                    if (values[i1][i2] == null || !values[i1][i2].booleanValue()) continue;
                    subscriptionTypeSet.add(subscriptionTypes.get(i1).getId());
                }
                if (subscriptionTypeSet.isEmpty()) continue;
                this.subscriptionTypeNoSuspend.put(((Status)statusList.get(i2)).getId(), subscriptionTypeSet);
            }
        }
        this.loadSuspendMap(con);
    }

    public DefaultServerSetup getSetup() {
        return this.setup;
    }

    public Calendar getMonthStart() {
        return this.monthStart;
    }

    private void loadSuspendMap(Connection con) {
        HashMap suspendMap = new HashMap();
        Set suspendStatusSet = StatusCache.getInstance().getModuleSuspendStatusSet(this.moduleId);
        if (suspendStatusSet.size() > 0) {
            try {
                String contractJoin = "";
                if ((this.contractIds == null || this.contractIds.isEmpty()) && this.contractLabelIds != null && !this.contractLabelIds.isEmpty()) {
                    contractJoin = " INNER JOIN contract ON contract.id=status.cid ";
                }
                String query = "SELECT status.cid, status.date1, status.date2, status.status FROM contract_status AS status LEFT JOIN contract_module ON status.cid=contract_module.cid " + contractJoin + "WHERE (status.date1 IS NULL OR status.date1<=?) AND (status.date2 IS NULL OR status.date2>=?) AND contract_module.mid=" + this.moduleId;
                if (this.contractIds != null && !this.contractIds.isEmpty()) {
                    query = query + " AND status.cid IN (" + Utils.toString(this.contractIds) + ")";
                } else if (this.contractLabelIds != null && !this.contractLabelIds.isEmpty()) {
                    query = query + " AND contract.id IN (SELECT cll.contract_id FROM contract_label_link AS cll WHERE label_id IN ( " + Utils.toString(this.contractLabelIds) + " ))";
                }
                query = query + " ORDER BY status.cid, status.date1";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)this.monthStart));
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.monthStart));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    ArrayList<Period> periodList;
                    int cid = rs.getInt(1);
                    Period period = new Period(this.trimByMonthStart(rs.getDate(2)), this.trimByMonthEnd(rs.getDate(3)));
                    int status = rs.getInt(4);
                    HashMap<Integer, ArrayList<Period>> contactSuspendMap = (HashMap<Integer, ArrayList<Period>>)suspendMap.get(cid);
                    if (contactSuspendMap == null) {
                        contactSuspendMap = new HashMap<Integer, ArrayList<Period>>(2);
                        suspendMap.put(cid, contactSuspendMap);
                    }
                    if ((periodList = (ArrayList<Period>)contactSuspendMap.get(status)) == null) {
                        periodList = new ArrayList<Period>(2);
                        contactSuspendMap.put(status, periodList);
                    }
                    periodList.add(period);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Date trimByMonthEnd(Date date) {
        if (date == null || TimeUtils.dateBefore((Date)this.monthStart.getTime(), (Date)date)) {
            date = ((Calendar)this.monthStart.clone()).getTime();
        }
        return date;
    }

    private Date trimByMonthStart(Date date1) {
        if (date1 == null || TimeUtils.dateBefore((Date)date1, (Date)this.monthStart.getTime())) {
            date1 = ((Calendar)this.monthStart.clone()).getTime();
        }
        return date1;
    }
}

