/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client.upload.elkom;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import ru.bitel.bgbilling.modules.sorm.client.SormSettingsPanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.ConditionPanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.DirectoryConfigurePanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.SormRatioPanel;
import ru.bitel.bgbilling.modules.sorm.common.bean.Ratio;
import ru.bitel.bgbilling.modules.sorm.common.bean.RatioDescription;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.upload.elkom.ElkomPaymentType;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.ListItem;

public class ElkomDirectoryConfigurePanel
extends DirectoryConfigurePanel {
    private SormRatioPanel ratioPanel = new SormRatioPanel("<html>\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u043e\u043e\u0442\u043d\u0435\u0441\u0442\u0438 \u0442\u0438\u043f\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430<br>\u0441 \u0442\u0438\u043f\u0430\u043c\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0421\u041e\u0420\u041c</html>");

    public ElkomDirectoryConfigurePanel(SormSettingsPanel parent, SormProject sormProject) {
        super(parent, sormProject);
        this.init();
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.payType = new ConditionPanel("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
        this.initPayType();
        this.payType.getDetailPanel().add((Component)((Object)this.ratioPanel), this.constraints);
        this.ratioPanel.setDataSelectionList(this.getDataForListSelection());
        JPanel directoryItems = new JPanel(new GridBagLayout());
        directoryItems.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 2, true), "\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438"));
        directoryItems.add((Component)this.payType, this.constraints);
        this.add(directoryItems, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(3, 3, 0, 0), 0, 0));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.sormProject == null || Utils.isBlankString((String)this.sormProject.getConfig())) {
                return;
            }
            this.config = this.sormProject.getLoadedConfig();
            if (this.config == null || this.config.getMap().size() == 0) {
                return;
            }
            if ("1".equals(this.config.get("sorm.upload.paytype.enable"))) {
                this.payType.setEnabled(true);
                this.setPaymentTypeUpload(this.config);
            }
        });
    }

    private List<ListItem> getDataForListSelection() {
        ArrayList<ListItem> result = new ArrayList<ListItem>();
        for (final ElkomPaymentType type : ElkomPaymentType.values()) {
            result.add(new ListItem(){

                public int getId() {
                    return type.getCode();
                }

                public String getTitle() {
                    return type.getDescription();
                }
            });
        }
        return result;
    }

    @Override
    public void buildConfig(Preferences config) {
        config.set("sorm.upload.paytype.enable", this.payType.isEnable() ? "1" : "0");
        if (this.payType.isEnable()) {
            config.set("sorm.upload.paytype", Utils.toString(this.getPaymentTypeUpload(), (String)","));
            this.setPaymentRatio(config);
        }
    }

    @Override
    public void reloadRatioPaymentsPanel(Preferences config) {
        Map ratioMap;
        ParameterMap parameterMap = null;
        if (config != null && (ratioMap = config.subKeyed("sorm.upload.paytype.ratio")).size() > 0) {
            parameterMap = (ParameterMap)ratioMap.get("");
        }
        ArrayList<Ratio> result = new ArrayList<Ratio>();
        for (ListItem listItem : this.getSelectedPayTypes()) {
            String id = String.valueOf(listItem.getId());
            ElkomPaymentType type = null;
            if (parameterMap != null) {
                int code = parameterMap.getInt(id, -1);
                type = ElkomPaymentType.getType((int)code);
            }
            result.add(new Ratio(Utils.parseInt((String)id), listItem.getTitle(), (RatioDescription)(type == null ? ElkomPaymentType.BANK_TRANSACTION : type)));
        }
        this.ratioPanel.setDataTable(result);
    }

    @Override
    public void setPaymentRatio(Preferences config) {
        for (Ratio ratio : this.ratioPanel.getRatioList()) {
            config.set("sorm.upload.paytype.ratio." + ratio.getId(), String.valueOf(ratio.getRatioDescription().getCode()));
        }
    }
}

