/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.packer.server.service;

import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.packer.common.bean.PackerKit;
import ru.bitel.bgbilling.plugins.packer.common.bean.PackerOptionLibrary;
import ru.bitel.bgbilling.plugins.packer.common.service.PackerService;
import ru.bitel.bgbilling.plugins.packer.server.bean.PackerKitDao;
import ru.bitel.bgbilling.plugins.packer.server.bean.PackerOptionLibraryDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.packer.common.service.PackerService")
public class PackerServiceImpl
extends AbstractService
implements PackerService {
    public List<PackerKit> packerKitList() throws BGException {
        try (PackerKitDao packerKitDao = new PackerKitDao(this.getConnection());){
            List<PackerKit> list = packerKitDao.list();
            return list;
        }
    }

    public PackerKit packerKitGet(int packerKitId) throws BGException {
        try (PackerKitDao packerKitDao = new PackerKitDao(this.getConnection());){
            PackerKit packerKit = (PackerKit)packerKitDao.get(packerKitId);
            return packerKit;
        }
    }

    public int packerKitUpdate(PackerKit packerKit) throws BGException {
        try (PackerKitDao packerKitDao = new PackerKitDao(this.getConnection());){
            packerKitDao.update(packerKit);
            int n = packerKit.getId();
            return n;
        }
    }

    public int packerKitDelete(int packerKitId) throws BGException, BGMessageException {
        try (PackerKitDao packerKitDao = new PackerKitDao(this.getConnection());){
            int n = packerKitDao.delete(packerKitId);
            return n;
        }
    }

    public SearchResult<PackerOptionLibrary> searchPackerOptionLibraryList(String title, Page page) throws BGException, BGMessageException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        try (PackerOptionLibraryDao optionLibraryDao = new PackerOptionLibraryDao(this.getConnection());){
            optionLibraryDao.searchPackerOptionLibraryList((SearchResult<PackerOptionLibrary>)searchResult, title);
        }
        return searchResult;
    }

    public void packerOptionLibraryUpdate(PackerOptionLibrary packerOptionLibrary) throws BGException, BGMessageException {
        try (PackerOptionLibraryDao optionLibraryDao = new PackerOptionLibraryDao(this.getConnection());){
            optionLibraryDao.update(packerOptionLibrary);
        }
    }

    public void packerOptionLibraryDelete(int packerOptionLibraryId) throws BGException, BGMessageException {
        try (PackerOptionLibraryDao optionLibraryDao = new PackerOptionLibraryDao(this.getConnection());){
            optionLibraryDao.delete(packerOptionLibraryId);
        }
    }
}

