/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.model;

import jakarta.xml.bind.annotation.XmlAttribute;
import org.json.JSONObject;
import org.w3c.dom.Element;
import ru.bitel.common.Utils;

public class Page {
    public static final Page INFINITE = new Page(0, Integer.MAX_VALUE);
    public static final String RECORD_COUNT = "recordCount";
    public static final String PAGE_COUNT = "pageCount";
    public static final String PAGE_INDEX = "pageIndex";
    public static final String PAGE_SIZE = "pageSize";
    private int pageSize = 0;
    private int pageIndex = 0;
    private int pageCount = 0;
    private int recordCount = 0;

    public Page() {
    }

    public Page(int pageIndex, int pageSize) {
        this.pageSize = pageSize;
        this.pageIndex = pageIndex;
    }

    @XmlAttribute
    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    @XmlAttribute
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @XmlAttribute
    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getPageFirstRecordNumber() {
        return this.getPageIndex() <= 0 ? 0 : (this.getPageIndex() - 1) * this.getPageSize();
    }

    @XmlAttribute
    public int getRecordCount() {
        return this.recordCount;
    }

    public Page setRecordCount(int recordCount) {
        this.recordCount = recordCount;
        this.pageCount = recordCount > 0 && this.pageSize > 0 ? (int)Math.ceil((double)recordCount / (double)this.pageSize) : 1;
        return this;
    }

    public String sqlLimit() {
        StringBuilder result = new StringBuilder(40);
        if (this.pageIndex > 0 && this.pageSize > 0) {
            result.append(" LIMIT ");
            result.append(this.pageSize);
            result.append(" OFFSET ");
            result.append(this.getPageFirstRecordNumber());
        }
        return result.toString();
    }

    public static int getRecordCount(Element element) {
        int result = -1;
        if (element != null) {
            result = Utils.parseInt(element.getAttribute(RECORD_COUNT), -1);
        }
        return result;
    }

    public static int getPageIndex(Element element) {
        int result = -1;
        if (element != null) {
            result = Utils.parseInt(element.getAttribute(PAGE_INDEX), 1);
        }
        return result;
    }

    public static int getPageSize(Element element) {
        int result = -1;
        if (element != null) {
            result = Utils.parseInt(element.getAttribute(PAGE_SIZE), -1);
        }
        return result;
    }

    public static int getPageCount(Element element) {
        int result = -1;
        if (element != null) {
            result = Utils.parseInt(element.getAttribute(PAGE_COUNT), 1);
        }
        return result;
    }

    public static JSONObject toJson(Page page) {
        JSONObject pageJsonObject = new JSONObject();
        if (page != null) {
            pageJsonObject.put(PAGE_INDEX, page.getPageIndex());
            pageJsonObject.put(PAGE_SIZE, page.getPageSize());
            pageJsonObject.put(PAGE_COUNT, page.getPageCount());
            pageJsonObject.put(RECORD_COUNT, page.getRecordCount());
        }
        return pageJsonObject;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{ \"pageSize\" : ");
        buf.append(this.pageSize);
        buf.append(", \"pageIndex\" : ");
        buf.append(this.pageIndex);
        buf.append(", \"pageCount\" : ");
        buf.append(this.pageCount);
        buf.append(", \"recordCount\" : ");
        buf.append(this.recordCount);
        buf.append(" }");
        return buf.toString();
    }
}

