/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.updater.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.updater.common.bean.UpdaterTask;
import ru.bitel.bgbilling.kernel.updater.common.bean.UpdaterTaskLog;
import ru.bitel.bgbilling.kernel.updater.common.bean.UpdaterTaskLogStatus;
import ru.bitel.bgbilling.kernel.updater.common.service.UpdaterTaskService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class UpdaterTaskTabPanel
extends BGUTabPanel {
    public static final String TAB_ID = "updater";
    private JTextArea log = null;
    private RunLogTableModel logTableModel = null;
    private JPanel list = new JPanel(new GridBagLayout());
    private BGControlPanelPages pages = new BGControlPanelPages();
    private UpdaterTaskService updaterTaskService = null;

    public UpdaterTaskTabPanel() {
        this(new ClientContext("kernel.update", 0, 0, ""));
    }

    public UpdaterTaskTabPanel(ClientContext clientContext) {
        super(clientContext, TAB_ID, "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f");
        new AbstractBGUPanel.BGActionRefresh(e -> {
            SearchResult<UpdaterTask> searchResult = this.getUpdaterTaskService().searchUpdaterTask(null, this.pages.getPage());
            this.pages.setPage(searchResult.getPage());
            int gridy = 0;
            Color bgColor = new JList().getBackground();
            for (UpdaterTask updaterTask : searchResult.getList()) {
                this.list.add((Component)this.getItemListPanel(updaterTask, bgColor), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            }
            this.list.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                UpdaterTaskTabPanel.this.performAction("refresh");
            }
        });
    }

    private JPanel getItemListPanel(UpdaterTask updaterTask, Color bgColor) {
        JLabel idLabel = new JLabel((String)(updaterTask.getId() > 0 ? " [#" + updaterTask.getId() + "]" : ""));
        JLabel dateLabel = new JLabel("\u0417\u0430\u043f\u0443\u0441\u043a: " + TimeUtils.formatFullDate(updaterTask.getRunDate()));
        JLabel titleLabel = new JLabel(updaterTask.getTitle());
        JTextArea commentLabel = new JTextArea(2, 2);
        commentLabel.setText(updaterTask.getComment());
        commentLabel.setFont(new Font("SansSerif", 2, 11));
        commentLabel.setForeground(new Color(150, 150, 150));
        commentLabel.setLineWrap(true);
        commentLabel.setWrapStyleWord(true);
        commentLabel.setEditable(false);
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.setOpaque(false);
        titlePanel.add((Component)titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        titlePanel.add((Component)dateLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        titlePanel.add((Component)idLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 20, 3, 3), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(bgColor);
        panel.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)commentLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 30, 3, 3), 0, 0));
        return panel;
    }

    private UpdaterTaskService getUpdaterTaskService() {
        if (this.updaterTaskService == null) {
            this.updaterTaskService = ((ClientContext)this.getContext()).getPort(UpdaterTaskService.class);
        }
        return this.updaterTaskService;
    }

    @Override
    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPaneNoBorder = new BGSplitPaneNoBorder(1, this.getUpdaterListPanel(), (Component)this.getUpdaterLogPanel(), 1000L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPaneNoBorder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getUpdaterListPanel() {
        final JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension d = scrollPane.getViewport().getSize();
                int height = 0;
                for (Component component : UpdaterTaskTabPanel.this.list.getComponents()) {
                    if (!(component instanceof JPanel)) continue;
                    height += component.getHeight() + 10;
                }
                UpdaterTaskTabPanel.this.list.setPreferredSize(new Dimension(d.width, height));
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("\u0421\u043f\u0438\u0441\u043e\u043a \u0437\u0430\u0434\u0430\u043d\u0438\u0439"));
        panel.add((Component)this.getUpdaterListFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getUpdaterListFilterPanel() {
        BGUComboBox<UpdaterTaskLogStatus> status = new BGUComboBox<UpdaterTaskLogStatus>();
        status.setData(Arrays.asList(UpdaterTaskLogStatus.values()));
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(status, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.pages, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getUpdaterLogPanel() {
        BGSplitPaneNoBorder splitPaneNoBorder = new BGSplitPaneNoBorder(0, this.getRunLogPanel(), (Component)this.getLogPanel(), 300L);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)splitPaneNoBorder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getRunLogPanel() {
        this.logTableModel = new RunLogTableModel(RunLogTableModel.class.getName());
        BGUTable logTable = new BGUTable(this.logTableModel);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("\u041b\u043e\u0433 \u0437\u0430\u043f\u0443\u0441\u043a\u0430(\u043e\u0432)"));
        panel.add((Component)new JScrollPane(logTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getLogPanel() {
        this.log = new JTextArea(10, 50);
        this.log.setMargin(new Insets(3, 3, 3, 3));
        this.log.setLineWrap(true);
        this.log.setWrapStyleWord(true);
        this.log.setEditable(false);
        Dimension dimension = new Dimension(300, 300);
        JScrollPane scrollPane = new JScrollPane(this.log);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("\u041b\u043e\u0433 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f"));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    class RunLogTableModel
    extends BGTableModel<UpdaterTaskLog> {
        public RunLogTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430", 180, 180, 180, "runDate", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, -1, -1, "status", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 200, 200, 200, "userId", true, HorizontalAlignmentTableCellRenderer.CENTER());
        }

        @Override
        public Object getValue(UpdaterTaskLog value, int columnIndex) throws BGException {
            String identifier = this.getIdentifier(columnIndex);
            if ("status".equals(identifier)) {
                return value.getStatus().getTitle();
            }
            return super.getValue(value, columnIndex);
        }
    }
}

