/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.server.TaskExecuter;
import ru.bitel.common.XMLUtils;

public class TaskCache {
    private static final Logger logger = LogManager.getLogger();
    private static TaskCache instance;
    private Map<String, Map<String, String>> moduleAndPluginTaskMap = new HashMap<String, Map<String, String>>();
    private Map<String, String> allTaskMap = new HashMap<String, String>();

    public static final TaskCache getInstance() throws BGException {
        if (instance == null) {
            instance = new TaskCache();
        }
        return instance;
    }

    private TaskCache() throws BGException {
        this.loadTasks();
    }

    private void loadTasks() throws BGException {
        String title;
        String clazz;
        logger.debug("Load module tasks into task cache...");
        Map<Integer, BGModule> moduleMap = ModuleCache.getInstance().getModuleMap();
        Iterator<Object> iterator = moduleMap.keySet().iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            BGModule module = moduleMap.get(i);
            HashMap<String, String> taskMap = new HashMap<String, String>();
            Map<String, Element> extensionMap = module.getInstalledModule().getServerExtensionMap();
            if (extensionMap == null || !extensionMap.containsKey(TaskExecuter.class.getName())) continue;
            for (Element elem : XMLUtils.selectElements(extensionMap.get(TaskExecuter.class.getName()), "//task")) {
                String clazz2 = elem.getAttribute("class");
                String title2 = elem.getAttribute("title");
                taskMap.put(clazz2, title2);
                this.createTaskDescription(clazz2, title2);
            }
            this.moduleAndPluginTaskMap.put(String.valueOf(module.getId()), taskMap);
        }
        for (BGPlugInElement plugInElement : BGPluginManagerServer.getManager().getExtensions(TaskExecuter.class.getName(), false)) {
            HashMap<String, String> taskMap = new HashMap<String, String>();
            for (Element elem : XMLUtils.selectElements(plugInElement.getElement(), "//task")) {
                clazz = elem.getAttribute("class");
                title = elem.getAttribute("title");
                taskMap.put(clazz, title);
                this.createTaskDescription(clazz, title);
            }
            this.moduleAndPluginTaskMap.put("p" + ((BGPluginServer)plugInElement.getPlugin()).getPluginUID(), taskMap);
        }
        try {
            InputStream inputStream = this.getClass().getResource("/ru/bitel/bgbilling/kernel/task/server/kernel.xml").openStream();
            HashMap<String, String> kernelTasks = new HashMap<String, String>();
            if (inputStream != null) {
                Document doc = XMLUtils.parseDocument(new InputSource(inputStream));
                for (Element task : XMLUtils.selectElements(doc.getDocumentElement(), "/module/extension/task")) {
                    clazz = task.getAttribute("class");
                    title = task.getAttribute("title");
                    kernelTasks.put(clazz, title);
                    this.createTaskDescription(clazz, title);
                }
            }
            this.moduleAndPluginTaskMap.put("0", kernelTasks);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private void createTaskDescription(String clazz, String title) {
        if (!this.allTaskMap.containsKey(clazz)) {
            this.allTaskMap.put(clazz, title);
        }
    }

    public Map<String, String> getModuleTasks(String moduleId) {
        return this.moduleAndPluginTaskMap.get(moduleId);
    }

    public Map<String, Map<String, String>> getModuleAndPluginTasks() {
        return this.moduleAndPluginTaskMap;
    }

    public String getTaskDescription(String taskClass) {
        return this.allTaskMap.get(taskClass);
    }

    public Map<String, String> getTaskMap() {
        return this.allTaskMap;
    }

    public boolean isKernelTask(String classId) {
        boolean result = false;
        Map<String, String> kernelTasks = this.moduleAndPluginTaskMap.get("0");
        if (kernelTasks.containsKey(classId)) {
            result = true;
        }
        return result;
    }

    public boolean isPluginTask(String classId) {
        boolean result = false;
        for (String moduleId : this.moduleAndPluginTaskMap.keySet()) {
            Map<String, String> taskMap;
            if (moduleId.startsWith("p") && (taskMap = this.moduleAndPluginTaskMap.get(moduleId)).containsKey(classId)) {
                result = true;
                break;
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    public String getPluginUid(String classId) {
        String result = "";
        for (String keyMid : this.moduleAndPluginTaskMap.keySet()) {
            if (!keyMid.startsWith("p")) continue;
            Map<String, String> pluginTaskMap = this.moduleAndPluginTaskMap.get(keyMid);
            for (String pluginKey : pluginTaskMap.keySet()) {
                if (!pluginKey.equals(classId)) continue;
                result = keyMid;
            }
        }
        return result;
    }

    public void reloadTasks() throws BGException {
        logger.debug("Reload scheduler tasks in task cache...");
        this.loadTasks();
    }
}

